/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.io.*;
import java.util.Date;

import javax.activation.*;
import javax.mail.*;
import javax.mail.internet.*;

import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;
import jp.co.connectone.store.client.AttachmentDataSource;

public class BasicMailDTO extends BasicRecordObject implements IMailDTO
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	protected HeaderDTO header = null;
	protected String body = null;
	protected AttachmentDTO[] attachments = null;

	public BasicMailDTO()
	{
		header = null;
	};

	public BasicMailDTO(HeaderDTO header)
	{
		this.header = header;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getBCC()
	 */
	public MailAddress[] getBCC()
	{
		return header.getHeaderBCC();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getCC()
	 */
	public MailAddress[] getCC()
	{
		return header.getHeaderCC();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getFrom()
	 */
	public MailAddress getFrom()
	{
		return header.getHeaderFrom();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getPriority()
	 */
	public int getPriority()
	{
		return header.getHeaderPriority();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getReplyTo()
	 */
	public MailAddress getReplyTo()
	{
		return header.getHeaderReplyTo();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getSentDate()
	 */
	public Date getSentDate()
	{
		return header.getHeaderSendDate();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getSentDate()
	 */
	public Date getReceivedDate()
	{
		return header.getHeaderReceivedDate();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getSize()
	 */
	public int getSize()
	{
		return header.getHeaderSize();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getSubject()
	 */
	public String getSubject()
	{
		return header.getHeaderSubject();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#getTo()
	 */
	public MailAddress[] getTo()
	{
		return header.getHeaderTo();
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#setBCC(jp.co.connectone.store.pim.MailAddress[])
	 */
	public void setBCC(MailAddress[] bcc)
	{
		header.setHeaderBCC(bcc);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#setCC(jp.co.connectone.store.pim.MailAddress[])
	 */
	public void setCC(MailAddress[] cc)
	{
		header.setHeaderCC(cc);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#setFrom(jp.co.connectone.store.pim.MailAddress)
	 */
	public void setFrom(MailAddress from)
	{
		header.setHeaderFrom(from);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#setPriority(int)
	 */
	public void setPriority(int priority)
	{
		header.setHeaderPriority(priority);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#setReplyTo(jp.co.connectone.store.pim.MailAddress)
	 */
	public void setReplyTo(MailAddress replyTo)
	{
		header.setHeaderReplyTo(replyTo);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#setSentDate(java.util.Date)
	 */
	public void setSentDate(Date date)
	{
		header.setHeaderSendDate(date);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#setSize(int)
	 */
	public void setSize(int size)
	{
		header.setHeaderSize(size);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#setSubject(java.lang.String)
	 */
	public void setSubject(String subject)
	{
		header.setHeaderSubject(subject);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see jp.co.connectone.store.pim.IMailDTO#setTo(jp.co.connectone.store.pim.MailAddress[])
	 */
	public void setTo(MailAddress[] to)
	{
		header.setHeaderTo(to);
	}

	/**
	 * This method gets message body.
	 * 
	 * @return body body of the message
	 */
	public String getBody()
	{
		return body;
	}

	/**
	 * This method gets number of attachments of the message.
	 * 
	 * @return numOfAttachments number of attachments
	 */

	public int getNumberOfAttachments()
	{
		if (attachments == null)
			return 0;
		return attachments.length;
	}

	/**
	 * This method gets attachment by index value.
	 * 
	 * @param number
	 *            index value
	 * @return attachments attachment by index
	 */
	public AttachmentDTO getAttachment(int number)
	{
		return attachments[number];
	}

	/**
	 * This method gets header of the message.
	 * 
	 * @return header header object
	 */
	public HeaderDTO getHeader()
	{
		return header;
	}

	/**
	 * @return
	 */
	public String getMailBinary()
	{
		String rc = "";
		if (attachments == null) {
			return body;
		}
		try {
			MimeMessage msg = new MimeMessage((Session) null);
			MimeMultipart part = new MimeMultipart();
			MimeBodyPart body = new MimeBodyPart();
			body.setText(this.body);
			part.addBodyPart(body);

			for (int i = 0; i < attachments.length; i++) {
				MimeBodyPart attach = new MimeBodyPart();
				attach.setDataHandler(new DataHandler(new AttachmentDataSource(attachments[i])));
				attach.setFileName(attachments[i].getFileName());
				part.addBodyPart(attach);
			}

			msg.setContent(part);
			msg.saveChanges();

			rc = "MIME-Version: 1.0\r\nContent-Type: " + msg.getHeader("Content-Type", null) + "\r\n\r\n";
			InputStream is = msg.getInputStream();
			BufferedReader b = new BufferedReader(new InputStreamReader(is));
			String tmp;
			while ((tmp = b.readLine()) != null) {
				rc = rc + tmp + "\n";
			}

		}
		catch (Exception e) {
			Log.error("Exception on creating MimeMessage",e);
		}
		return rc;
	}

	/**
	 * This method sets body to BasicMailDTO.
	 * 
	 * @param body
	 *            message body
	 */
	public void setBody(String body)
	{
		this.body = body;
	}

	/**
	 * This method sets HeaderDTO to BasicMailDTO.
	 * 
	 * @param header
	 *            HeaderDTO object
	 */
	public void setHeaderDTO(HeaderDTO header)
	{
		this.header = header;
	}

	/**
	 * This method sets attachments to BasicMailDTO
	 * 
	 * @param attachments
	 *            byte stream of attachments
	 */
	public void setAttachments(AttachmentDTO[] attachments)
	{
		this.attachments = attachments;
	}

	/**
	 * @return attachments ߂܂B
	 */
	public AttachmentDTO[] getAttachments()
	{
		return attachments;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		String rc = super.toString();
		if (header != null) {
			rc = rc + ":" + header.getHeaderUIDL() + ":" + header.getHeaderSubject();
		}
		if (getNumberOfAttachments() > 0) {
			rc = rc + " attachments:" + getNumberOfAttachments();
		}
		return rc;
	}

	/**
	 * @deplaced Object oid is replaced with IObjectIndex interface
	 * @see jp.co.connectone.store.client.IMailDTO#getObjectIndex()
	 */
	public IObjectIndex getOid()
	{
		if (header == null)
			return null;
		return header.getOid();
	}

	/**
	 * @deplaced Object oid is replaced with IObjectIndex interface
	 * @see jp.co.connectone.store.client.IMailDTO#setObjectIndex(IObjectIndex)
	 */
	public void setOid(IObjectIndex oid)
	{
		if (header == null) {
			header = new HeaderDTO();
		}
		header.setOid(oid);
	}


}// end BasicMailDTO
