import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import jp.co.connectone.eai.notes.store.*;
import jp.co.connectone.eai.notes.user.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.*;
import jp.co.connectone.user.*;
import junit.framework.TestCase;


public class NotesDBStoreImplTest extends TestCase
{
	private static final String server="172.16.5.1";
	private static final String db="SJR\\park.nsf";
	private static final String id="FOO BAR";
	private static final String pass="password";
	private static final String view="ViewMobileFECONT1";
	private NotesDBStoreImpl store;
	private NotesServiceInfo si;
	private NotesAccountData acc;
	protected void setUp() throws Exception
	{
		store = new NotesDBStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		si = (NotesServiceInfo)store.getServiceInfo();
		si.setServerAddress(server);
		acc = new NotesAccountData(uid,si);
		acc.setUserID(id);
		acc.setInternetPassword(pass);
	}
	
	public void testGetServiceInfo() throws Exception
	{
		NotesServiceInfo tsi = (NotesServiceInfo)store.getServiceInfo();
		assertNotNull(tsi);
		assertEquals(tsi.getName(), NotesConstants.DBSTORE_NAME);
	}
	
	public void testGetName() throws Exception
	{
		String name = store.getName();
		assertEquals(name, si.getName());
	}
	
	public void testGetTableIndexFromString() throws Exception
	{
		assertNotNull(store);
		IFolderIndex f = (IFolderIndex)store.getTableIndexFromString(view).getOid();
		assertNotNull(f);
		assertEquals(f.getIndex().toString(), view);
		
	}


	public void testGetFolderList() throws Exception
	{
		try {
			assertNotNull(store);
			IDatabaseIndex d = new NotesDatabaseIndex(db);
			ISearchDestination dest = new BasicSearchDestination(d,null);
			FolderMetadata[] m = store.getFolderList(acc,dest);
			assertNotNull(m);
			for (int i=0;i<m.length;i++) {
				dumpRO(m[i]);
			}
			
		}
		catch(Exception e) {
			e.printStackTrace();
			throw e;
		}
		
	}

	public void testGetAllDatas() throws Exception
	{
		try {
			assertNotNull(store);
			IFolderIndex f = (IFolderIndex)store.getTableIndexFromString(view).getOid();
			IDatabaseIndex d = new NotesDatabaseIndex(db);
			ISearchDestination dest = new BasicSearchDestination(d,f);
			IRecordObject[] m = null;
			for (int i=0;i<5;i++) {
				m = store.getAllDatas(acc,dest);
				assertNotNull(m);
			}
			for (int i=0;i<m.length;i++) {
				dumpRO(m[i]);
			}
			
		}
		catch(Exception e) {
			e.printStackTrace();
			throw e;
		}
		
	}
	
	public void testRead() throws Exception
	{
		assertNotNull(store);
		IFolderIndex f = (IFolderIndex)store.getTableIndexFromString(view).getOid();
		IDatabaseIndex d = new NotesDatabaseIndex(db);
		ISearchDestination dest = new BasicSearchDestination(d,f);
		IObjectIndex oid = new NotesObjectIndex("A1B784FBA07A1CD24925736F002462FE");
		IRecordObject ro = store.read(acc,dest,oid);
		assertNotNull(ro);
		Log.debug("--------read-------");
		dumpRO(ro);

	}

	public void dumpRO(IRecordObject ro) throws Exception
	{
		BasicRecordObject r = (BasicRecordObject)ro;
		Log.debug("------"+r.getOid().getIndex().toString()+"------");
		HashMap<String,Object> h = r.getFieldSet();
		Set<String> keySet = h.keySet();
		Iterator<String> it = keySet.iterator();
		while (it.hasNext()) {
			String name = (String)it.next();
			Log.debug(name+":"+h.get(name));
		}
	}
}
