/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.dav;

import java.io.*;
import java.util.*;

import jp.co.connectone.eai.exch2k.dav.ms.XmsEnumattsMethod;
import jp.co.connectone.log.Log;

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.util.*;
import org.apache.webdav.lib.*;
import org.apache.webdav.lib.methods.*;
import org.apache.commons.httpclient.methods.*;

/**
 * @author amanot
 *
 */
public class ExWebdavResource extends WebdavResource {
	public static final String DEFAULT_CHARSET="Windows-31J";
	public static final String FROM_CLAUSE_WITH_DEPTH_1 = " FROM SCOPE('SHALLOW TRAVERSAL OF \".\"') ";
	public static final String FROM_CLAUSE_WITH_DEPTH_INFINITY = " FROM SCOPE('DEEP TRAVERSAL OF \".\"') ";
	private String charSet;
	private NTCredentials credentials;
	public ExWebdavResource(String url,NTCredentials cred) throws HttpException,IOException
	{
		super( url ,cred);
		charSet = DEFAULT_CHARSET;
		credentials = cred;
	}
	
	/**
	 * @return charSet ߂܂B
	 */
	public String getCharSet() {
		return charSet;
	}
	/**
	 * @param charSet charSet ݒB
	 */
	public void setCharSet(String charSet) {
		this.charSet = charSet;
	}
	
	/* ( Javadoc)
	 * @see org.apache.webdav.lib.WebdavResource#getMethodDataAsString(java.lang.String)
	 */
	public String getMethodDataAsString(String path) throws HttpException,IOException 
	{
		setClient();
		
		GetMethod method = new GetMethod(path);
		method.setFollowRedirects(false);
		method.setDoAuthentication(true);
		method.setRequestHeader("Content-type", "text/xml; charset='utf-8'");
		method.setRequestHeader("Translate", "f");
		method.setRequestHeader("Depth", "1,noroot");
		client.getState().setCredentials(null,null,credentials);
		
		client.executeMethod(method);
		
		String retStr = method.getResponseBodyAsString();
		String receivedCharSet = method.getRequestCharSet();
Log.debug("charSet-info from header:" + receivedCharSet);

		retStr = new String(retStr.getBytes("iso-8859-1"),charSet);
		
		return retStr;

	}
	
	/* ( Javadoc)
	 * @see org.apache.webdav.lib.WebdavResource#getMethodData()
	 */
	public InputStream getMethodData(String path) throws HttpException, IOException {
		setClient();
		
		GetMethod method = new GetMethod(path);
		method.setFollowRedirects(false);
		method.setDoAuthentication(true);
		method.setRequestHeader("Content-type", "text/xml; charset='utf-8'");
		method.setRequestHeader("Translate", "f");
//		method.setRequestHeader("Depth", "1,noroot");
		method.setRequestHeader("Depth", "0");
		client.getState().setCredentials(null,null,credentials);
		
		client.executeMethod(method);
		
		InputStream is = method.getResponseBodyAsStream();
		return is;
	}
	
	/* ( Javadoc)
	 * @see org.apache.webdav.lib.WebdavResource#getMethodData()
	 */
	public boolean putMethod(String escapedUrl,String msg) throws HttpException, IOException {
		setClient();
		String escapedPath = escapedUrl;
		PutMethod method = new PutMethod(escapedPath);
		method.setFollowRedirects(false);
		method.setDoAuthentication(true);
		method.setRequestBody(msg);
		method.setRequestContentLength(msg.length());

		client.getState().setCredentials(null,null,credentials);
		
		client.executeMethod(method);
		super.setStatusCode(method.getStatusCode());
		super.setHttpURL(URIUtil.decode(escapedPath));
		
//		InputStream is = method.getResponseBodyAsStream();
		return true;
	}
	
	@SuppressWarnings("unchecked")
	public HashMap xmsEnumAttsMethod() throws HttpException,IOException
	{
		return xmsEnumAttsMethod("");
	}
	
	/**
	 * 
	 * @param addPath
	 * @return
	 * @throws HttpException
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public HashMap xmsEnumAttsMethod(String addPath) throws HttpException,IOException
	{
		setClient();

		XmsEnumattsMethod atts = new XmsEnumattsMethod(super.getHttpURL().getEscapedPath() + addPath);
		client.getState().setCredentials(null,null,credentials);
		client.executeMethod(atts);
Log.debug("xmsEnumAttsMethod::code=" + atts.getStatusCode());
		Enumeration ret = atts.getAllResponseURLs();
		HashMap rc = new HashMap();
		while (ret.hasMoreElements()) {
			String url = (String)ret.nextElement();
			Enumeration xmlElement = atts.getResponseProperties(url);
			rc.put(url,xmlElement);
		}
		return rc;
	}
	
	@SuppressWarnings("unchecked")
	public Enumeration searchFolderMethod(String addPath, int depth,Vector v) throws HttpException,IOException
	{
		String searchSQL = "SELECT ";
		Enumeration e = v.elements();
		while (e.hasMoreElements()) {
			String elemName = (String)e.nextElement();
			String alias = elemName.substring(elemName.lastIndexOf(":")+1);
			searchSQL = searchSQL + "\"" + elemName + "\" as \""+ alias + "\","; 
		}
		String from_clause = FROM_CLAUSE_WITH_DEPTH_1;
		if (depth == DepthSupport.DEPTH_INFINITY) {
			from_clause = FROM_CLAUSE_WITH_DEPTH_INFINITY;
		}
		searchSQL = searchSQL.substring(0,searchSQL.length()-1) + from_clause + " WHERE \"DAV:ishidden\" = false AND \"DAV:isfolder\" = true ";
Log.debug("searchsql="+searchSQL);		
		
		String queryXML = "<D:searchrequest xmlns:D = \"DAV:\" ><D:sql>" + searchSQL + "</D:sql></D:searchrequest>";
		setClient();

		SearchMethod search = new SearchMethod(super.getHttpURL().getEscapedPath() + addPath, queryXML);
		search.setRequestHeader("Content-Length", "" + queryXML.length());
		search.setRequestHeader("Translate", "f");
		search.setRequestHeader("Accept-Language", "ja");
		client.getState().setCredentials(null,null,credentials);

		client.executeMethod(search);

		Log.debug("code=" + search.getStatusCode());
//		org.w3c.dom.Document doc = search.getResponseDocument();
		Enumeration ret = search.getAllResponseURLs();
		Vector retv = new Vector();
		while (ret.hasMoreElements()) {
			Enumeration xmlElement = search.getResponseProperties((String)ret.nextElement());
			retv.add(xmlElement);
		}
		return retv.elements();
		
	}
	
	/**
	 * 
	 * @param depth
	 * @param v
	 * @return
	 * @throws HttpException
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public Enumeration searchPropMethod(int depth,Vector v) throws HttpException,IOException
	{
		return searchPropMethod("", depth, v);
	}
	
	/**
	 * 
	 * @param addPath  Path in back from Sharp
	 * @param depth
	 * @param v
	 * @return
	 * @throws HttpException
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public Enumeration searchPropMethod(String addPath, int depth,Vector v) throws HttpException,IOException 
	{
		String searchSQL = generageSQL(depth, v, null);
Log.debug("searchsql="+searchSQL);		
//		String queryXML = "<?xml version=\"1.0\"?><D:searchrequest xmlns:D = \"DAV:\" ><D:sql>" + searchSQL + "</D:sql></D:searchrequest>";//OWAłXMLvtBNXȂ
		String queryXML = "<D:searchrequest xmlns:D = \"DAV:\" ><D:sql>" + searchSQL + "</D:sql></D:searchrequest>";
		setClient();
		
		SearchMethod search = new SearchMethod(super.getHttpURL().getEscapedPath() + addPath, queryXML);
		search.setRequestHeader("Content-Length", "" + queryXML.length());
		search.setRequestHeader("Translate", "f");
		search.setRequestHeader("Accept-Language", "ja");
		client.getState().setCredentials(null,null,credentials);
		
		client.executeMethod(search);
		
		Log.debug("code=" + search.getStatusCode());
//		org.w3c.dom.Document doc = search.getResponseDocument();
		Enumeration ret = search.getAllResponseURLs();
		Vector retv = new Vector();
		while (ret.hasMoreElements()) {
			Enumeration xmlElement = search.getResponseProperties((String)ret.nextElement());
			retv.add(xmlElement);
		}
		return retv.elements();
//		return search.getResponseDocument();
//		return search.getResponseBodyAsStream();
	}

	/**
	 * 
	 * @param depth
	 * @param v
	 * @param searchConditions
	 * @return
	 * @throws HttpException
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public Enumeration searchPropMethod(int depth,Vector v,Vector searchConditions) throws HttpException,IOException
	{
		return searchPropMethod("", depth, v, searchConditions);
	}
	
	/**
	 * 
	 * @param addPath  Path in back from Sharp
	 * @param depth
	 * @param v
	 * @param searchConditions
	 * @return
	 * @throws HttpException
	 * @throws IOException
	 */
	@SuppressWarnings("unchecked")
	public Enumeration searchPropMethod(String addPath, int depth,Vector v,Vector searchConditions) throws HttpException,IOException 
	{
		String searchSQL = generageSQL(depth, v, searchConditions);
		
Log.debug("searchsql="+searchSQL);		
//		String queryXML = "<?xml version=\"1.0\"?><D:searchrequest xmlns:D = \"DAV:\" ><D:sql>" + searchSQL + "</D:sql></D:searchrequest>";//OWAłXMLvtBNXȂ
		String queryXML = "<D:searchrequest xmlns:D = \"DAV:\" ><D:sql>" + searchSQL + "</D:sql></D:searchrequest>                    ";//}`oCg̃T[oJEgɖ肪悤Ȃ̂Ŗɋ󔒂ăobt@[Ƃ
		setClient();
		
		SearchMethod search = new SearchMethod(super.getHttpURL().getEscapedPath() + addPath, queryXML);
		search.setRequestHeader("Content-Length", "" + queryXML.length());
		search.setRequestHeader("Translate", "f");
		search.setRequestHeader("Accept-Language", "ja");

		client.getState().setCredentials(null,null,credentials);
		
		client.executeMethod(search);

		Log.debug("code=" + search.getStatusCode());
//		org.w3c.dom.Document doc = search.getResponseDocument();
		Enumeration ret = search.getAllResponseURLs();
		Vector retv = new Vector();
		while (ret.hasMoreElements()) {
			Enumeration xmlElement = search.getResponseProperties((String)ret.nextElement());
			retv.add(xmlElement);
		}
		return retv.elements();
//		return search.getResponseDocument();
//		return search.getResponseBodyAsStream();
	}

	@SuppressWarnings("unchecked")
	public boolean propPatchMethod(String base,String url,Hashtable properties) throws HttpException,IOException 
	{
//		url = URIUtil.encodePath(url,"UTF-8");
Log.debug("propPatchMethod:url="+url);
		ExPropPatchMethod patch = new ExPropPatchMethod(base);
		patch.setPath(url);

		Enumeration names = properties.keys();
		while (names.hasMoreElements()) {
			String name = (String)names.nextElement();
			String value = (String)properties.get(name);
			patch.addPropertyToSet(name,value);
		}
		patch.setRequestHeader("Translate", "f");
		patch.setRequestHeader("Accept-Language", "ja");

		client.getState().setCredentials(null,null,credentials);
		
		client.executeMethod(patch);
		int statusCode = patch.getStatusCode();
Log.debug("code=" + statusCode);
		
        if (statusCode >= 200 && statusCode < 300) {
            return true;
        }
        return false;
		
	}
	
	@SuppressWarnings("unchecked")
	public boolean propPatchMethod(String base,Hashtable properties) throws HttpException,IOException 
	{
		return propPatchMethod(base,super.getHttpURL().getEscapedPath(),properties);
		
	}

	/**
	 * @param depth
	 * @param v
	 * @param searchConditions
	 * @return
	 */
	@SuppressWarnings("unchecked")
	private String generageSQL(int depth, Vector v, Vector searchConditions) {
		String searchSQL = "SELECT ";
		Enumeration e = v.elements();
		while (e.hasMoreElements()) {
			String elemName = (String)e.nextElement();
			Log.debug("elemName="+elemName);
			String alias = elemName.substring(elemName.lastIndexOf(":")+1);
			if (elemName.indexOf("http://")>=0) {
				// in case schema type "http://schemas.microsoft.com/"
				alias = elemName.substring(elemName.lastIndexOf("/")+1);
			}
			searchSQL = searchSQL + "\"" + elemName + "\" as \""+ alias + "\","; 
		}
		String from_clause = FROM_CLAUSE_WITH_DEPTH_1;
		if (depth == DepthSupport.DEPTH_INFINITY) {
			from_clause = FROM_CLAUSE_WITH_DEPTH_INFINITY;
		}
		searchSQL = searchSQL.substring(0,searchSQL.length()-1) + from_clause + " WHERE \"DAV:ishidden\" = false AND \"DAV:isfolder\" = false ";

		if (searchConditions != null) {
			searchSQL = searchSQL + " AND (";
			Enumeration elem = searchConditions.elements();
			while (elem.hasMoreElements()) {
				DavSearchCondition a = (DavSearchCondition)elem.nextElement();
				searchSQL = searchSQL + a.getDavSQLWhereClause() + " AND ";
			}
			searchSQL = searchSQL.substring(0,searchSQL.length()-5) + ") ";
		}
		searchSQL = searchSQL + " ORDER BY \"urn:schemas:httpmail:datereceived\" Desc ";
		return searchSQL;
	}
}
