/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import java.util.HashMap;

import com.microsoft.schemas.exchange.services._2006.types.FolderType;

import jp.co.connectone.store.FolderMetadata;

public class ExchewsFolderMetadata extends FolderMetadata
{
	private static final long serialVersionUID = 1L;
	protected int		childFolderCount=0;
	protected String	folderClass=null;
	protected ExchewsFolderIndex parentFolderId=null;
	protected int		totalCount=0;
	protected int		unreadCount=0;
	
	public int getChildFolderCount()
	{
		return childFolderCount;
	}
	public void setChildFolderCount(int childFolderCount)
	{
		this.childFolderCount = childFolderCount;
	}
	public String getDisplayName()
	{
		return super.getFolderName();
	}
	public void setDisplayName(String displayName)
	{
		super.setFolderName(displayName);
	}
	public String getFolderClass()
	{
		return folderClass;
	}
	public void setFolderClass(String folderClass)
	{
		this.folderClass = folderClass;
	}
	public ExchewsFolderIndex getFolderId()
	{
		return (ExchewsFolderIndex)super.getOid().getIndex();
	}
	public ExchewsFolderIndex getParentFolderId()
	{
		return parentFolderId;
	}
	public void setParentFolderId(ExchewsFolderIndex parentFolderId)
	{
		this.parentFolderId = parentFolderId;
	}
	public int getTotalCount()
	{
		return totalCount;
	}
	public void setTotalCount(int totalCount)
	{
		this.totalCount = totalCount;
	}
	public int getUnreadCount()
	{
		return unreadCount;
	}
	public void setUnreadCount(int unreadCount)
	{
		this.unreadCount = unreadCount;
	}
	
	@Override
	public void setBeanData() throws Exception
	{
		HashMap<String,Object> h = new HashMap<String, Object>();
		h.put("oid", super.getOid());
		h.put("folderName", super.getFolderName());
		h.put("childFolderCount", childFolderCount);
		h.put("folderClass", folderClass);
		h.put("parentFolderId", parentFolderId);
		h.put("totalCount", totalCount);
		h.put("unreadCount", unreadCount);
		setFieldSet(h);
	}
	@Override
	public void setFieldSet(HashMap<String,Object> h)
	{
		fieldSet=h;
	}
	public static ExchewsFolderMetadata convertFromEWSFolderType(FolderType folder) throws Exception
	{
		if (folder==null) return null;
		ExchewsFolderMetadata rc = new ExchewsFolderMetadata();
		rc.setOid(new ExchewsFolderIndex(folder.getFolderId()));
		rc.setFolderName(folder.getDisplayName());
		rc.parentFolderId=new ExchewsFolderIndex(folder.getParentFolderId());
		rc.childFolderCount=folder.getChildFolderCount().intValue();
		rc.totalCount=folder.getTotalCount().intValue();
		rc.unreadCount=folder.getUnreadCount().intValue();
		rc.folderClass=folder.getFolderClass();
		rc.setBeanData();
		return rc;
	}
}
