/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import java.util.Date;

import com.microsoft.schemas.exchange.services._2006.types.ItemType;
import com.microsoft.schemas.exchange.services._2006.types.MessageType;

import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.store.pim.IMemoDTO;

public class ExchewsMemoDTO extends ExchewsItemBase implements IMemoDTO
{
	public ExchewsMemoDTO()
	{
		super();
		this.itemClass = "IPM.StickyNote";
	}

	private static final long serialVersionUID = 1L;
	protected String lastModifiedName;
	protected Date date;
	@Override
	public void copy(IMemoDTO src)
	{
		// TODO ꂽ\bhEX^u

	}

	@Override
	public Date getDate()
	{
		return date;
	}

	@Override
	@Deprecated
	public String getSenderName()
	{
		return lastModifiedName;
	}

	@Override
	@Deprecated
	public String getTid()
	{
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public void setDate(Date createDate)
	{
		date = createDate;

	}

	@Override
	@Deprecated
	public void setSenderName(String senderName)
	{
		lastModifiedName = senderName;
	}

	@Override
	@Deprecated
	public void setTid(String tid)
	{
		// TODO ꂽ\bhEX^u

	}

	public static MessageType convertToMessageType(IMemoDTO dto) throws Exception
	{
		MessageType rc = new MessageType();
		if (!(dto instanceof ExchewsMemoDTO)) {
			throw new IllegalArgumentException("dto must be instance of ExchewsMemoDTO");
		}
		ExchewsMemoDTO memo = (ExchewsMemoDTO)dto;
		memo.setBody(memo.getSubject() + "\n" + memo.getBody());
		convertToItemType(rc, memo);
		
		return rc;
	}
	
	public static ExchewsMemoDTO convertFromMemoItemType(ItemType msg) throws Exception
	{
		if (msg == null) return null;
		ExchewsMemoDTO rc = new ExchewsMemoDTO();
		
		convertFromItemType(rc,msg);
		
		if (msg.getLastModifiedName()!=null)rc.setSenderName(msg.getLastModifiedName());
		if (msg.getDateTimeCreated()!=null)rc.setDate(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getDateTimeCreated()));
/*		if (msg.getSender()!=null)rc.setSender(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getSender().getMailbox()));
		ArrayOfRecipientsType to_ar = msg.getToRecipients();
		if (to_ar!=null) rc.setTo(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(to_ar));
		ArrayOfRecipientsType cc_ar = msg.getCcRecipients();
		if (cc_ar!=null) rc.setCC(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(cc_ar));
		ArrayOfRecipientsType bcc_ar = msg.getBccRecipients();
		if (bcc_ar!=null) rc.setBCC(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(bcc_ar));
		//rc.setDeliveryReceiptRequested(msg.isIsDeliveryReceiptRequested());
		rc.setReadReceiptRequested(msg.isIsReadReceiptRequested());
		rc.setConversationIndex(msg.getConversationIndex());
		rc.setConversationTopic(msg.getConversationTopic());
		if (msg.getFrom()!=null)rc.setFrom(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getFrom().getMailbox()));
		rc.setInternetMessageId(msg.getInternetMessageId());
		rc.setRead(msg.isIsRead());
		//rc.setResponseRequested(msg.isIsResponseRequested());
		//rc.setReferences(msg.getReferences());
		//ArrayOfRecipientsType replyTo = msg.getReplyTo();
		//if (replyTo!=null) rc.setReplyTo(ExchEWSTranslator.convertEWSArrayOfRecipientsType2MailBoxes(replyTo)[0]);
		if (msg.getReceivedBy()!=null)rc.setReceivedBy(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getReceivedBy().getMailbox()));
		//if (msg.getReceivedRepresenting()!=null)rc.setReceivedRepresenting(ExchEWSTranslator.convertEWSMailBox2MailAddress(msg.getReceivedRepresenting().getMailbox()));
*/		
		rc.setBeanData();
		return rc;
	}

	public String getLastModifiedName()
	{
		return lastModifiedName;
	}

	public void setLastModifiedName(String lastModifiedName)
	{
		this.lastModifiedName = lastModifiedName;
	}
}
