/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import jp.co.connectone.eai.exchews.user.ExchewsAccountData;
import jp.co.connectone.service.ServiceInfo;
import jp.co.connectone.store.*;

/**
 * @author amanot
 *
 */
public class ExchewsServiceInfo extends ServiceInfo
{
	private static final long serialVersionUID = 1L;
	protected String protocolPrefix=EAIExchewsBase.DEFAULT_PROTOCOL_PREFIX;
	public static final String DEFAULT_ENDPOINT_PATH="/EWS/Exchange.asmx";
	protected String endPointPath=DEFAULT_ENDPOINT_PATH;
	protected String adAddress;
	protected String adAddress2;

	@Override
	public void setParam2(String param)
	{
		adAddress = param;
		super.setParam2(param);
	}

	@Override
	public void setParam3(String param)
	{
		adAddress2 = param;
		super.setParam3(param);
	}

	public String getAdAddress2()
	{
		return adAddress2;
	}

	public void setAdAddress2(String adAddress2)
	{
		this.adAddress2 = adAddress2;
	}

	public String getAdAddress()
	{
		return adAddress;
	}

	public void setAdAddress(String adAddress)
	{
		this.adAddress = adAddress;
	}

	/**
	 * @param storeID
	 * @param type
	 * @param name
	 */
	public ExchewsServiceInfo(IStoreID storeID, String name)
	{
		super(storeID, name);
	}
	
	public String getEndPointUri()
	{
		return protocolPrefix + serverAddress + endPointPath;
	}
	
	public String getEndPointPath()
	{
		return endPointPath;
	}

	public void setEndPointPath(String endPointPath)
	{
		this.endPointPath = endPointPath;
	}

	public String getAccountClassName()
	{
		return ExchewsAccountData.class.getName();
	}

	public String getProtocolPrefix()
	{
		return protocolPrefix;
	}

	public void setProtocolPrefix(String protocolPrefix)
	{
		this.protocolPrefix = protocolPrefix;
	}

}
