/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.pop3.socket;

import java.util.Date;

public class UidlElement
{
	private String uidl;
	private Date sentDate;
	
	public UidlElement(String uidl,Date date)
	{
		this.uidl = uidl;
		this.sentDate = date;
	}
	
	public UidlElement(String uidl)
	{
		this.uidl = uidl;
		this.sentDate = null;
	}
	
	@SuppressWarnings("unused")
	private UidlElement(){};
	
	public String getUidl()
	{
		return uidl;
	}
	public void setUidl(String uidl)
	{
		this.uidl = uidl;
	}
	public Date getSentDate()
	{
		return sentDate;
	}
	public void setSentDate(Date sentDate)
	{
		this.sentDate = sentDate;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj==null) return false;
		if (obj instanceof UidlElement) {
			String uidlStr = ((UidlElement)obj).getUidl();
			return this.uidl.equals(uidlStr);
		}
		if (obj instanceof String) {
			return this.uidl.equals(obj);
		}
		return false;
	}
	
}
