/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.store.pim;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.client.AttachmentDataSource;
import jp.co.connectone.store.pim.AttachmentDTO;
import jp.co.connectone.store.pim.HeaderDTO;
import jp.co.connectone.store.pim.IMailDTO;
import jp.co.connectone.store.pim.MailAddress;

public class MailParseHelper
extends BasicRecordObject {
    private static final long serialVersionUID = 1L;
    protected HeaderDTO mHeader = null;
    protected IMailDTO mMail = null;

    @Override
    public IObjectIndex getOid() {
        return this.mHeader.getOid();
    }

    @Override
    public void setOid(IObjectIndex oid) {
        this.mHeader.setOid(oid);
    }

    public MailParseHelper() {
    }

    public MailParseHelper(MailParseHelper org) {
        this.mHeader = org.mHeader;
        this.mMail = org.mMail;
    }

    public MailParseHelper(HeaderDTO header) {
        this.setHeaderDTO(header);
    }

    public MailParseHelper(IMailDTO mail) {
        this.setMailDTO(mail);
    }

    public void setHeaderDTO(HeaderDTO header) {
        this.mMail = null;
        this.mHeader = header;
    }

    public void setMailDTO(IMailDTO mail) {
        this.mMail = mail;
        this.mHeader = mail.getHeader();
    }

    public String getUIDL() {
        return this.mHeader.getHeaderUIDL();
    }

    public Date getSentDate() {
        return this.mHeader.getHeaderSendDate();
    }

    public Date getReceivedDate() {
        return this.mHeader.getHeaderReceivedDate();
    }

    public String getSize() {
        return "" + this.mHeader.getHeaderSize();
    }

    public MailAddress[] getTO() {
        if (this.mHeader == null) {
            return null;
        }
        return this.mHeader.getHeaderTo();
    }

    public void setTO(MailAddress[] to) {
        if (this.mHeader != null) {
            this.mHeader.setHeaderTo(to);
        }
    }

    public void setCC(MailAddress[] cc) {
        if (this.mHeader != null) {
            this.mHeader.setHeaderCC(cc);
        }
    }

    public void setBCC(MailAddress[] bcc) {
        if (this.mHeader != null) {
            this.mHeader.setHeaderBCC(bcc);
        }
    }

    public Collection<MailAddress> getTOCollection() {
        ArrayList<MailAddress> list = new ArrayList<MailAddress>();
        MailAddress[] array = this.mHeader.getHeaderTo();
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public MailAddress[] getCC() {
        return this.mHeader.getHeaderCC();
    }

    public MailAddress[] getBCC() {
        return this.mHeader.getHeaderBCC();
    }

    public Collection<MailAddress> getCCCollection() {
        ArrayList<MailAddress> list = new ArrayList<MailAddress>();
        MailAddress[] array = this.mHeader.getHeaderCC();
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public Collection<MailAddress> getBCCCollection() {
        ArrayList<MailAddress> list = new ArrayList<MailAddress>();
        MailAddress[] array = this.mHeader.getHeaderBCC();
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public MailAddress getFrom() {
        return this.mHeader.getHeaderFrom();
    }

    public MailAddress getReplyTo() {
        return this.mHeader.getHeaderReplyTo();
    }

    public String getSubject() {
        return this.mHeader.getHeaderSubject();
    }

    public String getPriority() {
        return "" + this.mHeader.getHeaderPriority();
    }

    public String getBody() {
        return this.mMail.getBody();
    }

    public String getBodyHtml() {
        String html = this.mMail.getBody();
        if (html != null) {
            html.replaceFirst("\n", "<BR>\n");
        }
        return html;
    }

    public int getNumberOfAttachments() {
        return this.mMail.getNumberOfAttachments();
    }

    public AttachmentDTO getAttachment(int number) {
        return this.mMail.getAttachment(number);
    }

    public byte[] getAttachmentBody(int number) {
        return this.mMail.getAttachment(number).getFileBody();
    }

    public AttachmentDTO[] getAttachments() {
        return this.mMail.getAttachments();
    }

    public Collection<AttachmentDTO> getAttachmentCollection() {
        ArrayList<AttachmentDTO> list = new ArrayList<AttachmentDTO>();
        AttachmentDTO[] array = this.mMail.getAttachments();
        if (list == null) {
            return list;
        }
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public String getAttachmentName(int number) {
        return this.mMail.getAttachment(number).getFileName();
    }

    public String getMailBinary() throws Exception {
        String retStr = "";
        retStr = String.valueOf(retStr) + this.getHeaderBinary();
        retStr = String.valueOf(retStr) + this.getBodyBinary();
        return retStr;
    }

    public String getHeaderBinary() throws Exception {
        String retStr = "";
        retStr = String.valueOf(retStr) + "Date: " + this.getSentDate() + "\n";
        retStr = String.valueOf(retStr) + "Message-ID: " + this.getUIDL() + "\n";
        retStr = String.valueOf(retStr) + "From: " + this.getFrom() + "\n";
        String strTo = "";
        MailAddress[] tmpAddress = this.getTO();
        if (tmpAddress != null) {
            int i = 0;
            while (i < tmpAddress.length) {
                strTo = String.valueOf(strTo) + tmpAddress[i];
                ++i;
            }
            if (strTo.length() > 0) {
                retStr = String.valueOf(retStr) + "To: " + strTo + "\n";
            }
        }
        String strCC = "";
        tmpAddress = this.getCC();
        if (tmpAddress != null) {
            int i = 0;
            while (i < tmpAddress.length) {
                strCC = String.valueOf(strCC) + tmpAddress[i];
                ++i;
            }
            if (strTo.length() > 0) {
                retStr = String.valueOf(retStr) + "Cc: " + strCC + "\n";
            }
        }
        retStr = String.valueOf(retStr) + "Subject: " + this.getSubject() + "\n";
        return retStr;
    }

    public String getBodyBinary() throws Exception {
        String rc = "";
        String bodyStr = this.mMail.getBody();
        AttachmentDTO[] attachments = this.mMail.getAttachments();
        if (attachments == null) {
            return "\n" + bodyStr;
        }
        try {
            String tmp;
            MimeMessage msg = new MimeMessage(null);
            MimeMultipart part = new MimeMultipart();
            MimeBodyPart body = new MimeBodyPart();
            body.setText(bodyStr, "ISO-2022-JP");
            part.addBodyPart((BodyPart)body);
            int i = 0;
            while (i < attachments.length) {
                MimeBodyPart attach = new MimeBodyPart();
                attach.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(attachments[i])));
                attach.setFileName(MimeUtility.encodeText((String)attachments[i].getFileName(), (String)"ISO-2022-JP", (String)"B"));
                part.addBodyPart((BodyPart)attach);
                ++i;
            }
            msg.setContent((Multipart)part);
            msg.saveChanges();
            rc = "MIME-Version: 1.0\nContent-Type: " + msg.getHeader("Content-Type", null) + "\n\n";
            InputStream is = msg.getInputStream();
            BufferedReader b = new BufferedReader(new InputStreamReader(is));
            while ((tmp = b.readLine()) != null) {
                rc = String.valueOf(rc) + tmp + "\r\n";
            }
        }
        catch (Exception e) {
            Log.error("Exception on creating MimeMessage", e);
        }
        return rc;
    }

    protected HeaderDTO getMHeader() {
        return this.mHeader;
    }

    protected void setMHeader(HeaderDTO header) {
        this.mHeader = header;
    }

    protected IMailDTO getMMail() {
        return this.mMail;
    }

    protected void setMMail(IMailDTO mail) {
        this.mMail = mail;
    }

    public String toString() {
        if (this.mMail == null) {
            return super.toString();
        }
        return this.mMail.toString();
    }
}

