/*
 * Decompiled with CFR 0.152.
 */
package jp.co.connectone.eai.notes.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.co.connectone.eai.notes.log.LogAspect;
import jp.co.connectone.eai.notes.store.EAINotesBase;
import jp.co.connectone.eai.notes.store.NotesFolderIndex;
import jp.co.connectone.eai.notes.store.NotesObjectIndex;
import jp.co.connectone.eai.notes.store.NotesScheduleDTO;
import jp.co.connectone.eai.notes.store.NotesServiceInfo;
import jp.co.connectone.eai.notes.store.ResourceBandleHandler;
import jp.co.connectone.eai.notes.user.NotesAccountData;
import jp.co.connectone.exception.DataNotFound;
import jp.co.connectone.exception.DeleteFailed;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.exception.IncorrectData;
import jp.co.connectone.exception.IncorrectStore;
import jp.co.connectone.exception.NoSuchRights;
import jp.co.connectone.exception.SearchConditionFailed;
import jp.co.connectone.exception.ServerDown;
import jp.co.connectone.exception.UpdateFailed;
import jp.co.connectone.log.Log;
import jp.co.connectone.service.IServiceInfo;
import jp.co.connectone.service.IServiceInfoRawData;
import jp.co.connectone.store.BasicObjectIndex;
import jp.co.connectone.store.BasicSearchDestination;
import jp.co.connectone.store.FolderMetadata;
import jp.co.connectone.store.IDatabaseIndex;
import jp.co.connectone.store.IFolderIndex;
import jp.co.connectone.store.IObjectIndex;
import jp.co.connectone.store.IRecordObject;
import jp.co.connectone.store.ISearchDestination;
import jp.co.connectone.store.ISearchFormula;
import jp.co.connectone.store.IStoreID;
import jp.co.connectone.store.SimpleStoreID;
import jp.co.connectone.store.pim.IScheduleDTO;
import jp.co.connectone.store.pim.IScheduleStore;
import jp.co.connectone.user.IAccountData;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.View;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class NotesScheduleStoreImpl
extends EAINotesBase
implements IScheduleStore {
    public static final IStoreID storeID;
    public static final String storeName = "Notes Schedule Store";
    public static final String DEFAULT_NOTES_CALENDAR_NAME = "($Calendar)";
    private IFolderIndex calendarElement = new NotesFolderIndex("($Calendar)");
    private String m_nullParamList = "$LangPrincipal,$LangChair,SaveOptions,MailOptions,Repeats, OrgConfidential,Alarms,Categories,WebCategory,tmpNoActionBar,tmpOEMClient,BookFreeTime, RequiredAttendees";
    private String m_nullParamListNames = "SendTo,EnterSendTo,CopyTo,EnterCopyTo,BlindCopyTo, EnterBlindCopyTo,RoomToReserve,Resources";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        NotesScheduleStoreImpl.ajc$preClinit();
        storeID = new SimpleStoreID(NotesScheduleStoreImpl.class.getName());
    }

    public String getName() throws Exception {
        return storeName;
    }

    public IServiceInfo getServiceInfo(IServiceInfoRawData serviceData) throws Exception {
        HashMap h = serviceData.getFieldSet();
        NotesServiceInfo info = new NotesServiceInfo(storeID, storeName);
        String serverAddress = (String)h.get("server");
        String serverAddress2 = (String)h.get("server2");
        if (serverAddress != null) {
            info.setServerAddress(serverAddress);
        }
        if (serverAddress2 != null) {
            info.setServerAddress2(serverAddress2);
        }
        return info;
    }

    public IServiceInfo getServiceInfo() throws Exception {
        return new NotesServiceInfo(storeID, storeName);
    }

    public IStoreID getStoreID() throws Exception {
        return storeID;
    }

    public void delete(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        this.deleteSchedule(acc, oid);
    }

    public IObjectIndex write(IAccountData acc, ISearchDestination dest, IRecordObject data) throws Exception {
        IObjectIndex rc = null;
        rc = data.isNew() ? this.createNewSchedule(acc, (IScheduleDTO)data) : this.updateSchedule(acc, (IScheduleDTO)data);
        return rc;
    }

    public IRecordObject[] getAllDatas(IAccountData acc, ISearchDestination dest) throws Exception {
        throw new UnsupportedOperationException("get All shcedules without date not yet supported.");
    }

    public FolderMetadata[] getFolderList(IAccountData acc, ISearchDestination dest) throws Exception {
        throw new UnsupportedOperationException("get folder list on schedule not yet supported.");
    }

    public IRecordObject read(IAccountData acc, ISearchDestination dest, IObjectIndex oid) throws Exception {
        return this.getSchedule(acc, oid);
    }

    public IRecordObject[] search(IAccountData acc, ISearchFormula form) throws Exception {
        return this.searchSchedules(acc, form);
    }

    public IRecordObject[] searchByDate(IAccountData acc, ISearchDestination dest, Date date) throws Exception {
        return this.getSchedulesByDate(acc, date);
    }

    public IScheduleDTO[] getAllSchedules(IAccountData acc, Date cutOffDate) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        Object[] l_scheduleDtoArray = null;
        Document l_docObj = null;
        String l_strQuery = null;
        DocumentCollection l_objDocCollection = null;
        String[] l_strQueryArgs = null;
        super.initSession((NotesAccountData)acc);
        try {
            l_strQueryArgs = new String[Integer.parseInt(ResourceBandleHandler.getString("notes.GETALLSCHEDULES_QUERY_TOTAL_ARGS"))];
            l_strQueryArgs[0] = this.createDateTime(cutOffDate).toString();
            l_strQuery = this.generateQuery(l_strQueryArgs, "notes.GETALLSCHEDULES_QUERY");
            l_objDocCollection = this.search(l_strQuery, null);
            int l_intDocCount = l_objDocCollection.getCount();
            if (l_intDocCount == 0) {
                NotesScheduleDTO[] notesScheduleDTOArray = new NotesScheduleDTO[]{};
                return notesScheduleDTOArray;
            }
            try {
                if (l_objDocCollection.getCount() > 0) {
                    l_scheduleDtoArray = new NotesScheduleDTO[l_intDocCount];
                    l_docObj = l_objDocCollection.getFirstDocument();
                    l_scheduleDtoArray[0] = this.populateScheduleDto(l_docObj);
                    int intIndex = 1;
                    while (intIndex < l_intDocCount) {
                        l_docObj = l_objDocCollection.getNextDocument();
                        l_scheduleDtoArray[intIndex] = this.populateScheduleDto(l_docObj);
                        ++intIndex;
                    }
                }
            }
            catch (MissingResourceException l_missResExObj) {
                throw new DataNotFound();
            }
            catch (NotesException l_notesExceptionObj) {
                if (cutOffDate == null) {
                    throw new DataNotFound();
                }
                throw new ServerDown(acc.getServiceInfo().getServerAddress());
            }
            catch (NullPointerException l_nullPointerEx) {
                throw new DataNotFound();
            }
        }
        finally {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
                if (l_objDocCollection != null) {
                    l_objDocCollection.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
        return l_scheduleDtoArray;
    }

    public IScheduleDTO[] getSchedulesByDate(IAccountData acc, Date dateObj) throws ServerDown, DataNotFound, SearchConditionFailed, HandleException {
        Object[] l_scheduleDtoArray = null;
        View l_viewObj = null;
        DateTime l_dateTimeObj = null;
        Document l_docObj = null;
        DocumentCollection l_objDocCollection = null;
        super.initSession((NotesAccountData)acc);
        try {
            l_viewObj = this.getView(this.calendarElement);
            String string = "l_viewObj=" + l_viewObj;
            NotesScheduleStoreImpl.debug_aroundBody1$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_0);
            l_dateTimeObj = super.createDateTime(dateObj);
            try {
                l_dateTimeObj = super.createDateTime(l_dateTimeObj.getDateOnly());
            }
            catch (ParseException pe) {
                Log.error((String)"", (Throwable)pe);
                throw new IncorrectData(pe.getMessage());
            }
            String string2 = "l_viewObj=" + l_viewObj + ";l_dateTimeObj = " + l_dateTimeObj;
            NotesScheduleStoreImpl.debug_aroundBody3$advice(this, string2, LogAspect.aspectOf(), string2, null, ajc$tjp_1);
            l_objDocCollection = l_viewObj.getAllDocumentsByKey((Object)l_dateTimeObj);
            int l_intDocCount = l_objDocCollection.getCount();
            if (l_intDocCount == 0) {
                NotesScheduleDTO[] notesScheduleDTOArray = new NotesScheduleDTO[]{};
                return notesScheduleDTOArray;
            }
            try {
                if (l_objDocCollection.getCount() > 0) {
                    l_scheduleDtoArray = new NotesScheduleDTO[l_intDocCount];
                    l_docObj = l_objDocCollection.getFirstDocument();
                    l_scheduleDtoArray[0] = this.populateScheduleDto(l_docObj);
                    int intIndex = 1;
                    while (intIndex < l_intDocCount) {
                        l_docObj = l_objDocCollection.getNextDocument();
                        l_scheduleDtoArray[intIndex] = this.populateScheduleDto(l_docObj);
                        ++intIndex;
                    }
                }
            }
            catch (MissingResourceException l_missResExObj) {
                throw new DataNotFound();
            }
            catch (NotesException l_notesExceptionObj) {
                throw new ServerDown(acc.getServiceInfo().getServerAddress());
            }
            catch (NullPointerException l_nullPointerEx) {
                throw new DataNotFound();
            }
        }
        finally {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
                if (l_objDocCollection != null) {
                    l_objDocCollection.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
        return l_scheduleDtoArray;
    }

    public IScheduleDTO getSchedule(IAccountData acc, IObjectIndex oid) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, HandleException {
        NotesScheduleDTO l_scheduleDTO = null;
        Document l_docObj = null;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_docObj = this.getDocumentByUNID(oid);
                l_scheduleDTO = this.populateScheduleDto(l_docObj);
            }
            catch (Exception l_excepObj) {
                throw new DataNotFound();
            }
        }
        finally {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
        return l_scheduleDTO;
    }

    public IObjectIndex createNewSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws IncorrectData, NoSuchRights, DataNotFound, IncorrectStore, ServerDown, HandleException {
        String strUNID = null;
        Document l_docObj = null;
        NotesAccountData acc2 = (NotesAccountData)acc;
        String strUser = acc2.getUserID();
        String strServer = acc2.getServiceInfo().getServerAddress();
        int intSchType = 0;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                DateTime startDT = this.createDateTime(scheduleDTO.getStartDate());
                DateTime endDT = this.createDateTime(scheduleDTO.getEndDate());
                if (this.isValidSchedule(scheduleDTO)) {
                    l_docObj = this.CreateDocument();
                    strUNID = l_docObj.getUniversalID();
                    l_docObj.replaceItemValue("AppendStartTime", (Object)startDT);
                    l_docObj.replaceItemValue("AppendEndTime", (Object)endDT);
                    l_docObj.replaceItemValue("STARTDATETIME", (Object)startDT);
                    l_docObj.replaceItemValue("CalendarDateTime", (Object)startDT);
                    l_docObj.replaceItemValue("StartDate", (Object)startDT);
                    l_docObj.replaceItemValue("$NoPurge", (Object)endDT);
                    l_docObj.replaceItemValue("Subject", (Object)scheduleDTO.getSubject());
                    RichTextItem rtItem = l_docObj.createRichTextItem("Body");
                    if (scheduleDTO instanceof NotesScheduleDTO) {
                        NotesScheduleDTO nScheduleDTO = (NotesScheduleDTO)scheduleDTO;
                        intSchType = nScheduleDTO.getScheduleType();
                        String[] l_description = nScheduleDTO.getDescription();
                        if (l_description != null) {
                            int i = 0;
                            while (i < l_description.length) {
                                rtItem.appendText(l_description[i]);
                                ++i;
                            }
                        }
                    }
                }
                Vector<String> l_vecExcludeFromViewObj = new Vector<String>(2);
                if (intSchType != 5) {
                    l_docObj.replaceItemValue("Location", (Object)scheduleDTO.getLocation());
                    l_docObj.replaceItemValue("StartTime", (Object)startDT);
                    l_docObj.replaceItemValue("EndTime", (Object)endDT);
                    l_docObj.replaceItemValue("EndDateTime", (Object)endDT);
                    l_docObj.replaceItemValue("EndDate", (Object)endDT);
                    l_vecExcludeFromViewObj.add("S");
                    l_docObj.replaceItemValue("Form", (Object)"Appointment");
                    l_docObj.replaceItemValue("AppointmentType", (Object)("" + intSchType));
                } else {
                    l_docObj.replaceItemValue("DueState", (Object)new Integer(2));
                    l_docObj.replaceItemValue("DueDateTime", (Object)endDT);
                    l_docObj.replaceItemValue("DueDate", (Object)endDT);
                    l_docObj.replaceItemValue("Form", (Object)"Task");
                    l_docObj.replaceItemValue("TaskType", (Object)"1");
                    l_docObj.replaceItemValue("AppointmentType", (Object)"");
                }
                l_vecExcludeFromViewObj.add("D");
                l_docObj.replaceItemValue("ExcludeFromView", l_vecExcludeFromViewObj);
                Item item = l_docObj.replaceItemValue("$BusyName", (Object)strUser);
                item.setNames(true);
                item = l_docObj.replaceItemValue("From", (Object)strUser);
                item.setAuthors(true);
                item.setNames(true);
                l_docObj.replaceItemValue("Principal", (Object)strUser);
                l_docObj.replaceItemValue("$AltPrincipal", (Object)strUser);
                l_docObj.replaceItemValue("Chair", (Object)strUser);
                l_docObj.replaceItemValue("AltChair", (Object)strUser);
                l_docObj.replaceItemValue("ApptUNID", (Object)strUNID);
                l_docObj.replaceItemValue("_ViewIcon", (Object)this.getScheduleViewIcon(intSchType));
                this.setScheduleVariables(l_docObj);
                l_docObj.save();
            }
            catch (NullPointerException l_nullPtrEx) {
                Log.error((String)"", (Throwable)l_nullPtrEx);
                throw new DataNotFound();
            }
            catch (DataNotFound l_exceptionObj) {
                Log.error((String)"", (Throwable)l_exceptionObj);
                throw new DataNotFound();
            }
            catch (NotesException l_exceptionObj) {
                Log.error((String)"", (Throwable)l_exceptionObj);
                throw new ServerDown(strServer);
            }
        }
        finally {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
        NotesObjectIndex idx = new NotesObjectIndex(strUNID);
        return idx;
    }

    public IObjectIndex updateSchedule(IAccountData acc, IScheduleDTO objScheduleDTO) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, UpdateFailed, HandleException {
        Object l_docCollectionObj = null;
        Document l_docObj = null;
        NotesObjectIndex idx = null;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_docObj = this.getDocumentByUNID(objScheduleDTO.getOid());
                this.updateScheduleFields(l_docObj, objScheduleDTO);
                l_docObj.save();
                idx = new NotesObjectIndex(l_docObj.getUniversalID());
            }
            catch (NotesException l_notesExObj) {
                Log.error((String)"", (Throwable)l_notesExObj);
                if (objScheduleDTO != null && l_docObj != null) {
                    throw new UpdateFailed();
                }
                throw new ServerDown(acc.getServiceInfo().getServerAddress());
            }
            catch (NullPointerException l_nullPointerExcepObj) {
                throw new DataNotFound();
            }
        }
        finally {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
                if (l_docCollectionObj != null) {
                    l_docCollectionObj.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
        return idx;
    }

    public IScheduleDTO[] searchSchedules(IAccountData acc, ISearchFormula form) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        throw new HandleException("not yet implemented");
    }

    public void deleteSchedule(IAccountData acc, IObjectIndex strUNID) throws IncorrectData, DeleteFailed, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, SearchConditionFailed, HandleException {
        Document l_docObj = null;
        Object l_docCollectionObj = null;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                l_docObj = this.getDocumentByUNID(strUNID);
                l_docObj.remove(true);
            }
            catch (NotesException l_notesExObj) {
                if (l_docCollectionObj != null && l_docObj != null) {
                    throw new DeleteFailed();
                }
                throw new ServerDown(acc.getServiceInfo().getServerAddress());
            }
            catch (NullPointerException l_nullPointerExcepObj) {
                throw new DataNotFound();
            }
        }
        finally {
            try {
                if (l_docObj != null) {
                    l_docObj.recycle();
                }
                if (l_docCollectionObj != null) {
                    l_docCollectionObj.recycle();
                }
            }
            catch (NotesException notesException) {}
            super.recycleObjects();
        }
    }

    public boolean isValidSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws IncorrectData, NoSuchRights, ServerDown, DataNotFound, IncorrectStore, HandleException {
        return true;
    }

    public boolean isValidSchedule(IScheduleDTO scheduleDTO) throws ServerDown, DataNotFound, HandleException {
        return true;
    }

    public boolean isDuplicateSchedule(IAccountData acc, IScheduleDTO scheduleDTO) throws NoSuchRights, ServerDown, DataNotFound, IncorrectData, HandleException {
        boolean l_boolIsDuplicateSchedule = false;
        DocumentCollection l_objDocCollection = null;
        super.initSession((NotesAccountData)acc);
        try {
            try {
                String l_strQuery;
                String[] l_strQueryArgs = new String[Integer.parseInt(ResourceBandleHandler.getString("notes.ISDUPLICATE_SCHEDULE_TOTAL_ARGS"))];
                l_strQueryArgs[0] = this.createDateTime(scheduleDTO.getStartDate()).toString();
                l_strQueryArgs[1] = this.createDateTime(scheduleDTO.getEndDate()).toString();
                if (scheduleDTO instanceof NotesScheduleDTO) {
                    l_strQueryArgs[2] = "" + ((NotesScheduleDTO)scheduleDTO).getScheduleType();
                }
                if ((l_objDocCollection = this.search(l_strQuery = this.generateQuery(l_strQueryArgs, "notes.ISDUPLICATE_SCHEDULE"), null)).getCount() > 0) {
                    l_boolIsDuplicateSchedule = true;
                }
            }
            catch (NullPointerException l_nullPtrExObj) {
                throw new DataNotFound();
            }
            catch (NotesException l_notesExObj) {
                throw new ServerDown(String.valueOf(l_notesExObj.id) + l_notesExObj.text);
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (l_objDocCollection != null) {
                        l_objDocCollection.recycle();
                    }
                }
                catch (NotesException l_exceptionObj) {
                    throw new ServerDown(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
                }
            }
            finally {
                super.recycleObjects();
            }
            throw throwable;
        }
        try {
            try {
                if (l_objDocCollection != null) {
                    l_objDocCollection.recycle();
                }
            }
            catch (NotesException l_exceptionObj) {
                throw new ServerDown(String.valueOf(l_exceptionObj.id) + l_exceptionObj.text);
            }
        }
        finally {
            super.recycleObjects();
        }
        return l_boolIsDuplicateSchedule;
    }

    private String generateQuery(String[] queryArgs, String key) throws DataNotFound {
        String l_strQuery = null;
        try {
            l_strQuery = ResourceBandleHandler.getString(key);
            int l_intQryArgsLen = queryArgs.length;
            String l_strSepSubString = ResourceBandleHandler.getString("notes.FORMULA_ARGS_SEPARATOR");
            int i = 0;
            while (i < l_intQryArgsLen) {
                l_strQuery = l_strQuery.replaceFirst(l_strSepSubString, queryArgs[i]);
                ++i;
            }
        }
        catch (MissingResourceException l_missResExcepObj) {
            throw new DataNotFound(l_missResExcepObj.getMessage());
        }
        return l_strQuery;
    }

    private void setScheduleVariables(Document l_docObj) throws ServerDown {
        try {
            l_docObj.replaceItemValue("$PublicAccess", (Object)ResourceBandleHandler.getString("notes.PUBLIC_ACCESS_VALUE"));
            l_docObj.replaceItemValue("$BusyPriority", (Object)ResourceBandleHandler.getString("notes.BUSY_PRIORITY_VALUE"));
            l_docObj.replaceItemValue("$WebFlags", (Object)ResourceBandleHandler.getString("notes.WEB_FLAGS_VALUE"));
            l_docObj.replaceItemValue("$ExpandGroups", (Object)ResourceBandleHandler.getString("notes.EXPAND_GROUPS_VALUE"));
            l_docObj.replaceItemValue("Logo", (Object)ResourceBandleHandler.getString("notes.LOGO_VALUE"));
            l_docObj.replaceItemValue("Sign", (Object)ResourceBandleHandler.getString("notes.SIGN_VALUE"));
            l_docObj.replaceItemValue("Encrypt", (Object)ResourceBandleHandler.getString("notes.ENCRYPT_VALUE"));
            l_docObj.replaceItemValue("tmpOwnerHW", (Object)ResourceBandleHandler.getString("notes.TMP_OWNERHW_VALUE"));
            l_docObj.replaceItemValue("SequenceNum", (Object)new Integer(Integer.parseInt(ResourceBandleHandler.getString("notes.SEQUENCE_NUMBER_VALUE"))));
            l_docObj.replaceItemValue("$CSVersion", (Object)ResourceBandleHandler.getString("notes.CS_VERSION_VALUE"));
            l_docObj.replaceItemValue("MailFirstPass", (Object)ResourceBandleHandler.getString("notes.MAIL_FIRSTPASS_VALUE"));
            l_docObj.replaceItemValue("$SMTPKeepNotesItems", (Object)ResourceBandleHandler.getString("notes.SMPT_KEEP_NOTES_ITEMS_VALUE"));
            l_docObj.replaceItemValue("WebDateTimeInit", (Object)ResourceBandleHandler.getString("notes.WEB_DATETIME_INITVALUE"));
            l_docObj.replaceItemValue("OrgTable", (Object)ResourceBandleHandler.getString("notes.ORG_TABLE_VALUE"));
            StringTokenizer parser = new StringTokenizer(this.getNullParameterList(), ",");
            while (parser.hasMoreTokens()) {
                l_docObj.replaceItemValue(parser.nextToken().trim(), null);
            }
            parser = new StringTokenizer(this.getNullParameterListNames(), ",");
            while (parser.hasMoreTokens()) {
                Item l_itemObj = l_docObj.replaceItemValue(parser.nextToken().trim(), null);
                l_itemObj.setNames(true);
            }
        }
        catch (NotesException l_notesExObj) {
            throw new ServerDown(String.valueOf(l_notesExObj.id) + l_notesExObj.text);
        }
    }

    private void updateScheduleFields(Document l_objDocument, IScheduleDTO objScheduleDTO) throws ServerDown, DataNotFound, HandleException {
        NotesScheduleDTO l_ScheduleDTOOfDoc = null;
        try {
            l_ScheduleDTOOfDoc = this.populateScheduleDto(l_objDocument);
            l_objDocument.replaceItemValue("Body", (Object)objScheduleDTO.getBody());
            l_objDocument.replaceItemValue("STARTDATETIME", (Object)this.createDateTime(objScheduleDTO.getStartDate()));
            l_objDocument.replaceItemValue("EndDateTime", (Object)this.createDateTime(objScheduleDTO.getEndDate()));
            l_objDocument.replaceItemValue("Location", (Object)objScheduleDTO.getLocation());
            l_objDocument.replaceItemValue("Subject", (Object)objScheduleDTO.getSubject());
            l_objDocument.replaceItemValue("Server\\Mail Users", (Object)objScheduleDTO.getUserId());
            if (objScheduleDTO instanceof NotesScheduleDTO) {
                NotesScheduleDTO nScheduleDTO = (NotesScheduleDTO)objScheduleDTO;
                l_objDocument.replaceItemValue("RepeatForUnit", (Object)nScheduleDTO.getRepeatType());
                l_objDocument.replaceItemValue("AppointmentType", (Object)("" + nScheduleDTO.getScheduleType()));
                l_objDocument.replaceItemValue("Categories", (Object)nScheduleDTO.getCategory());
                if (nScheduleDTO.getRepeatFlag()) {
                    l_objDocument.replaceItemValue("Repeats", (Object)"1");
                } else {
                    l_objDocument.replaceItemValue("Repeats", (Object)"");
                    String[] l_description = nScheduleDTO.getDescription();
                    if (l_description != null) {
                        l_ScheduleDTOOfDoc.setDescription(l_description);
                    }
                }
            }
            l_objDocument.save();
        }
        catch (NotesException l_notesExObj) {
            throw new ServerDown(String.valueOf(l_notesExObj.id) + l_notesExObj.text);
        }
    }

    private Integer getScheduleViewIcon(int intSchType) {
        Integer l_viewIcon = null;
        switch (intSchType) {
            case 0: {
                l_viewIcon = new Integer(160);
                break;
            }
            case 1: {
                l_viewIcon = new Integer(63);
                break;
            }
            case 2: {
                l_viewIcon = new Integer(9);
                break;
            }
            case 3: {
                l_viewIcon = new Integer(158);
                break;
            }
            case 4: {
                l_viewIcon = new Integer(10);
                break;
            }
            case 5: {
                l_viewIcon = new Integer(168);
            }
        }
        return l_viewIcon;
    }

    private NotesScheduleDTO populateScheduleDto(Document l_docObj) throws ServerDown, DataNotFound {
        NotesScheduleDTO l_scheduleDTO = new NotesScheduleDTO();
        DateTime l_datetimeStartDateTime = null;
        DateTime l_datetimeEndDateTime = null;
        try {
            Vector l_vecObjEndDate;
            String xmlStr;
            String string = xmlStr = l_docObj.generateXML();
            NotesScheduleStoreImpl.debug_aroundBody5$advice(this, string, LogAspect.aspectOf(), string, null, ajc$tjp_2);
            l_scheduleDTO.setBody(l_docObj.getItemValueString("Body"));
            l_scheduleDTO.setCategory(l_docObj.getItemValueString("Categories"));
            l_scheduleDTO.setLocation(l_docObj.getItemValueString("Location"));
            String strType = l_docObj.getItemValueString("AppointmentType");
            try {
                int type = Integer.parseInt(strType);
                l_scheduleDTO.setScheduleType(type);
            }
            catch (Exception type) {
                // empty catch block
            }
            l_scheduleDTO.setSubject(l_docObj.getItemValueString("Subject"));
            l_scheduleDTO.setOid((IObjectIndex)new BasicObjectIndex((Object)l_docObj.getUniversalID()));
            l_scheduleDTO.setUserId(l_docObj.getItemValueString("From"));
            Vector l_vecObjStartDate = l_docObj.getItemValue("STARTDATETIME");
            if (l_vecObjStartDate.size() > 0) {
                l_datetimeStartDateTime = (DateTime)l_vecObjStartDate.get(0);
                l_scheduleDTO.setStartDate(l_datetimeStartDateTime.toJavaDate());
            }
            if ((l_vecObjEndDate = l_docObj.getItemValue("EndDateTime")).size() > 0) {
                l_datetimeEndDateTime = (DateTime)l_vecObjEndDate.get(0);
                l_scheduleDTO.setEndDate(l_datetimeEndDateTime.toJavaDate());
            }
            if ("1".equals(l_docObj.getItemValueString("Repeats"))) {
                l_scheduleDTO.setRepeatFlag(true);
                l_scheduleDTO.setRepeatType(l_docObj.getItemValueString("RepeatForUnit"));
            } else {
                l_scheduleDTO.setRepeatFlag(false);
            }
            this.getDescription(l_docObj, (IScheduleDTO)l_scheduleDTO);
        }
        catch (ArrayIndexOutOfBoundsException l_arrIndexOutOfBound) {
            throw new DataNotFound();
        }
        catch (NullPointerException l_nullPtrException) {
            throw new DataNotFound();
        }
        catch (NotesException l_notesExcepObj) {
            throw new ServerDown(l_notesExcepObj.text);
        }
        return l_scheduleDTO;
    }

    private void getDescription(Document docObjlcl, IScheduleDTO l_scheduleDTOObj) throws ServerDown, DataNotFound {
        String[] l_byteObjArray = null;
        EmbeddedObject l_embedObj2 = null;
        try {
            if (docObjlcl.hasEmbedded()) {
                Vector v = docObjlcl.getItems();
                Iterator ite = v.iterator();
                Vector<EmbeddedObject> attv = new Vector<EmbeddedObject>();
                while (ite.hasNext()) {
                    Item item = (Item)ite.next();
                    if (item.getType() != 1084 || (l_embedObj2 = docObjlcl.getAttachment(item.getValueString())).getType() != 1454) continue;
                    attv.add(l_embedObj2);
                }
                if (attv.size() > 0) {
                    int l_intIndex = 0;
                    l_byteObjArray = new String[attv.size()];
                    for (EmbeddedObject l_embedObj2 : attv) {
                        int l_intBytExistence;
                        ByteArrayOutputStream l_byteArr = new ByteArrayOutputStream();
                        BufferedInputStream l_bufInStr = new BufferedInputStream(l_embedObj2.getInputStream());
                        BufferedOutputStream l_bufOutStr = new BufferedOutputStream(l_byteArr);
                        while ((l_intBytExistence = l_bufInStr.read()) != -1) {
                            l_bufOutStr.write(l_intBytExistence);
                        }
                        l_bufOutStr.flush();
                        l_byteArr.flush();
                        l_byteObjArray[l_intIndex] = new String(l_byteArr.toByteArray());
                        l_byteArr.close();
                        l_bufOutStr.close();
                        l_bufInStr.close();
                    }
                    if (l_scheduleDTOObj instanceof NotesScheduleDTO) {
                        ((NotesScheduleDTO)l_scheduleDTOObj).setDescription(l_byteObjArray);
                    }
                }
            }
        }
        catch (NotesException l_notesExceptionObj) {
            throw new ServerDown(l_notesExceptionObj.text);
        }
        catch (IOException l_ioExceptionObj) {
            throw new DataNotFound();
        }
    }

    private String getNullParameterList() {
        return this.m_nullParamList;
    }

    private String getNullParameterListNames() {
        return this.m_nullParamListNames;
    }

    @Override
    protected String getElmentName() {
        return DEFAULT_NOTES_CALENDAR_NAME;
    }

    public ISearchDestination getPresetDestination(IAccountData acc, int type) throws IncorrectData, HandleException {
        IFolderIndex folder = null;
        IDatabaseIndex db = null;
        folder = this.calendarElement;
        return new BasicSearchDestination(db, folder);
    }

    private static final /* synthetic */ void debug_aroundBody0(NotesScheduleStoreImpl notesScheduleStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody1$advice(NotesScheduleStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody2(NotesScheduleStoreImpl notesScheduleStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody3$advice(NotesScheduleStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final /* synthetic */ void debug_aroundBody4(NotesScheduleStoreImpl notesScheduleStoreImpl, String string) {
        Log.debug((String)string);
    }

    private static final /* synthetic */ void debug_aroundBody5$advice(NotesScheduleStoreImpl ajc$this, String message, LogAspect ajc$aspectInstance, String s, AroundClosure ajc$aroundClosure, JoinPoint.StaticPart thisJoinPointStaticPart) {
        try {
            if (LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).isDebugEnabled()) {
                LogAspect.ajc$inlineAccessFieldGet$jp_co_connectone_eai_notes_log_LogAspect$jp_co_connectone_eai_notes_log_LogAspect$log(ajc$aspectInstance).debug((Object)(String.valueOf(s) + "(" + thisJoinPointStaticPart.getSourceLocation() + ")"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NotesScheduleStoreImpl.java", Class.forName("jp.co.connectone.eai.notes.store.NotesScheduleStoreImpl"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 210);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 221);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "debug", "jp.co.connectone.log.Log", "java.lang.String:", "message:", "", "void"), 685);
    }
}

