package jp.co.connectone.webproxy.ui.action;

import java.util.*;
import javax.mail.internet.*;
import javax.servlet.*;
import javax.servlet.http.*;

import jp.co.connectone.eai.pop3.exception.ServerCommunicationException;
import jp.co.connectone.eai.pop3.socket.Pop3ConnectorSession;
import jp.co.connectone.store.*;
import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.webapps.commandenv.*;
import jp.co.connectone.webapps.helpers.*;
import jp.co.connectone.webapps.struts.*;
import jp.co.connectone.webapps.tools.*;
import jp.co.connectone.webproxy.ui.logic.Controler;

import org.apache.struts.action.*;

/**
 * @author amanot
 *
 */
public class Pop3MenuAction extends Pop3Action
{

	/* ( Javadoc)
	 * @see jp.co.connectone.webproxy.ui.action.BaseAction#setArgs()
	 */
	protected void setArgs(CommandEnvSet env,DynaActionForm form)
	{
		String cmd = form.getString("cmd");
		String fc = form.getString("fc");
		String d = form.getString("d");
		Integer fidx = (Integer)form.get("fidx");
		Integer midx = (Integer)form.get("midx");
		Integer aidx = (Integer)form.get("aidx");
		Integer cp = (Integer)form.get("cp");
		String name = form.getString("name");
		String at = form.getString("at");
		String submit = form.getString("submit");
Log.trace("submit="+submit);
		if (cmd!=null)if (cmd.length()>0)env.put("cmd",cmd);
		if (fc!=null)if (fc.length()>0)env.put("fc",fc);
		if (d!=null)if (d.length()>0)env.put("date",d);
		if (fidx!=null)env.put("fidx",fidx);
		if (midx!=null)env.put("midx",midx);
		if (aidx!=null)env.put("aidx",aidx);
		if (cp!=null)env.put("cp",cp);
		if (name!=null)if (name.length()>0)env.put("name",name);
		if (at!=null)if (at.length()>0)env.put("at",at);
		if (submit!=null)if (submit.length()>0)env.put("submit",submit);
	}

	/* ( Javadoc)
	 * @see jp.co.connectone.webproxy.ui.action.BaseAction#actionLogic(org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward actionLogic(CommandEnvSet env,ActionMapping mapping, DynaActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception
	{

		String cmd = env.getString("cmd");
		String fc = env.getString("fc");
Log.debug("cmd="+cmd+",fc="+fc);
		String dateStr = env.getString("date");
		Date date = null;
		if (dateStr==null) {
			date = new Date();
		}
		else if (dateStr.length()==0) {
			date = new Date();
		}
		else {
			DateControler dc = new DateControler(dateStr);
			date = dc.getDate();
		}
		request.setAttribute("date",date);

		try {
			if (cmd.equalsIgnoreCase(CMD_INBOX_MAIL)) {
				return processInboxMail(env,mapping, request, fc, date);
			}
			if (cmd.equalsIgnoreCase(CMD_MAIL_SEARCH)) {
				return mapping.findForward("MailSearch");
			}
			if (cmd.equalsIgnoreCase(CMD_NEW_MAIL)) {
				return prepareNewMail(env,request,mapping,fc);
			}
			if (cmd.equalsIgnoreCase(CMD_PROCESS_MAIL)) {
				return processMail(env,form,request,mapping,fc,"NewMailSent");
			}
			if (cmd.equalsIgnoreCase(CMD_PROCESS_MAIL2)) {
				return processMail(env,form,request,mapping,fc,"ReplyMailSent");
			}
		}
		catch (NoSuchRights nsr) {
			return mapping.findForward("authError");
		}
		catch (ServerDown sd) {
			if (sd.getMessage().indexOf("LDAP")>0) {
				return mapping.findForward("authError");
			}
			return mapping.findForward("serverError");
		}
		catch (ServerCommunicationException sce){
			return mapping.findForward("serverCommunicationError");
		}

		return mapping.findForward("error");
	}

	private boolean checkDeleteIgnore(CommandEnvSet env)
	{
		String submit = env.getString("submit");
		if ("폜".equals(submit)) return false;
		return true;
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward prepareNewMail(CommandEnvSet env,HttpServletRequest request,ActionMapping mapping,String fc)
	{
		env.put("cacheIdx",null);
		if (fc.equalsIgnoreCase("New") ) {
			WebMailParseHelper newMail = WebMailParseHelper.getNewMail();
			env.put("eSendMail",newMail);
			env.put("eMailStyle","NewMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("NewMail");
		}
		WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
		if (fc.equalsIgnoreCase("fw")) {
			WebMailParseHelper newMail = WebMailParseHelper.getForwardMail(mail);
			env.put("eSendMail",newMail);
			env.put("eMailStyle","FwMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("FwMail");
		}
		if (fc.equalsIgnoreCase("re")) {
			WebMailParseHelper newMail = WebMailParseHelper.getReplyMail(mail);
			env.put("eSendMail",newMail);
			env.put("eMailStyle","ReplyMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("ReplyMail");
		}
		if (fc.equalsIgnoreCase("reall")) {
			WebMailParseHelper newMail = WebMailParseHelper.getReplyAllMail(mail);
			env.put("eSendMail",newMail);
			env.put("eMailStyle","ReplyMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward("ReplyMail");
		}
		if (fc.equalsIgnoreCase("ret")) {
			WebMailParseHelper newMail = (WebMailParseHelper)env.get("eSendMail");
			request.setAttribute("sendMail",newMail);
			return mapping.findForward((String)env.get("eMailStyle"));
		}
		return mapping.findForward("error");
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward processMail(CommandEnvSet env,DynaActionForm form, HttpServletRequest request,ActionMapping mapping, String fc, String forward) throws Exception
	{
		WebMailParseHelper newMail = (WebMailParseHelper)env.get("eSendMail");
		if (fc.equalsIgnoreCase("restore")) {
			request.setAttribute("sendMail",newMail);
			String mode = env.getString("eMailStyle");
			return mapping.findForward(mode);
		}
		if (fc.equalsIgnoreCase("new")||fc.equalsIgnoreCase("re")||fc.equalsIgnoreCase("reall")||fc.equalsIgnoreCase("fw")) {
			ActionMessages amsgError = processMailInput(form,newMail);
			String submit = form.getString("submit");
Log.debug("submit="+submit);
			if (submit.indexOf("M")>=0) {
				if (amsgError!=null) {
					saveErrors(request, amsgError);
					request.setAttribute("sendMail",newMail);
					if (fc.equalsIgnoreCase("new")){
						return mapping.findForward("NewMail");
					}else if (fc.equalsIgnoreCase("re")){
						return mapping.findForward("ReplyMail");
					}else if (fc.equalsIgnoreCase("fw")){
						return mapping.findForward("FwMail");
					}
					return mapping.findForward("error");
				}
				return sendMail(env,form,mapping,newMail,forward);
			}
			else if (submit.indexOf("[]")>=0) {
				return mapping.findForward("TOAddr");
			}
			else if (submit.indexOf("[CC]")>=0) {
				return mapping.findForward("CCAddr");
			}
			else if (submit.indexOf("[BCC]")>=0) {
				return mapping.findForward("BCCAddr");
			}
			return mapping.findForward("error");
		}
		return mapping.findForward("error");
	}

	/**
	 * @param mapping
	 * @return
	 */
	private ActionForward sendMail(CommandEnvSet env,DynaActionForm form,ActionMapping mapping,WebMailParseHelper newMail,String forward) throws Exception
	{
		String fromString = null;
		if (fromString==null) {
			fromString="ConnectONE";
		}
Log.debug("from:"+fromString);
		newMail.setFrom(fromString);
		String body = newMail.getBody();
		String quatation = form.getString("q");
		if (quatation!=null) {
			if (quatation.equals("y")) {
				body = body + newMail.getOriginalBody();
			}
		}
Log.debug("body="+body);
		newMail.setBody(body);

		try {
			ctrl.sendMail(env.getString("u"),env.getString("p"),newMail.getMail());
		}
		catch(ServerDown e) {
			throw e;
		}
		catch(Exception e) {
			Log.error("",e);
			return mapping.findForward("authError");
		}
		return mapping.findForward(forward);
	}

	/**
	 * @param form
	 */
	private ActionMessages processMailInput(DynaActionForm form,WebMailParseHelper newMail)
	{
		ActionMessages amsgError = null;
		String[] toArray = makeArray(form.getString("TO"));
Log.debug("to[]:"+Arrays.asList(toArray));

		newMail.setTO(toArray);

		String[] ccArray = makeArray(form.getString("CC"));
Log.debug("cc[]:"+Arrays.asList(ccArray));

		newMail.setCC(ccArray);

		String bcc = form.getString("BCC").trim();
		if (bcc.endsWith(",")) {
			bcc = bcc.substring(0,bcc.length()-1);
		}
		String[] bccArray = makeArray(bcc);
Log.debug("bcc[]:"+Arrays.asList(bccArray));

		newMail.setBCC(bccArray);

		newMail.setSubject(form.getString("subject"));
		String body=form.getString("body");
		newMail.setBody(body);

		if (toArray.length==0 && ccArray.length==0 && bccArray.length==0) {
			amsgError = new ActionMessages();
			ActionMessage msg = new ActionMessage("errors.email.void");
			amsgError.add(ActionMessages.GLOBAL_MESSAGE, msg);
		} else {
			List<String> errorList = new ArrayList<String>();
			if (!validateEmailAddress(toArray))errorList.add("");
			if (!validateEmailAddress(ccArray))errorList.add("CC");
			if (!validateEmailAddress(bccArray))errorList.add("BCC");
			if (errorList.size() > 0) {
				amsgError = new ActionMessages();
				ActionMessage msg = new ActionMessage("errors.email",new Object[]{convertString(errorList)});
				amsgError.add("errors.email",msg);
			}
		}

		return amsgError;
	}
	/**
	 * convertString
	 * @param buffer error message
	 * @return String
	 */
	private String convertString(List<String> list) {
		StringBuffer buffer = new StringBuffer();
		for(int i=0; i<list.size(); i++) {
			buffer.append(list.get(i));
		  if ( i != list.size()-1 ) {
			  buffer.append(",");
		  }
		}
		return buffer.toString();
	}
	/**
	 * validateEmailAddress
	 * @param emailArray
	 * @return true valid false invalid
	 */
	private boolean validateEmailAddress(String[] emailArray) {
		boolean rc = true;

		for (int i=0; i<emailArray.length;i++) {
			if ("".equals(emailArray[i])) continue;
			try {
				new InternetAddress(emailArray[i],true);
			} catch (AddressException e) {
				rc = false;
				break;
			}
		}
		return rc;
	}

	private void mailAttrsSet(CommandEnvSet env,HttpServletRequest request, WebMailParseHelper mail)
	{
		Integer currentPage = (Integer)env.get("cp");
		mail.setCurrentPage(currentPage.intValue());
		request.setAttribute("mail",mail);
		IndexList idxList = (IndexList)env.get("eList");
		int max = idxList.size();
		Integer Idx = (Integer)env.get("midx");
		int idx = Idx.intValue();
		if ((idx+1) < max) {
			request.setAttribute("nextIdx",new Integer(idx+1));
		}
		if (idx>0) {
			request.setAttribute("prevIdx",new Integer(idx-1));
		}
		env.put("attach",null);
		env.put("email",mail);
		env.put("cacheIdx",Idx);

	}
	private void mailAttachmentSet(CommandEnvSet env,HttpServletRequest request, DhkWebAttachmentParseHelper att)
	{
		Integer currentPage = (Integer)env.get("cp");
		att.setCurrentPage(currentPage.intValue());
		ServletContext ctx = getServlet().getServletContext();
		String path = ctx.getRealPath("");
		att.setAbsolutePath(path);
		env.put("attach",att);
		request.setAttribute("attach",att);

	}

	private ActionForward processInboxMail(CommandEnvSet env,ActionMapping mapping, HttpServletRequest request, String fc, Date date) throws Exception
	{
		HttpSession session =request.getSession();
		Pop3ConnectorSession cache = (Pop3ConnectorSession)session.getAttribute("Pop3ConnectorSession");
		if (fc.equalsIgnoreCase(FC_ATT)) {
			DhkWebAttachmentParseHelper att = (DhkWebAttachmentParseHelper)env.get("attach");
			if (att != null) {
				mailAttachmentSet(env, request, att);
				return mapping.findForward("Attachment");
			}
			WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
			if (mail == null) {
				mail = getMail(env,cache );
			}
			Integer aidx = (Integer)env.get("aidx");
			IMailDTO dto = mail.getMail();
			if (dto.getNumberOfAttachments()>0) {
				att = new DhkWebAttachmentParseHelper(dto.getAttachment(aidx.intValue()));
				att.setBodyLength(mail.getBodyLength());
				mailAttachmentSet(env, request, att);
			}
			return mapping.findForward("Attachment");
		}
		if (fc.equalsIgnoreCase(FC_VIEW)) {
			WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
			if (mail != null) {
				Integer cacheIdx = (Integer)env.get("cacheIdx");
				Integer idx = (Integer)env.get("midx");
				if (idx.equals(cacheIdx)) {
					mailAttrsSet(env,request, mail);
					int cp = ((Integer)env.get("cp")).intValue();
					if (cp>0) {
						return mapping.findForward("Mail2");
					}
					return mapping.findForward("InboxMail");
				}
			}
			mail = getMail(env,cache);
			mailAttrsSet(env,request, mail);
			return mapping.findForward("InboxMail");
		}
		if (fc.equalsIgnoreCase(FC_LIST) || fc.equalsIgnoreCase(FC_RESET)) {
			env.put("cacheIdx",null);
			int listSize = Controler.LISTSIZE;
			int page = 0;
			if (env.get("cp")!=null) {
				page = (Integer)env.get("cp");
			}

			if (fc.equalsIgnoreCase(FC_RESET)) {
				cache=new Pop3ConnectorSession();
				date = new Date();
				env.put("date",DateControler.getDateStr(date));
				request.setAttribute("date",date);
				page=0;
			}
			int start = listSize*page;
			int end = listSize*(page+1);
			StrutsArrayList list = getAllMails(env,cache,date,start,end);
			if (fc.equalsIgnoreCase(FC_RESET)) {
				session.setAttribute("Pop3ConnectorSession",cache);
			}
			setList(env,request,list,page);

			Integer cp = new Integer(list.getCurrentPage());
			setCmdCache(request.getSession(),CMD_INBOX_MAIL,null,cp);

			return mapping.findForward("Inbox");
		}
		if (fc.equalsIgnoreCase(FC_HEAD)) {
//			env.put("cacheIdx",null);
			request.setAttribute("mail",env.get("email"));
			return mapping.findForward("MailHeader");
		}
		if (fc.equalsIgnoreCase(FC_DELCHECK)) {
//			env.put("cacheIdx",null);
			return mapping.findForward("MailDelCheck");
		}
		if (fc.equalsIgnoreCase(FC_DEL)) {
			if (checkDeleteIgnore(env)) {
				WebMailParseHelper mail = (WebMailParseHelper)env.get("email");
				mailAttrsSet(env,request, mail);
				int cp = ((Integer)env.get("cp")).intValue();
				if (cp>0) {
					return mapping.findForward("Mail2");
				}
				return mapping.findForward("InboxMail");
			}
			env.put("cacheIdx",null);
			env.put("cp",null);
			deleteMail(env,cache);
			return mapping.findForward("eMenu");
		}
		env.put("cacheIdx",null);
		return mapping.findForward("error");
	}

	void setList(CommandEnvSet env,HttpServletRequest request,StrutsArrayList list,int page)
	{
		HttpSession session=request.getSession(true);

		list.setCurrentPage(page);

		if (list.size()==0) {
			request.setAttribute("list",list);
			return;
		}
		IRecordObject sample = (IRecordObject)list.get(0);
		if (sample instanceof FolderMetadata) {
			session.setAttribute("eFolderList",list);
		}
		else {
			env.put("eList",list.getIdxList());
		}
		request.setAttribute("list",list);
	}

	private WebMailParseHelper getMail(CommandEnvSet env, Pop3ConnectorSession cache) throws Exception
	{
		Integer idx = (Integer)env.get("midx");
		IndexList idxList = (IndexList)env.get("eList");
		IObjectIndex mid = (IObjectIndex)idxList.get(idx.intValue());
		return ctrl.getMail(env.getString("u"),env.getString("p"),cache,mid);
	}

	private void deleteMail(CommandEnvSet env,Pop3ConnectorSession cache) throws Exception
	{
		WebMailParseHelper o = (WebMailParseHelper)env.get("email");
		IObjectIndex mid = o.getOid();
		ctrl.delete(env.getString("u"),env.getString("p"),mid);
	}

	private StrutsArrayList getAllMails(CommandEnvSet env, Pop3ConnectorSession cache,Date date, int start, int end) throws Exception
	{
		StrutsArrayList rc = ctrl.getMailList(env.getString("u"),env.getString("p"),cache,null,date,start,end);
		return rc;
	}

	private void setCmdCache(HttpSession session,String cmd,Integer idx,Integer cp)
	{
		if (session==null) return;
		session.setAttribute("cache_return_cmd", cmd);
		if (idx!=null) {
			session.setAttribute("cache_return_idx", idx);
		}
		if (cp!=null) {
			session.setAttribute("cache_return_cp", cp);
		}
	}
}
