/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.common;
import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;

import jp.co.connectone.exception.*;
import jp.co.connectone.log.Log;

/**
 * @author amanot
 *
 */
public class DNSTool extends ActiveActiveServerToolBaseImpl
{
	private static boolean toggle=false;
	private int toggleCount;
	public int getToggleCount()
	{
		return toggleCount;
	}

	public void setToggleCount(int toggleCount)
	{
		this.toggleCount = toggleCount;
	}

	public boolean isToggle()
	{
		return toggle;
	}

	public void setToggle(boolean toggle)
	{
		DNSTool.toggle = toggle;
	}

	protected String dnsServerIP=null;
	protected String dnsServerIP2=null;
	public DNSTool (String serverIP,String serverIP2)
	{
		this.dnsServerIP = serverIP;
		this.dnsServerIP2 = serverIP2;
	}
	public String getIPAddress(String name) throws HandleException
	{
		Properties props = new Properties();
		props.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.dns.DnsContextFactory");
		props.put(Context.PROVIDER_URL, "dns://" + getServerToConnect(dnsServerIP, dnsServerIP2) );
		String retStr=null;
		try {
			InitialDirContext idctx = new InitialDirContext(props);
			Attributes attrs = idctx.getAttributes(name);
			NamingEnumeration<? extends Attribute> allAttr = attrs.getAll();
			while (allAttr.hasMore()) {
				Attribute attr = (Attribute) allAttr.next();
				NamingEnumeration<?> values = attr.getAll();
				if (values.hasMore()) {
					retStr = (String)values.next();
				}
			}
		}
		catch (CommunicationException ce) {
			if (toggleOn())	{
				return getIPAddress(name);
			}
			else {
				throw new HandleException(ce);
			}
		}
		catch (NamingException e) {
			Log.error("error on getting IPAddress from DNS",e);
			throw new HandleException(e);
		}
		return retStr;
	}
}
