/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.client;

import jp.co.connectone.store.ISearchType;
import jp.co.connectone.store.SearchCondition;

/**
 * @author amanot
 *
 */
public class ScheduleSearchCondition extends SearchCondition {
	@SuppressWarnings("unused")
	private ScheduleSearchCondition(){};
	public enum CONDITION implements ISearchType {
		TYPE_ACCOUNTNAME,TYPE_SINGLEDATE,TYPE_OID
	}
	
	public ScheduleSearchCondition(ISearchType type,Object value)
	{
		super(type,value);
	}
	protected String getTypeName()
	{
		if (type==CONDITION.TYPE_ACCOUNTNAME) return "CONDITION_TYPE_ACCOUNTNAME";
		if (type==CONDITION.TYPE_SINGLEDATE) return "CONDITION_TYPE_SINGLEDATE";
		if (type==CONDITION.TYPE_OID) return "CONDITION_TYPE_OID";
		return "UNKNOWN TYPE";
	}

	protected boolean typeValidation(ISearchType type)
	{
		if (type==CONDITION.TYPE_ACCOUNTNAME) return true;
		if (type==CONDITION.TYPE_SINGLEDATE) return true;
		if (type==CONDITION.TYPE_OID) return true;
		return false;
	}
}
