/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.store.pim;

import java.util.Comparator;
import java.util.Date;


public class IMailDTOComparator implements Comparator<IMailDTO>
{
	public static final int SUBJECT=0;
	public static final int SENTDATE=1;
	public static final int RECEIVEDDATE=2;
	private int sortKey=0;
	private boolean reverce=false;
	public IMailDTOComparator(int sortKey,boolean isReverce)
	{
		this.sortKey = sortKey;
		this.reverce = isReverce;
	}

	public int compare(IMailDTO o1, IMailDTO o2)
	{
		if (o1==null) {
			return 0;
		}
		if (o2==null) {
			return 0;
		}
		IMailDTO src = o1;
		IMailDTO dst = o2;
		switch (sortKey) {
		case SUBJECT:
			String s1 = src.getSubject();
			String s2 = dst.getSubject();
			if (reverce) {
				return s2.compareTo(s1);
			}
			else {
				return s1.compareTo(s2);
			}
		case SENTDATE:
			Date d1 = src.getSentDate();
			Date d2 = dst.getSentDate();
			if (reverce) {
				return d2.compareTo(d1);
			}
			else {
				return d1.compareTo(d2);
			}
		case RECEIVEDDATE:
			d1 = src.getReceivedDate();
			d2 = dst.getReceivedDate();
			if (reverce) {
				return d2.compareTo(d1);
			}
			else {
				return d1.compareTo(d2);
			}
		}
		
		return 0;
	}

}
