/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exch2k.dav;
import java.util.*;


/**
 * @author amanot
 *
 */
public class DavSearchCondition {
	private String name;
	private Object value;
	private DavSearchType type;
	private DavSearchOperator operator;
	
	protected String buildOpString(String namePart,DavSearchOperator operator,String valuePart)
	{
		namePart = "\"" + namePart + "\"";
		if (operator.equals(DavSearchOperator.OP_NOT_EQUAL)) return "NOT("+namePart+" = "+valuePart+")";
		if (operator.equals(DavSearchOperator.OP_BIG_EQUAL)) return namePart + " >= " + valuePart;
		if (operator.equals(DavSearchOperator.OP_BIG)) return namePart + " > " + valuePart;
		if (operator.equals(DavSearchOperator.OP_NOT_BIG_EQUAL)) return "NOT("+namePart+" >= "+valuePart+")";
		if (operator.equals(DavSearchOperator.OP_NOT_BIG)) return "NOT("+namePart+" > "+valuePart+")";
		if (operator.equals(DavSearchOperator.OP_SMALL_EQUAL)) return namePart + " <= " + valuePart;
		if (operator.equals(DavSearchOperator.OP_SMALL)) return namePart + " < " + valuePart;
		if (operator.equals(DavSearchOperator.OP_NOT_SMALL_EQUAL)) return "NOT("+namePart+" <= "+valuePart+")";
		if (operator.equals(DavSearchOperator.OP_NOT_SMALL)) return "NOT("+namePart+" < "+valuePart+")";
		if (operator.equals(DavSearchOperator.OP_LIKE)) return namePart + " LIKE " + valuePart;
		if (operator.equals(DavSearchOperator.OP_FORWARD_LIKE)) return namePart + " LIKE " + valuePart;
		return namePart + "=" + valuePart;
	}
	
	protected String buildCast(DavSearchType type,Object value,DavSearchOperator operator)
	{
		DavDateFormat sdf = new DavDateFormat();
		
		if (type.equals(DavSearchType.TYPE_INTEGER)) return "\"" + (String)value + "\"";
		if (type.equals(DavSearchType.TYPE_DATETIME_SZ)) return "CAST(\"" + sdf.format((Date)value) + "\" AS \"dateTime\")";
		String rc = "'" + (String)value + "'";
		if (type.equals(DavSearchType.TYPE_STRING)) {
			if (operator.equals(DavSearchOperator.OP_LIKE)) {
				rc = "'%" + (String)value + "%'";
			}
			else if (operator.equals(DavSearchOperator.OP_FORWARD_LIKE)) {
				rc = "'" + (String)value + "%'";
			}
		}
		return rc;
	}
	
	public String getDavSQLWhereClause()
	{
		String clause = null;
		clause = buildOpString(name,operator,buildCast(type,value,operator));
		return clause;
	}
	/**
	 * @return name ߂܂B
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name name ݒB
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return operator ߂܂B
	 */
	public DavSearchOperator getOperator() {
		return operator;
	}
	/**
	 * @param operator operator ݒB
	 */
	public void setOperator(DavSearchOperator operator) {
		this.operator = operator;
	}
	/**
	 * @return type ߂܂B
	 */
	public DavSearchType getType() {
		return type;
	}
	/**
	 * @param type type ݒB
	 */
	public void setType(DavSearchType type) {
		this.type = type;
	}
	/**
	 * @return value ߂܂B
	 */
	public Object getValue() {
		return value;
	}
	/**
	 * @param value value ݒB
	 */
	public void setValue(Object value) throws IllegalArgumentException
	{
		
		if (value!=null) {
			if(!(value instanceof String) && !(value instanceof Date)) {
				throw new IllegalArgumentException("value must be an instance of String/Date");
			}
		}
		this.value = value;
	}
	public DavSearchCondition(String name,DavSearchType type,Object value,DavSearchOperator operator) throws IllegalArgumentException
	{
		setName(name);
		setType(type);
		setValue(value);
		setOperator(operator);
	}
}
