import java.util.Arrays;

import jp.co.connectone.eai.exch2k.store.*;
import jp.co.connectone.eai.exch2k.user.Exch2kAccountData;
import jp.co.connectone.log.Log;
import junit.framework.TestCase;
import jp.co.connectone.store.pim.*;
import jp.co.connectone.store.*;
import jp.co.connectone.user.*;

import java.util.*;
import java.io.FileOutputStream;
import java.text.*;
/**
 * @author amanot
 *
 */
public class TestExch2kMailImpl extends TestCase {
	private Exch2kMailStoreImpl mailStore;
	private PasswordBasedAccountDataImpl acc;
	private Exch2kServiceInfo si;
	/* ( Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		mailStore = new Exch2kMailStoreImpl();
		IUserKey uid = new BasicUserKey(String.class.getName(),"test");
		si = (Exch2kServiceInfo)mailStore.getServiceInfo();
		si.setServerAddress("172.16.3.1");
		acc = new Exch2kAccountData(uid,si);
		acc.setUserID("test");
		acc.setPassword("********");
	}
	/* ( Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		mailStore = null;
	}
	
	public void teXstGetHeaders() throws Exception
	{
		assertNotNull(mailStore);
		IMailDTO[] h = mailStore.getHeaders(acc,mailStore.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER));
		assertNotNull(h);
		assertTrue(h.length>0);
		assertFalse(h[0].isNew());
		for (int i=0;i<h.length;i++) {
			dumpDTO(h[i]);
		}
	}
	
	public void testGetSentMailsByDate() throws Exception
	{
		assertNotNull(mailStore);
		Date date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse("2010-04-14 00:00:00");
		IMailDTO[] h = mailStore.getSentMailsByDate(acc,date);
		assertNotNull(h);
		assertTrue(h.length>0);
		assertFalse(h[0].isNew());
		for (int i=0;i<h.length;i++) {
			dumpDTO(h[i]);
		}
	}
	
	public void testGetHeadersByDate() throws Exception
	{
		assertNotNull(mailStore);
		Date date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse("2010-04-14 00:00:00");
		IMailDTO[] h = mailStore.getHeadersByDate(acc,mailStore.getPresetDestination(acc,IMailStore.DEST_TYPE_SENT_FOLDER),date);
		assertNotNull(h);
		assertTrue(h.length>0);
		assertFalse(h[0].isNew());
		for (int i=0;i<h.length;i++) {
			dumpDTO(h[i]);
		}
//		h = mailStore.getHeadersByDate(acc,"MgC",new Date());
//		assertNotNull(h);
//		for (int i=0;i<h.length;i++) {
//			dumpDTO(h[i]);
//		}
	}
	
	public void testGetMailFolders() throws Exception
	{
		assertNotNull(mailStore);
		FolderMetadata[] h = mailStore.getMailFolders(acc,null);
		assertNotNull(h);
		for (int i=0;i<h.length;i++) {
			Log.debug(h[i].getOid().toString());
			Log.debug(h[i].getFolderName());
		}
	}
	
	public void testGetMailsByDate() throws Exception
	{
		assertNotNull(mailStore);
		Date date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse("2010-04-14 00:00:00");
		IMailDTO[] m = mailStore.getMailsByDate(acc,mailStore.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),date);
		assertNotNull(m);
		assertTrue(m.length>0);
		assertFalse(m[0].isNew());
		for (int i=0;i<m.length;i++) {
			dumpDTO(m[i]);
		}
/*
		m = mailStore.getMailsByDate(acc,"MgC",new Date());
		assertNotNull(m);
		for (int i=0;i<m.length;i++) {
			dumpDTO2(m[i]);
		}
*/
	}
	
	public void teXstSendMail() throws Exception
	{
		assertNotNull(mailStore);
		Exch2kMailDTO mail = (Exch2kMailDTO)mailStore.getMail(acc,mailStore.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),new BasicObjectIndex("http://172.16.3.1/exchange/test@connectone.co.jp/%E5%8F%97%E4%BF%A1%E3%83%88%E3%83%AC%E3%82%A4/%E3%80%90c1v2_test%E3%80%91%E5%95%8F%E9%A1%8C%E3%81%AA%E3%81%97%2020100414.EML"));
		
		assertNotNull(mail);
		MailAddress[] a = {new MailAddress("test@maxsol.co.jp")};
		mail.setTo(a);
		mail.setDisplayto("\DisplayToȂ̂");
Log.debug("send mail");
		dumpDTO(mail);
		mailStore.sendMail(acc,mail);
	}
	
	public void testGetMail() throws Exception
	{
		assertNotNull(mailStore);
		IMailDTO mail = mailStore.getMail(acc,mailStore.getPresetDestination(acc,IMailStore.DEST_TYPE_DEFAULT_MAIL_FOLDER),new BasicObjectIndex("http://172.16.3.1/exchange/test@connectone.co.jp/%E5%8F%97%E4%BF%A1%E3%83%88%E3%83%AC%E3%82%A4/%E3%80%90c1v2_test%E3%80%91%E5%95%8F%E9%A1%8C%E3%81%AA%E3%81%97%2020100414.EML"));
		assertNotNull(mail);
		dumpDTO(mail);
	}
	
	private void dumpDTO(IMailDTO dto)
	{
		if (dto instanceof Exch2kMailDTO) {
			Exch2kMailDTO dto2 = (Exch2kMailDTO) dto;
			Log.debug("=====Exch2kMailDTO=====================");
			Log.debug("oid:"+dto2.getOid());
			Log.debug("attachmentfilename:"+dto2.getAttachmentfilename());
			Log.debug("bcc:"+dto2.getBcc());
			Log.debug("calendar:"+dto2.getCalendar());
			Log.debug("cc:"+dto2.getCc());
			Log.debug("contacts:"+dto2.getContacts());
			Log.debug("content-disposition-type:"+dto2.getContent_disposition_type());
			Log.debug("content-media-type:"+dto2.getContent_media_type());
			Log.debug("date:"+dto2.getDate());
			Log.debug("datereceived:"+dto2.getDatereceived());
			Log.debug("deleteditems:"+dto2.getDeleteditems());
			Log.debug("displaycc:"+dto2.getDisplaycc());
			Log.debug("displayto:"+dto2.getDisplayto());
			Log.debug("drafts:"+dto2.getDrafts());
			Log.debug("expiry-date:"+dto2.getExpiry_date());
			Log.debug("flagcompleted:"+dto2.getFlagcompleted());
			Log.debug("from:"+dto2.getFrom());
			Log.debug("fromemail:"+dto2.getFromemail());
			Log.debug("fromname:"+dto2.getFromname());
			Log.debug("hasattachment:"+dto2.isHasattachment());
			Log.debug("htmldescription:"+dto2.getHtmldescription());
			Log.debug("importance:"+dto2.getImportance());
			Log.debug("inbox:"+dto2.getInbox());
			Log.debug("journal:"+dto2.getJournal());
			Log.debug("messageflag:"+dto2.getMessageflag());
			Log.debug("msgfolderroot:"+dto2.getMsgfolderroot());
			Log.debug("normalizedsubject:"+dto2.getNormalizedsubject());
			Log.debug("notes:"+dto2.getNotes());
			Log.debug("outbox:"+dto2.getOutbox());
			Log.debug("priority:"+dto2.getPriority());
			Log.debug("read:"+dto2.isRead());
			Log.debug("reply-by:"+dto2.getReply_by());
			Log.debug("reply-to:"+dto2.getReply_to());
			Log.debug("savedestination:"+dto2.getSavedestination());
			Log.debug("saveinsent:"+dto2.isSaveinsent());
			Log.debug("sender:"+dto2.getSender());
			Log.debug("senderemail:"+dto2.getSenderemail());
			Log.debug("sendername:"+dto2.getSendername());
			Log.debug("sendmsg:"+dto2.getSendmsg());
			Log.debug("sentitems:"+dto2.getSentitems());
			Log.debug("subject:"+dto2.getSubject());
			Log.debug("submitted:"+dto2.isSubmitted());
			Log.debug("tasks:"+dto2.getTasks());
			Log.debug("textdescription:"+dto2.getTextdescription());
			Log.debug("thread-topic:"+dto2.getThread_topic());
			Log.debug("to:"+dto2.getTo());
			Log.debug("unreadcount:"+dto2.getUnreadcount());
			if (dto.getNumberOfAttachments()>0) {
				AttachmentDTO att = dto.getAttachment(0);
				Log.debug("dump file "+att.getFileName()+" to c:\\tmp");
				try {
					FileOutputStream fos = new FileOutputStream("c:\\tmp\\"+att.getFileName());
					fos.write(att.getFileBody());
				}
				catch (Exception e) {
					Log.debug("dump failed");
				}
			}
			Log.debug("=======================================");
		}
		else {
			dumpDTO2(dto);
		}
		
	}
	
	private void dumpDTO2(IMailDTO dto)
	{
		HeaderDTO h = dto.getHeader();
		Log.debug("=======================================");
		Log.debug(h.getHeaderSubject());
		Log.debug(h.getHeaderFrom().getRawAddress());
//		Log.debug(h.getHeaderReplyTo());
		Log.debug(h.getHeaderUIDL());
		Log.debug(array2String(h.getHeaderTo()));
		if (h.getHeaderCC()!=null) Log.debug(array2String(h.getHeaderCC()));
		Log.debug(dto.getBody());
		if (dto.getNumberOfAttachments()>0) {
			AttachmentDTO att = dto.getAttachment(0);
			Log.debug("dump file "+att.getFileName()+" to c:\\tmp");
			try {
				FileOutputStream fos = new FileOutputStream("c:\\tmp\\"+att.getFileName());
				fos.write(att.getFileBody());
			}
			catch (Exception e) {
				Log.debug("dump failed");
			}
		}
		Log.debug("=======================================");
	}
	
	private String array2String(MailAddress[] ar)
	{
		return "" + Arrays.asList(ar);
	}
}
