/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.ews;


import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.*;

import com.microsoft.schemas.exchange.services._2006.types.*;

public class EWS_CONTAINS_SearchConditionCollection extends EWSSearchConditionCollection
{

	@Override
	public SearchExpressionType generateSearchExpression() throws HandleException
	{
		ContainsExpressionType ct = new ContainsExpressionType();
		for (ISearchConditionElement o : this) {
			if (o instanceof ISearchCondition) {
				EWSSearchCondition cond = (EWSSearchCondition)o;
				ct.setPath(ExchEWSTranslator.createFieldURI(cond.getField()));
				ConstantValueType val=new ConstantValueType();
				val.setValue((String)cond.getValue());
				ct.setConstant(val);
				ct.setContainmentComparison(ContainmentComparisonType.LOOSE_AND_IGNORE_CASE_AND_IGNORE_NON_SPACE);
				ct.setContainmentMode(ContainmentModeType.SUBSTRING);
			}
		}
		
		return ct;
	}

}
