/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.ssl;

import javax.net.ssl.*;

import jp.co.connectone.log.Log;

public class NoSecurityHostnameVerifier implements HostnameVerifier
{
	private static final String warnMessage=" anyway allow connect without hostname verification!";

	@Override
	public boolean verify(String urlName, SSLSession session)
	{
		String sslName = session.getPeerHost();
		if (sslName==null) {
			Log.warn("server name from SSL certificate is null."+warnMessage);
		}
		else if (sslName.equalsIgnoreCase(urlName)) {
			Log.warn("hostname("+urlName+") not equals to server name from SSL certificate("+sslName+"). "+warnMessage);
		}
		return true;
	}

}
