/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.eai.exchews.store;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.microsoft.schemas.exchange.services._2006.types.*;

import jp.co.connectone.eai.exchews.util.ExchEWSImportance;
import jp.co.connectone.eai.exchews.util.ExchEWSTranslator;
import jp.co.connectone.log.Log;
import jp.co.connectone.store.BasicRecordObject;
import jp.co.connectone.store.pim.AttachmentDTO;

public abstract class ExchewsItemBase extends BasicRecordObject
{
	public enum SENSITIVITY {
		NORMAL("Normal"),
		PERSONAL("Personal"),
		PRIVATE("Private"),
		CONFIDENTIAL("Confidential");
		private String value;
		private SENSITIVITY(String val) {value = val;}
		public String getValue(){return value;}
	}
	private static final long serialVersionUID = 1L;
	protected String itemClass;
	protected String subject;
	protected SENSITIVITY sensitivity;
	protected String body;
	protected AttachmentDTO[] attachments;
	protected List<ItemAttachmentType> ewsItemAttachments=null;
	protected Date dateTimeReceived;
	protected int size;
	protected ExchEWSImportance importance;
	protected boolean submitted;
	protected boolean draft;
	protected boolean fromMe;
	protected boolean resend;
	protected boolean unmodified;
	protected Date dateTimeSent;
	protected Date dateTimeCreated;
	protected boolean reminderIsSet;


	protected String reminderMinutesBeforeStart;
	protected String displayCc;
	protected String displayTo;
	protected boolean hasattachments;
	protected String culture;
	protected Date lastModifiedTime;

	protected String[] baseItemNameList = {
			"mimeContent",
		    "itemId",
		    "parentFolderId",
		    "itemClass",
		    "subject",
		    "sensitivity",
		    "body",
		    "attachments",
		    "dateTimeReceived",
		    "size",
		    "categories",
		    "importance",
		    "inReplyTo",
		    "isSubmitted",
		    "isDraft",
		    "isFromMe",
		    "isResend",
		    "isUnmodified",
		    "internetMessageHeaders",
		    "dateTimeSent",
		    "dateTimeCreated",
		    "responseObjects",
		    "reminderDueBy",
		    "reminderIsSet",
		    "reminderMinutesBeforeStart",
		    "displayCc",
		    "displayTo",
		    "hasAttachments",
		    "extendedProperty",
		    "culture",
		    "effectiveRights",
		    "lastModifiedName",
		    "lastModifiedTime"
	};

	public ExchewsItemBase()
	{
		super();
	}

	public String getItemClass()
	{
		return itemClass;
	}

	public void setItemClass(String itemClass)
	{
		this.itemClass = itemClass;
	}

	public String getSubject()
	{
		return subject;
	}

	public void setSubject(String subject)
	{
		this.subject = subject;
	}

	public SENSITIVITY getSensitivity()
	{
		return sensitivity;
	}

	public void setSensitivity(SENSITIVITY sensitivity)
	{
		this.sensitivity = sensitivity;
	}

	public Date getDateTimeReceived()
	{
		return dateTimeReceived;
	}

	public void setDateTimeReceived(Date dateTimeReceived)
	{
		this.dateTimeReceived = dateTimeReceived;
	}

	public ExchEWSImportance getImportance()
	{
		return importance;
	}

	public void setImportance(ExchEWSImportance importance)
	{
		this.importance = importance;
	}

	public boolean isSubmitted()
	{
		return submitted;
	}

	public void setSubmitted(boolean submitted)
	{
		this.submitted = submitted;
	}

	public boolean isDraft()
	{
		return draft;
	}

	public void setDraft(boolean draft)
	{
		this.draft = draft;
	}

	public boolean isFromMe()
	{
		return fromMe;
	}

	public void setFromMe(boolean fromMe)
	{
		this.fromMe = fromMe;
	}

	public boolean isResend()
	{
		return resend;
	}

	public void setResend(boolean resend)
	{
		this.resend = resend;
	}

	public boolean isUnmodified()
	{
		return unmodified;
	}

	public void setUnmodified(boolean unmodified)
	{
		this.unmodified = unmodified;
	}

	public Date getDateTimeSent()
	{
		return dateTimeSent;
	}

	public void setDateTimeSent(Date dateTimeSent)
	{
		this.dateTimeSent = dateTimeSent;
	}

	public Date getDateTimeCreated()
	{
		return dateTimeCreated;
	}

	public void setDateTimeCreated(Date dateTimeCreated)
	{
		this.dateTimeCreated = dateTimeCreated;
	}

	public boolean isReminderIsSet()
	{
		return reminderIsSet;
	}

	public void setReminderIsSet(boolean reminderIsSet)
	{
		this.reminderIsSet = reminderIsSet;
	}

	public String getReminderMinutesBeforeStart()
	{
		return reminderMinutesBeforeStart;
	}

	public void setReminderMinutesBeforeStart(String reminderMinutesBeforeStart)
	{
		this.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
	}

	public String getDisplayCc()
	{
		return displayCc;
	}

	public void setDisplayCc(String displayCc)
	{
		this.displayCc = displayCc;
	}

	public String getDisplayTo()
	{
		return displayTo;
	}

	public void setDisplayTo(String displayTo)
	{
		this.displayTo = displayTo;
	}

	public boolean isHasAttachments()
	{
		return hasattachments;
	}

	public void setHasAttachments(boolean hasattachments)
	{
		this.hasattachments = hasattachments;
	}

	public String getCulture()
	{
		return culture;
	}

	public void setCulture(String culture)
	{
		this.culture = culture;
	}

	public Date getLastModifiedTime()
	{
		return lastModifiedTime;
	}

	public void setLastModifiedTime(Date lastModifiedTime)
	{
		this.lastModifiedTime = lastModifiedTime;
	}

	public String[] getBaseItemNameList()
	{
		return baseItemNameList;
	}

	public void setBaseItemNameList(String[] baseItemNameList)
	{
		this.baseItemNameList = baseItemNameList;
	}

	public String getBody()
	{
		return body;
	}

	public void setBody(String body)
	{
		this.body = body;
	}

	public AttachmentDTO[] getAttachments()
	{
		return attachments;
	}

	public void setAttachments(AttachmentDTO[] attachments)
	{
		this.attachments = attachments;
	}

	public int getSize()
	{
		return size;
	}

	public void setSize(int size)
	{
		this.size = size;
	}

	public void convertAndSetEWSAttachments(List<AttachmentType> attaches)
	{
		if (attaches==null) return;
		if (attaches.size()==0) return;
		
		List<AttachmentDTO>  arr = new ArrayList<AttachmentDTO>();
		for (AttachmentType attach : attaches) {
			if (attach instanceof FileAttachmentType) {
				FileAttachmentType fat = (FileAttachmentType)attach;
				AttachmentDTO att = new AttachmentDTO();
				att.setFileName(fat.getName());
				att.setFileBody(fat.getContent());
				Log.trace("attach:"+att.getFileName());
				arr.add(att);
			}
			else if (attach instanceof ItemAttachmentType) {
				//TODO: enhancement for handling ItemAttachementType on Forward mail needed.
				Log.warn("unsupported type ItemAttachmentType detected.");
				ItemAttachmentType iat = (ItemAttachmentType)attach;
				if (ewsItemAttachments==null) {
					ewsItemAttachments = new ArrayList<ItemAttachmentType>();
				}
				ewsItemAttachments.add(iat);				
			}
			else {
				Log.warn("unsupported type "+attach.getClass().getName()+" detected.");
			}
		}
		setAttachments(arr.toArray(new AttachmentDTO[0]));
	}

	protected static SENSITIVITY MSSensiticity2C1Sensitivity(SensitivityChoicesType ms)
	{
		if (ms==null) return null;
		SENSITIVITY val=null;
		switch (ms) {
		case CONFIDENTIAL:
			val=SENSITIVITY.CONFIDENTIAL;
			break;
		case NORMAL:
			val=SENSITIVITY.NORMAL;
			break;
		case PERSONAL:
			val=SENSITIVITY.PERSONAL;
			break;
		case PRIVATE:
			val=SENSITIVITY.PRIVATE;
			break;
		}
		return val;
	}

	protected static SensitivityChoicesType C1Sensitivity2MSSensiticity(SENSITIVITY c1)
	{
		if (c1==null) return null;
		SensitivityChoicesType val=null;
		switch (c1) {
		case CONFIDENTIAL:
			val=SensitivityChoicesType.CONFIDENTIAL;
			break;
		case NORMAL:
			val=SensitivityChoicesType.NORMAL;
			break;
		case PERSONAL:
			val=SensitivityChoicesType.PERSONAL;
			break;
		case PRIVATE:
			val=SensitivityChoicesType.PRIVATE;
			break;
		}
		return val;
	}
	
	protected static ExchewsItemBase convertFromItemType(ExchewsItemBase dto,ItemType msg) throws Exception
	{
		if (msg == null) return null;
		if (dto==null) return null;
		dto.setNew(false);
		dto.setOid(new ExchewsObjectIndex(msg.getItemId()));

		dto.setItemClass(msg.getItemClass());
		dto.setSubject(msg.getSubject());
		if (msg.getSensitivity()!=null)dto.setSensitivity(MSSensiticity2C1Sensitivity(msg.getSensitivity()));
		if (msg.getDateTimeReceived()!=null)dto.setDateTimeReceived(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getDateTimeReceived()));
		dto.setSize(msg.getSize());
		if (msg.getImportance()!=null)dto.setImportance(ExchEWSTranslator.convertEWSImportantType2C1Importance(msg.getImportance()));
		dto.setSubmitted(msg.isIsSubmitted());
		dto.setDraft(msg.isIsDraft());
		dto.setFromMe(msg.isIsFromMe());
		dto.setResend(msg.isIsResend());
		dto.setUnmodified(msg.isIsUnmodified());
		if (msg.getDateTimeSent()!=null)dto.setDateTimeSent(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getDateTimeSent()));
		if (msg.getDateTimeCreated()!=null)dto.setDateTimeCreated(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getDateTimeCreated()));
		if (msg.isReminderIsSet()!=null)dto.setReminderIsSet(msg.isReminderIsSet());
		if (dto.isReminderIsSet()) {
			dto.setReminderMinutesBeforeStart(msg.getReminderMinutesBeforeStart());
		}
		dto.setDisplayCc(msg.getDisplayCc());
		dto.setDisplayTo(msg.getDisplayTo());
		dto.setHasAttachments(msg.isHasAttachments());
		dto.setCulture(msg.getCulture());
		if (msg.getBody()!=null)dto.setBody(msg.getBody().getValue());
		if (msg.getLastModifiedTime()!=null)dto.setLastModifiedTime(ExchEWSTranslator.convertEWSDateTime2JavaDate(msg.getLastModifiedTime()));

		dto.setBeanData();
		return dto;
	}
	
	protected static ItemType convertToItemType(ItemType msg,ExchewsItemBase dto) throws Exception
	{
		if (msg == null) return null;
		if (dto==null) return null;

		if (dto.getOid()!= null) msg.setItemId((ItemIdType) dto.getOid().getIndex());
		msg.setItemClass(dto.getItemClass());
		msg.setSubject(dto.getSubject());
//		if (dto.getSensitivity()!=null)msg.setSensitivity(C1Sensitivity2MSSensiticity(dto.getSensitivity()));
//		if (dto.getDateTimeReceived()!=null)msg.setDateTimeReceived(ExchEWSTranslator.convertJavaDate2EWSDateTime(dto.getDateTimeReceived()));
//		msg.setSize(dto.getSize());
//		if (dto.getImportance()!=null)msg.setImportance(ExchEWSTranslator.convertC1Importance2EWSImportantType(dto.getImportance()));
//		msg.setIsSubmitted(dto.isSubmitted());
//		msg.setIsDraft(dto.isDraft());
//		msg.setIsFromMe(dto.isFromMe());
//		msg.setIsResend(dto.isResend());
//		msg.setIsUnmodified(dto.isUnmodified());
//		if (dto.getDateTimeSent()!=null)msg.setDateTimeSent(ExchEWSTranslator.convertJavaDate2EWSDateTime(dto.getDateTimeSent()));
//		if (dto.getDateTimeCreated()!=null)msg.setDateTimeCreated(ExchEWSTranslator.convertJavaDate2EWSDateTime(dto.getDateTimeCreated()));
//		msg.setReminderIsSet(dto.isReminderIsSet());
//		if (msg.isReminderIsSet()) {
//			msg.setReminderMinutesBeforeStart(dto.getReminderMinutesBeforeStart());
//		}
//		msg.setDisplayCc(dto.getDisplayCc());
//		msg.setDisplayTo(dto.getDisplayTo());
//		msg.setHasAttachments(dto.isHasAttachments());
//		msg.setCulture(dto.getCulture());
		if (dto.getBody()!=null) {
			BodyType body = new BodyType();
			body.setBodyType(BodyTypeType.TEXT);
			body.setValue(dto.getBody());
			msg.setBody(body);
		}
//		if (dto.getLastModifiedTime()!=null)msg.setLastModifiedTime(ExchEWSTranslator.convertJavaDate2EWSDateTime(dto.getLastModifiedTime()));
		
		return msg;
	}
}