/**
 * Copyright (C) 2006-2011 Takanori Amano, Amax Inc., and Connectone Co.,Ltd.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.co.connectone.test;

import java.util.Date;

import com.microsoft.schemas.exchange.services._2006.types.*;

import jp.co.connectone.eai.exchews.ews.*;
import jp.co.connectone.exception.HandleException;
import jp.co.connectone.store.*;
import junit.framework.TestCase;

public class TestEWSSearchCondition extends TestCase
{
	protected EWSSearchCondition cond;
	
	
	public SearchConditionCollection getDateSearchCondition(Date date) throws HandleException
	{
		EWS_AND_SearchConditionCollection c = new EWS_AND_SearchConditionCollection();
		EWSSearchCondition cond = new EWSSearchCondition(UnindexedFieldURIType.CALENDAR_START, EWSSearchType.TYPE_DATE_0000, date, EWSSearchOperator.OP_EQUALS);
		c.add(cond);
		cond = new EWSSearchCondition(UnindexedFieldURIType.CALENDAR_START, EWSSearchType.TYPE_DATE_2359, date, EWSSearchOperator.OP_EQUALS);
		c.add(cond);
		
		return c;
	}
	
	public void testSample1() throws Exception
	{
		EWS_AND_SearchConditionCollection c = (EWS_AND_SearchConditionCollection)getDateSearchCondition(new Date());
		for (ISearchConditionElement ic : c) {
			if (ic instanceof ISearchCondition) {
				EWSSearchCondition cond = (EWSSearchCondition)ic;
				assertNotNull(cond);
				EWSSearchType type = cond.getType();
				assertNotNull(type);
			}
		}
		AndType at = (AndType) c.generateSearchExpression();
		assertNotNull(at);
		
	}

}
