/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#include "../ControlParam.hh"
#include "OutputInfo.hh"

static vector<bool(*)(const LatticeFigureOfMeritToCheckSymmetry&, const LatticeFigureOfMeritToCheckSymmetry&)> putCmpFunctions()
{
	vector<bool(*)(const LatticeFigureOfMeritToCheckSymmetry&, const LatticeFigureOfMeritToCheckSymmetry&)> ans;
	ans.push_back( LatticeFigureOfMeritToCheckSymmetry::cmpFOMdeWolff );
	ans.push_back( LatticeFigureOfMeritToCheckSymmetry::cmpFOMWu );
//	ans.push_back( LatticeFigureOfMeritToCheckSymmetry::cmpFOM );
	ans.push_back( LatticeFigureOfMeritToCheckSymmetry::cmpFOMReversed );
	ans.push_back( LatticeFigureOfMeritToCheckSymmetry::cmpFOMSymmetric );
	ans.push_back( LatticeFigureOfMeritToCheckSymmetry::cmpNumberOfNeighbors );

//	ans.push_back( LatticeFigureOfMeritToCheckSymmetry::cmpFOMdeWolff_Original );
//	ans.push_back( LatticeFigureOfMeritToCheckSymmetry::cmpFOMWu_Original );

	assert((ArrayIndex)ans.size() == putNumberOfSortCriterion());
	return ans;
}

const vector<bool(*)(const LatticeFigureOfMeritToCheckSymmetry&, const LatticeFigureOfMeritToCheckSymmetry&)> OutputInfo::CmpFunc = putCmpFunctions();

OutputInfo::OutputInfo()
{  
	candidate_num = 0;
	selected_candidate_label_all.resize(putNumberOfSortCriterion(), -1);
	selected_candidate_label_list.resize(putNumberOfSortCriterion(), -1);
};

void OutputInfo::setLabel(
		const vector<LatticeFigureOfMeritToCheckSymmetry>& lattice_result,
		const ControlParam& cData)
{
	this->lattice_index.clear();
	this->candidate_num = 0;

	const ArrayIndex lsize = lattice_result.size();
	const ArrayIndex SortCriterionNum = putNumberOfSortCriterion();

	vector<ArrayIndex> selected_candidate_index_all(SortCriterionNum, -1);
	vector<ArrayIndex> selected_candidate_index_list(SortCriterionNum, -1);
	VecDat3<Double> length_axis, angle_axis;

	for(ArrayIndex l=0; l<lsize; l++)
	{
		bool& output_flag = lattice_index.insert(pair<lattice_label, pair<ArrayIndex, bool> >(lattice_result[l].putLatticeLabel(), pair<ArrayIndex, bool>(l, false))).first->second.second;

		const LatticeFigureOfMerit& latfom = lattice_result[l].putLatticeFigureOfMerit();

		if( !cData.putOutputSymmetry( latfom.enumCrystalSystem() ) ) continue;
		if( latfom.putFiguresOfMerit().putContinuousNumberOfHKLInRange() > Double( cData.putMaxNumPeakInRange() ) ) continue;
		if( latfom.putFiguresOfMerit().putContinuousNumberOfHKLInRange() < Double( cData.putMinNumPeakInRange() ) ) continue;
		const Double& minABC = cData.putMinUnitCellEdgeABC();
		const Double& maxABC = cData.putMaxUnitCellEdgeABC();
		latfom.putReducedLatticeConstantsDegree(cData.putBaseCenteredAxis(), cData.putRhombohedralAxis(), length_axis, angle_axis);
		if( length_axis[0] < minABC || length_axis[1] < minABC || length_axis[2] < minABC ) continue;
		if( length_axis[0] > maxABC || length_axis[1] > maxABC || length_axis[2] > maxABC ) continue;

		if( latfom.putFiguresOfMerit().putFigureOfMeritWolff() < cData.putMinFOM() ) continue;

		for(ArrayIndex i=0; i<SortCriterionNum; i++)
		{
			if( selected_candidate_index_all[i] < 0
				|| OutputInfo::CmpFunc[i]( lattice_result[l], lattice_result[selected_candidate_index_all[i]] ) )
			{
				selected_candidate_index_all[i] = l;
			}
		}

		if( lattice_result[l].putNumberOfLatticesInNeighborhood() < 0 ) continue;

		output_flag = true;
		this->candidate_num++;

		for(ArrayIndex i=0; i<SortCriterionNum; i++)
		{
			if( selected_candidate_index_list[i] < 0
				|| OutputInfo::CmpFunc[i]( lattice_result[l], lattice_result[selected_candidate_index_list[i]] ) )
			{
				selected_candidate_index_list[i] = l;
			}
		}
	}

	for(ArrayIndex i=0; i<SortCriterionNum; i++)
	{
		if( selected_candidate_index_all[i] < 0 )
		{
			this->selected_candidate_label_all[i] = -1;
		}
		else
		{
			this->selected_candidate_label_all[i] = lattice_result[selected_candidate_index_all[i]].putLatticeLabel();
		}
		if( selected_candidate_index_list[i] < 0 )
		{
			this->selected_candidate_label_list[i] = -1;
		}
		else
		{
			this->selected_candidate_label_list[i] = lattice_result[selected_candidate_index_list[i]].putLatticeLabel();
		}
	}

	if( selected_candidate_index_all[(ArrayIndex)SCNN] >= 0
		&& lattice_result[selected_candidate_index_all[(ArrayIndex)SCNN]].putNumberOfLatticesInNeighborhood() < 1 )
	{
		this->selected_candidate_label_all[(ArrayIndex)SCNN] = -1;
	}
	if( selected_candidate_index_list[(ArrayIndex)SCNN] >= 0
			&& lattice_result[selected_candidate_index_list[(ArrayIndex)SCNN]].putNumberOfLatticesInNeighborhood() < 1 )
	{
		this->selected_candidate_label_list[(ArrayIndex)SCNN] = -1;
	}
}


pair<eCrystalSystem, lattice_label> put_selected_lattice_from_all(
			const vector<LatticeFigureOfMeritToCheckSymmetry> lattice_result[],
			const OutputInfo outinfo[], 
			const eSortCriterion& sort_criterion)
{
	bool (*cmp_func)(const LatticeFigureOfMeritToCheckSymmetry&, const LatticeFigureOfMeritToCheckSymmetry&) = OutputInfo::CmpFunc[(ArrayIndex)sort_criterion];

	pair<eCrystalSystem, lattice_label> ans;
	ans.first = Triclinic;
	ans.second = -1;
	const LatticeFigureOfMeritToCheckSymmetry* ans_lattice = NULL;
	
	static const ArrayIndex NUM_LS = put_cs_num();
	for(ArrayIndex i=0; i<NUM_LS; i++)
	{
		const ArrayIndex index = outinfo[i].putIndex( outinfo[i].putLatticeLabelSelectedAmongAll(sort_criterion) );
		if( index >= 0 ) 
		{
			if( ans.second < 0 || cmp_func( lattice_result[i][index], *ans_lattice ) )
			{
				ans.first = eCrystalSystem(i);
				ans.second = lattice_result[i][index].putLatticeLabel();
				ans_lattice = &lattice_result[i][index];
			}
		}
	}
	return ans;
}
