/*
 * The MIT License

   BLDConograph (Bravais lattice determination module in Conograph)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#ifndef MATRIX_3BY3_HH_
#define MATRIX_3BY3_HH_

#include "../utility_data_structure/nrutil_nr.hh"

template<class Integer>
inline Integer put_complement_set3(const Integer& i, const Integer& j)
{
	assert( i != j );
	assert( 0 <= i && i < 3 );
	assert( 0 <= j && j < 3 );
	bool flag[3] = {false,false,false};
	flag[i] = true;
	flag[j] = true;
	if( !flag[0] ) return 0;
	else if( !flag[1] ) return 1;
	else return 2;
}


inline void put_complement_set3(const Int4& i, Int4& k, Int4& l)
{
	if( i == 0 )
	{
		k = 1;
		l = 2;
	}
	else if( i == 1 )
	{
		k = 0;
		l = 2;
	}
	else // if( i == 2 )
	{
		k = 0;
		l = 1;
	}
}


static NRMat<Int4> put_sign_mat3(const Int4& i1)
{
	NRMat<Int4> ans(3,3,0);
	ans[0][0] = 1;
	ans[1][1] = 1;
	ans[2][2] = 1;
	ans[i1][i1] = -1;
	return ans;
}


inline const NRMat<Int4>& put_sign_matrix3(const Int4& axis)
{
	static const NRMat<Int4> mat_tray[3] = { put_sign_mat3(0), put_sign_mat3(1), put_sign_mat3(2) };
	return mat_tray[axis];
}


//             -1  0  1
// Returns T =  0  1 -1
//             -1 -1 -1
static NRMat<Int4> put_perm_mat3(const Int4& i1, const Int4& i2, const Int4& i3)
{
	NRMat<Int4> ans(3,3,0);
	ans[0][i1] = 1;
	ans[1][i2] = 1;
	ans[2][i3] = 1;
	return ans;
}


inline const NRMat<Int4>& put_matrix_XYZ()
{
	static const NRMat<Int4> ans = put_perm_mat3(0,1,2);
	return ans;
}

inline const NRMat<Int4>& put_matrix_XZY()
{
	static const NRMat<Int4> ans = put_perm_mat3(0,2,1);
	return ans;
}

inline const NRMat<Int4>& put_matrix_YXZ()
{
	static const NRMat<Int4> ans = put_perm_mat3(1,0,2);
	return ans;
}

inline const NRMat<Int4>& put_matrix_YZX()
{
	static const NRMat<Int4> ans = put_perm_mat3(1,2,0);
	return ans;
}

inline const NRMat<Int4>& put_matrix_ZXY()
{
	static const NRMat<Int4> ans = put_perm_mat3(2,0,1);
	return ans;
}

inline const NRMat<Int4>& put_matrix_ZYX()
{
	static const NRMat<Int4> ans = put_perm_mat3(2,1,0);
	return ans;
}

inline NRMat<Int4> put_matrix33(const Int4& a00, const Int4& a01, const Int4& a02,
					            const Int4& a10, const Int4& a11, const Int4& a12,
					            const Int4& a20, const Int4& a21, const Int4& a22)
{
	NRMat<Int4> ans(3,3);
	ans[0][0] = a00;
	ans[0][1] = a01;
	ans[0][2] = a02;
	ans[1][0] = a10;
	ans[1][1] = a11;
	ans[1][2] = a12;
	ans[2][0] = a20;
	ans[2][1] = a21;
	ans[2][2] = a22;
	return ans;
}


inline NRMat<Int4> put_matrix43(const Int4& a00, const Int4& a01, const Int4& a02,
					            const Int4& a10, const Int4& a11, const Int4& a12,
					            const Int4& a20, const Int4& a21, const Int4& a22,
					            const Int4& a30, const Int4& a31, const Int4& a32)
{
	NRMat<Int4> ans(4,3);
	ans[0][0] = a00;
	ans[0][1] = a01;
	ans[0][2] = a02;
	ans[1][0] = a10;
	ans[1][1] = a11;
	ans[1][2] = a12;
	ans[2][0] = a20;
	ans[2][1] = a21;
	ans[2][2] = a22;
	ans[3][0] = a30;
	ans[3][1] = a31;
	ans[3][2] = a32;
	return ans;
}

#endif /*ENUMCRYSTALSYSTEM_HH_*/
