/*
 * Created on 2005/06/02
 *
 */
package jp.co.areaweb.tools.core;

import junit.framework.TestCase;

/**
 * @author y_hayashi
 *
 * longData数値を、ketaで指定された文字数の文字列に変換する。
 * 数値が指定の桁に満たない場合は、０が埋め込まれます．
 * 数値が指定の桁数を超えている場合には、例外を発生させます．
 * 基数は１０です。
 * @param longData
 * @param keta
 * @return
 */
public class TestMakeString extends TestCase {

	/**
	 * テスト１
	 * longData数値を、ketaで指定された文字数の文字列に変換する。
	 */
	public void test001() throws Exception {
		assertEquals(MakeString.valueOf(0L, 3), "000");
		assertEquals(MakeString.valueOf(123L, 3), "123");
		assertEquals(MakeString.valueOf(1230L, 4), "1230");
		assertEquals(MakeString.valueOf(0, 3), "000");
		assertEquals(MakeString.valueOf(123, 3), "123");
		assertEquals(MakeString.valueOf(1230, 4), "1230");
	}
	
	/**
	 * テスト2
	 * 数値が指定の桁に満たない場合は、０が埋め込まれます．
	 */
	public void test002() throws Exception {
		assertEquals(MakeString.valueOf(123L, 8), "00000123");
		assertEquals(MakeString.valueOf(1230L, 8), "00001230");
		assertEquals(MakeString.valueOf(123, 8), "00000123");
		assertEquals(MakeString.valueOf(1230, 8), "00001230");
	}

	/**
	 * テスト3
	 * 数値が指定の桁数を超えている場合には、例外を発生させます．
	 */
	public void test003() throws Exception {
		try {
			MakeString.valueOf(123L, 2);
			fail();		// 例外が発生しなければエラー
		}
		catch (Exception e) {
			// 成功
			assertEquals(true, true);
		}
		
		try {
			MakeString.valueOf(-1234L, 4);
			fail();		// 例外が発生しなければエラー
		}
		catch (Exception e) {
			// 成功
			assertEquals(true, true);
		}
	}

	/**
	 * テスト4
	 * 数値が負の場合
	 */
	public void test004() throws Exception {
		assertEquals("-0000123", MakeString.valueOf(-123, 8));
		assertEquals("-0001230", MakeString.valueOf(-1230L, 8));
		assertEquals("-1234", MakeString.valueOf(-1234L, 5));
	}
}
