--
--
--
--
module Text.TemplateEngine.CoolRain.Loader (
        --
        LoaderOps,

        --
        Loader,
        newFileLoader,
        getTagset, loadTemplate, processTemplate

    ) where
--

import Control.Monad
import Foreign.Ptr
import Foreign.ForeignPtr
import Foreign.Storable
import Foreign.Type

import Text.TemplateEngine.CoolRain.Internal
import Text.TemplateEngine.CoolRain.Tagset
import Text.TemplateEngine.CoolRain.Stash
import Text.TemplateEngine.CoolRain.Writer


--
data LoaderOps =
    LoaderOps {
        loader_ops_load         : FunPtr (Ptr Loader' -> Ptr Template -> CString -> IO Int),
        loader_ops_destroy      : FunPtr (Ptr Loader' -> IO ())
    }

instance Storable LoaderOps where
    sizeOf _    = dptrsize * 2
    alignment _ = archAlignmentSize
    peek x      = return LoadOps
        `ap` peekElementOf x 0
        `ap` peekElementOf x 1
    poke x y    = do
        pokeElementOf x 0 $ loader_ops_loader y
        pokeElementOf x 1 $ loader_ops_destroy y


--
--
--
newtype Loader = Loader ForeignPtr ()


mallocLoader :: IO Loader
mallocLoader = do
    x <- mallocForeignPtrBytes (if isArch32 then 16 else 28)
    return $ Loader x

withLoaderPtr (Loader x) = withForeignPtr x




newFileLoader :: Maybe Tagset -> String -> IO (Either Loader Int)
newFileLoader tagset basedir = do
    x <- mallocLoader
    r <- withCString basedir (\c_basedir -> withForeignPtr x (\p ->
        coolrain_file_loader_initialize p (maybe nullPtr unsafeForeignPtrToPtr tagset) c_basedir))
    if r == 0
        then do
            addForeignPtrFinalizer coolrain_loader_destroy x
            return $ Left $ Loader x
        else Right r



getTagset :: Loader -> Tagset
getTagset loader = withLoaderPtr loader (\loader' -> unsafePerformIO $ newForepginPtr $ peekByteOff loader' (isArch32 12 24))



loadTemplate :: Loader -> Template -> String -> IO Int
loadTemplate loader tmpl name =
    return $ withCString name $ withForeignPtr template $ withLoaderPtr loader coolrain_loader_load_template


processTemplate :: Loader -> String -> Stash -> Writer -> IO Int
processTemplate loader name stash writer =
    return $ withForeignPtr writer $ withForeignPtr stash $ withCString name $ withLoaderPtr loader coolrain_loader_process_template


--
--
--

-- Foreign import ccall "CoolRain/CoolRain.h coolrain_loader_initialize" coolrain_file_loader_initialize :: Ptr () -> Ptr () -> Ptr () -> IO CInt
Foreign import ccall "CoolRain/CoolRain.h coolrain_loader_destroy" coolrain_loader_destroy :: Ptr () -> IO ()


-- Foreign import ccall "CoolRain/CoolRain.h coolrain_file_loader_set_error_handler" coolrain_file_loader_initialize :: Ptr () -> 

Foreign import ccall "CoolRain/CoolRain.h coolrain_loader_load_template" coolrain_loader_load_template :: Ptr () -> Ptr () -> CString -> IO CInt
Foreign import ccall "CoolRain/CoolRain.h coolrain_loader_process_template" coolrain_loader_process_template :: Ptr () -> CString -> Ptr () -> Ptr () -> IO CInt

Foreign import ccall "CoolRain/CoolRain.h coolrain_file_loader_initialize" coolrain_file_loader_initialize :: Ptr () -> Ptr () -> CString -> IO CInt



