/**
 *
 *
 */
#if !defined(COOLRAIN__VARIANT__H__)
#define COOLRAIN__VARIANT__H__

#include <glib/gmacros.h>
#include <CoolRain/refstring.h>
#include <CoolRain/memory.h>

G_BEGIN_DECLS;

struct coolrain_writer;


#define COOLRAIN_VARIANT_TYPE_NULL		(0)
#define COOLRAIN_VARIANT_TYPE_INT		(1)
#define COOLRAIN_VARIANT_TYPE_DOUBLE		(2)
#define COOLRAIN_VARIANT_TYPE_REFSTRING		(3)
#define COOLRAIN_VARIANT_TYPE_STATIC_STRING	(4)
#define COOLRAIN_VARIANT_TYPE_DYNAMIC_STRING	(5)
#define COOLRAIN_VARIANT_TYPE_POINTER		(6)
#define COOLRAIN_VARIANT_TYPE_STATIC_CONTEXT	(7)
#define COOLRAIN_VARIANT_TYPE_DYNAMIC_CONTEXT	(8)



typedef struct {
	int	type;
	union {
		int		v_int;
		double		v_double;
		coolrain_refstring_t v_refstring;
		char const	*v_static_string;
		char		*v_dynamic_string;
		struct {
			void	*p;
			void (*destroy_handler)(void *data);
		} v_pointer;
		struct coolrain_eval_context *v_cntx;
	} data;
} coolrain_variant_t;


#define COOLRAIN_VARIANT_INITIALIZER	{ COOLRAIN_VARIANT_TYPE_NULL, { 0 } }

static inline void coolrain_variant_initialize(coolrain_variant_t *v)
{
	v->type = COOLRAIN_VARIANT_TYPE_NULL;
}


void coolrain_variant_unset(coolrain_variant_t *v);


static inline void coolrain_variant_destroy(coolrain_variant_t *v)
{
	coolrain_variant_unset(v);
}






static inline int  coolrain_variant_get_int(coolrain_variant_t const *v)
{
	return (v->type == COOLRAIN_VARIANT_TYPE_INT)? v->data.v_int : 0;
}


static inline void coolrain_variant_set_int(coolrain_variant_t *v, int new_value)
{
	coolrain_variant_unset(v);
	v->type = COOLRAIN_VARIANT_TYPE_INT;
	v->data.v_int = new_value;
}





static inline double coolrain_variant_get_double(coolrain_variant_t const *v)
{
	return (v->type == COOLRAIN_VARIANT_TYPE_DOUBLE)? v->data.v_double : 0.0;
}


static inline void coolrain_variant_set_double(coolrain_variant_t *v, double new_value)
{
	coolrain_variant_unset(v);
	v->type = COOLRAIN_VARIANT_TYPE_DOUBLE;
	v->data.v_double = new_value;
}





static inline coolrain_refstring_t const *coolrain_variant_get_refstring(coolrain_variant_t const *v)
{
	return (v->type == COOLRAIN_VARIANT_TYPE_REFSTRING)? &v->data.v_refstring : NULL;
}

void coolrain_variant_set_refstring(coolrain_variant_t *v, coolrain_refstring_t const *new_value);
void coolrain_variant_set_refstring_dup(coolrain_variant_t *v, coolrain_refstring_t const *new_value);




char const *coolrain_variant_get_string(coolrain_variant_t const *v);
static inline void coolrain_variant_set_static_string(coolrain_variant_t *v, char const *new_value)
{
	coolrain_variant_unset(v);
	v->type = COOLRAIN_VARIANT_TYPE_STATIC_STRING;
	v->data.v_static_string = new_value;
}


static inline void coolrain_variant_set_dynamic_string(coolrain_variant_t *v, char *new_value)
{
	coolrain_variant_unset(v);
	v->type = COOLRAIN_VARIANT_TYPE_DYNAMIC_STRING;
	v->data.v_dynamic_string = coolrain_strdup(new_value);
}



static inline void *coolrain_variant_get_pointer(coolrain_variant_t *v)
{
	return (v->type == COOLRAIN_VARIANT_TYPE_POINTER)? v->data.v_pointer.p : NULL;
}


static inline void coolrain_variant_set_pointer(coolrain_variant_t *v, void *new_value, void (*destroy_handler)(void *))
{
	coolrain_variant_unset(v);
	v->type = COOLRAIN_VARIANT_TYPE_POINTER;
	v->data.v_pointer.p = new_value;
	v->data.v_pointer.destroy_handler = destroy_handler;
}



void coolrain_variant_set_static_context(coolrain_variant_t *v, struct coolrain_eval_context *cntx);
void coolrain_variant_set_dynamic_context(coolrain_variant_t *v, struct coolrain_eval_context const *cntx);



/* */
void coolrain_variant_copy(coolrain_variant_t *dst, coolrain_variant_t const *src);


/* */
int coolrain_variant_write(coolrain_variant_t const *v, struct coolrain_writer *writer);

G_END_DECLS;

#endif

