package jp.cssj.cti2;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import jp.cssj.plugin.PluginLoader;

/**
 * ドライバの窓口クラスです。
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: CTIDriverManager.java 457 2010-05-20 02:26:26Z miyabe $
 */
public class CTIDriverManager {
	private CTIDriverManager() {
		// hidden
	}

	/**
	 * 指定されたURIへ接続するためのドライバを返します。
	 * 
	 * @see CTIDriver#getSession(URI, Map)
	 * @param uri
	 *            接続先URI。
	 * @return ドライバ。
	 */
	public static CTIDriver getDriver(URI uri) {
		CTIDriver driver = (CTIDriver) PluginLoader.getPluginLoader().search(
				CTIDriver.class, uri);
		if (driver == null) {
			throw new RuntimeException(uri + " に接続するドライバがありません。");
		}
		return driver;
	}

	/**
	 * セッションを返します。
	 * <p>
	 * これは<tt>CTIDriver.getDriver(uri).getSession(null)</tt>の簡易メソッドです。
	 * </p>
	 * 
	 * @see CTIDriver#getSession(URI, Map)
	 * @param uri
	 *            接続先URI。
	 * @return セッション。
	 * @throws IOException
	 */
	public static CTISession getSession(URI uri) throws IOException {
		return getSession(uri, null);
	}

	/**
	 * セッションを返します。
	 * <p>
	 * これは<tt>CTIDriver.getDriver(uri).getSession(props)</tt>の簡易メソッドです。
	 * </p>
	 * 
	 * @see CTIDriver#getSession(URI, Map)
	 * @param uri
	 *            接続先URI。
	 * @return セッション。
	 * @throws IOException
	 */
	public static CTISession getSession(URI uri, Map props) throws IOException {
		CTIDriver driver = getDriver(uri);
		return driver.getSession(uri, props);
	}

	/**
	 * セッションを返します。
	 * <p>
	 * これは<tt>CTIDriver.getDriver(uri).getSession(props)</tt>の簡易メソッドです。
	 * プロパティにユーザー、パスワードを設定します。
	 * </p>
	 * 
	 * @see CTIDriver#getSession(URI, Map)
	 * @param uri
	 *            接続先URI。
	 * @return セッション。
	 * @throws IOException
	 */
	public static CTISession getSession(URI uri, String user, String password)
			throws IOException {
		CTIDriver driver = getDriver(uri);
		Map props = null;
		if (user != null || password != null) {
			props = new HashMap();
			props.put("user", user);
			props.put("password", password);
		}
		return driver.getSession(uri, props);
	}
}