package jp.cssj.cti2.helpers;

import java.io.IOException;

import javax.servlet.ServletResponse;

import jp.cssj.cti2.CTISession;
import jp.cssj.resolver.MetaSource;

/**
 * サーブレットからドキュメント変換サーバーを利用する際のユーティリティです。
 * 
 * @author <a href="miyabe at gnn.co.jp">MIYABE Tatsuhiko</a>
 * @version $Id: ServletHelper.java 457 2010-05-20 02:26:26Z miyabe $
 */
public final class ServletHelper {
	private ServletHelper() {
		// unused
	}

	/**
	 * セッションの出力先にServletResponseを設定します。
	 * 
	 * @param session
	 *            出力先を設定するセッション。
	 * @param response
	 *            結果の出力際のレスポンス。
	 * @throws IOException
	 */
	public static void setServletResponse(final CTISession session,
			final ServletResponse response) throws IOException {
		session.setResults(new ServletResponseResults(response));
	}

	/**
	 * charsetパラメータつきのContent-Typeヘッダ値を返します。
	 * 
	 * @param metaSource
	 *            データのメタ情報。
	 * @return charsetパラメータつきのContent-Typeヘッダ。
	 */
	public static String getContentType(MetaSource metaSource) {
		String mimeType;
		try {
			mimeType = metaSource.getMimeType();
			if (mimeType == null) {
				return null;
			}
			String encoding = metaSource.getEncoding();
			if (encoding != null) {
				mimeType += "; charset=" + encoding;
			}
		} catch (Exception e) {
			return null;
		}
		return mimeType;
	}
}
