package jp.cssj.server.socket.ctip.helpers;

import java.io.IOException;

import jp.cssj.rsr.RandomBuilder;

/**
 * サーバーからクライアントへデータを送るためのインターフェースです。
 * 
 * 断片化されたデータの受信に加えて、進行状況を把握し、エラーメッセージを受け取ります。
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: ResponseConsumer.java 457 2010-05-20 02:26:26Z miyabe $
 */
public interface ResponseConsumer extends RandomBuilder {
	/**
	 * メッセージを送信します。
	 * 
	 * @param code
	 * @param args
	 * @param message
	 * @throws IOEXception
	 */
	public void message(short code, String[] args, String message)
			throws IOException;
}