package jp.cssj.cr.gc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jp.cssj.cr.compat.XLine;
import jp.cssj.cr.compat.XMatrix;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.font.FontManager;
import jp.cssj.sakae.gc.image.Image;
import jp.cssj.sakae.gc.text.Text;
import android.graphics.Path;
import android.graphics.RectF;

/**
 * @author <a href="mailto:tatsuhiko at miya.be">MIYABE Tatsuhiko </a>
 * @version $Id: AbstractG2D_GC.java,v 1.2 2007-05-06 04:27:03 miyabe Exp $
 */

enum Command {
	BEGIN, END, LINE_WIDTH, LINE_PATTERN, LINE_CAP, LINE_JOIN, TEXT_MODE, COMPOSITE, STROKE_PAINT, FILL_PAINT, TRANSFORM, CLIP_PATH, CLIP_RECT, RESET_STATE, DRAW_IMAGE, FILL_PATH, FILL_RECT, FILL_OVAL, DRAW_PATH, DRAW_RECT, DRAW_OVAL, DRAW_LINE, FILL_DRAW_PATH, FILL_DRAW_RECT, FILL_DRAW_OVAL, DRAW_TEXT
}

public class RecorderGC implements GC, Serializable {
	private static final long serialVersionUID = 0L;

	private List<Object> list = new ArrayList<Object>();
	public final double width, height;
	private final FontManager fm;

	public RecorderGC(final double width, final double height,
			final FontManager fm) {
		this.width = width;
		this.height = height;
		this.fm = fm;
	}

	public FontManager getFontManager() {
		return this.fm;
	}

	public void begin() {
		this.list.add(Command.BEGIN);
	}

	public void end() {
		this.list.add(Command.END);
	}

	public void setLineWidth(double width) {
		this.list.add(Command.LINE_WIDTH);
		this.list.add(Double.valueOf(width));
	}

	public void setLinePattern(double[] pattern) {
		this.list.add(Command.LINE_PATTERN);
		this.list.add(pattern);
	}

	public void setLineCap(short style) {
		this.list.add(Command.LINE_CAP);
		this.list.add(Short.valueOf(style));
	}

	public void setLineJoin(short style) {
		this.list.add(Command.LINE_JOIN);
		this.list.add(Short.valueOf(style));
	}

	public void setTextMode(short textMode) throws GraphicsException {
		this.list.add(Command.TEXT_MODE);
		this.list.add(Short.valueOf(textMode));
	}

	public void setComposite(Object composite) {
		this.list.add(Command.COMPOSITE);
		this.list.add(composite);
	}

	public void setStrokePaint(Object paint) throws GraphicsException {
		this.list.add(Command.STROKE_PAINT);
		this.list.add(paint);
	}

	public void setFillPaint(Object paint) throws GraphicsException {
		this.list.add(Command.FILL_PAINT);
		this.list.add(paint);
	}

	public void transform(XMatrix at) {
		this.list.add(Command.TRANSFORM);
		this.list.add(at);
	}

	public XMatrix getTransform() {
		return null;
	}

	public void clip(Path shape) {
		this.list.add(Command.CLIP_PATH);
		this.list.add(shape);
	}

	public void clip(RectF r) {
		this.list.add(Command.CLIP_RECT);
		this.list.add(r);
	}

	public void resetState() {
		this.list.add(Command.RESET_STATE);
	}

	public void drawImage(Image image) throws GraphicsException {
		this.list.add(Command.DRAW_IMAGE);
		this.list.add(image);
	}

	public void fill(Path shape) {
		this.list.add(Command.FILL_PATH);
		this.list.add(shape);
	}

	public void fill(RectF shape) {
		this.list.add(Command.FILL_RECT);
		this.list.add(shape);
	}

	public void fillOval(RectF shape) {
		this.list.add(Command.FILL_OVAL);
		this.list.add(shape);
	}

	public void draw(Path shape) {
		this.list.add(Command.DRAW_PATH);
		this.list.add(shape);
	}

	public void draw(RectF shape) {
		this.list.add(Command.DRAW_RECT);
		this.list.add(shape);
	}

	public void drawOval(RectF shape) {
		this.list.add(Command.DRAW_OVAL);
		this.list.add(shape);
	}

	public void draw(XLine line) {
		this.list.add(Command.DRAW_LINE);
		this.list.add(line);
	}

	public void fillDraw(Path shape) {
		this.list.add(Command.FILL_DRAW_PATH);
		this.list.add(shape);
	}

	public void fillDraw(RectF shape) {
		this.list.add(Command.FILL_DRAW_RECT);
		this.list.add(shape);
	}

	public void fillDrawOval(RectF shape) {
		this.list.add(Command.FILL_DRAW_OVAL);
		this.list.add(shape);
	}

	public void drawText(Text text, double x, double y)
			throws GraphicsException {
		this.list.add(Command.DRAW_TEXT);
		this.list.add(text);
		this.list.add(Double.valueOf(x));
		this.list.add(Double.valueOf(y));
	}

	public void flush(GC gc) {
		for (int i = 0; i < this.list.size(); ++i) {
			Command e = (Command) this.list.get(i);
			switch (e) {
			case BEGIN:
				gc.begin();
				break;
			case END:
				gc.end();
				break;
			case LINE_WIDTH: {
				Double width = (Double) this.list.get(++i);
				gc.setLineWidth(width);
			}
				break;
			case LINE_PATTERN: {
				double[] pattern = (double[]) this.list.get(++i);
				gc.setLinePattern(pattern);
			}
				break;
			case LINE_CAP: {
				Short style = (Short) this.list.get(++i);
				gc.setLineCap(style.shortValue());
			}
				break;
			case LINE_JOIN: {
				Short style = (Short) this.list.get(++i);
				gc.setLineJoin(style.shortValue());
			}
				break;
			case TEXT_MODE: {
				Short textMode = (Short) this.list.get(++i);
				gc.setLineJoin(textMode.shortValue());
			}
				break;
			case COMPOSITE: {
				Object composite = this.list.get(++i);
				gc.setComposite(composite);
			}
				break;
			case STROKE_PAINT: {
				Object paint = this.list.get(++i);
				gc.setStrokePaint(paint);
			}
				break;
			case FILL_PAINT: {
				Object paint = this.list.get(++i);
				gc.setFillPaint(paint);
			}
				break;
			case TRANSFORM: {
				XMatrix matrix = (XMatrix) this.list.get(++i);
				gc.transform(matrix);
			}
				break;
			case CLIP_PATH: {
				Path shape = (Path) this.list.get(++i);
				gc.clip(shape);
			}
				break;
			case CLIP_RECT: {
				RectF shape = (RectF) this.list.get(++i);
				gc.clip(shape);
			}
				break;
			case RESET_STATE:
				gc.resetState();
				break;
			case DRAW_IMAGE: {
				Image image = (Image) this.list.get(++i);
				gc.drawImage(image);
			}
				break;
			case FILL_PATH: {
				Path shape = (Path) this.list.get(++i);
				gc.fill(shape);
			}
				break;
			case FILL_RECT: {
				RectF shape = (RectF) this.list.get(++i);
				gc.fill(shape);
			}
				break;
			case FILL_OVAL: {
				RectF shape = (RectF) this.list.get(++i);
				gc.fillOval(shape);
			}
				break;
			case DRAW_PATH: {
				Path shape = (Path) this.list.get(++i);
				gc.draw(shape);
			}
				break;
			case DRAW_RECT: {
				RectF shape = (RectF) this.list.get(++i);
				gc.draw(shape);
			}
				break;
			case DRAW_OVAL: {
				RectF shape = (RectF) this.list.get(++i);
				gc.drawOval(shape);
			}
				break;
			case DRAW_LINE: {
				XLine shape = (XLine) this.list.get(++i);
				gc.draw(shape);
			}
				break;
			case FILL_DRAW_PATH: {
				Path shape = (Path) this.list.get(++i);
				gc.fillDraw(shape);
			}
				break;
			case FILL_DRAW_RECT: {
				RectF shape = (RectF) this.list.get(++i);
				gc.fillDraw(shape);
			}
				break;
			case FILL_DRAW_OVAL: {
				RectF shape = (RectF) this.list.get(++i);
				gc.fillDrawOval(shape);
			}
				break;
			case DRAW_TEXT: {
				Text text = (Text) this.list.get(++i);
				Double x = (Double) this.list.get(++i);
				Double y = (Double) this.list.get(++i);
				gc.drawText(text, x.doubleValue(), y.doubleValue());
			}
				break;
			default:
				throw new IllegalStateException(String.valueOf(e));
			}
		}
	}
}