package jp.cssj.cr.epub;

import jp.cssj.android.R;
import jp.cssj.print.epub.EPubFile;
import jp.cssj.print.epub.Toc;
import jp.cssj.print.epub.Toc.NavPoint;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class TocAdapter extends ArrayAdapter<NavPoint> {
	private final EPubFile epub;
	private final Toc toc;

	public TocAdapter(Context context, int textViewResourceId, EPubFile epub,
			Toc toc) {
		super(context, textViewResourceId, toc.navPoints);
		this.epub = epub;
		this.toc = toc;
	}

	public View getView(int position, View view, ViewGroup parent) {
		LayoutInflater inflater = (LayoutInflater) this.getContext()
				.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		try {
			if (view == null) {
				view = inflater.inflate(R.layout.spine_item, null);
			}
			NavPoint navPoint = this.toc.navPoints[position];
			String title;
			if (navPoint.label != null && navPoint.label.length() > 0) {
				title = navPoint.label;
			} else {
				title = this.epub.readTitle(navPoint.item);
				if (title == null) {
					title = "";
				}
			}
			TextView titleView = (TextView) view.findViewById(R.id.spineTitle);
			titleView.setText(title);
		} catch (Exception e) {
			Log.e(this.getClass().getName(), "EPUB error.", e);
		}

		return view;
	}
}
