/*$Id$*/
package nicobrowser.main;

import nicobrowser.update.DBUpdater;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.Query;
import nicobrowser.Config;
import nicobrowser.GetFlvResult;
import nicobrowser.Config.NicoFeed;
import nicobrowser.NicoHttpClient;
import nicobrowser.entity.NicoContent;
import nicobrowser.entity.NicoContent.Status;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Main {

    private static Log log = LogFactory.getLog(Main.class);

    public static void main(String[] args) throws IOException {
        boolean res = Config.createNewConfigFiles();
        if (res) {
            System.out.println("コンフィグファイルを作成しました. 編集後, 再実行してください.");
            return;
        }

        DBUpdater updater = new DBUpdater();
        if (args.length > 0 && "sync".equals(args[0])) {
            updater.sync();
            return;
        }
        updater.update();

        new Main().start();
    }

    public void start() {
        log.info("program start");

        Config config = Config.getInstance();
        List<NicoContent> dailyList = new ArrayList<NicoContent>();
        ArrayList<List<NicoContent>> myLists = new ArrayList<List<NicoContent>>();
        NicoHttpClient instance = null;
        try {
            log.info("リストを取得します");
            instance = NicoHttpClient.getInstance();
            List<NicoFeed> feeds = config.getNicoFeeds();
            for (NicoFeed f : feeds) {
                List<NicoContent> list = instance.getContentsFromRss(f.getUrl());
                int count = 0;
                for (NicoContent l : list) {
                    if (count >= f.getNumber()) {
                        break;
                    }
                    dailyList.add(l);
                    count++;
                }
            }
            List<String> mylists = config.getDownLoadMyList();
            for (String l : mylists) {
                List<NicoContent> list = instance.loadMyList(l);
                myLists.add(list);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return;
        }

        log.info("今回取得したデータを過去の取得データと比較します");

        EntityManagerFactory factory;
        EntityManager manager;

        HashMap<String, String> map = new HashMap<String, String>();
        map.put("toplink.jdbc.url", "jdbc:h2:" + config.getDbFile());
        factory = Persistence.createEntityManagerFactory("NicoBrowserPU", map);
        manager = factory.createEntityManager();

        EntityTransaction transaction = manager.getTransaction();

        transaction.begin();
        try {
            // ランキング上位のコンテンツ保存
            int num = 0;
            for (NicoContent c : dailyList) {
                save(manager, c);
                num++;
            }

            // マイリストに登録したコンテンツ保存
            for (List<NicoContent> l : myLists) {
                for (NicoContent c : l) {
                    save(manager, c);
                }
            }

            transaction.commit();

            Query query = manager.createQuery("SELECT cont FROM NicoContent AS cont " + "WHERE ?1 <> cont.status").
                    setParameter(1, NicoContent.Status.GET_FILE);
            List<NicoContent> results = query.getResultList();
            instance.login(config.getNicoMail(), config.getNicoPassword());
            Date prevDate = null;
            for (NicoContent c : results) {
                if (c.getFailTimes() > config.getMaxRetry() + 1) {
                    continue;
                }
                if (prevDate != null) {
                    Date nowDate = Calendar.getInstance().getTime();
                    long sleep = nowDate.getTime() - prevDate.getTime();
                    sleep = 5000 - sleep;
                    if (sleep > 0) {
                        log.info("" + sleep + "ms sleep");
                        Thread.sleep(sleep);
                    }
                }
                prevDate = Calendar.getInstance().getTime();
                File saveLocation = new File(config.getSrcSaveDir(), c.getFileName());
                log.info("ファイルを取得します: " + c.getNicoId() + " " + c.getTitle());
                try {
                    GetFlvResult result = instance.getFlvFile(c.getNicoId(),
                            saveLocation.getCanonicalPath(), c.getStatus(),
                            true);
                    c.setAuthor(result.getAuthor());
                    Status status = result.getStatus();
                    c.setStatus(status);
                    if (status == Status.GET_INFO) {
                        c.setFailTimes(c.getFailTimes() + 1);
                    }
                } catch (Exception ex) {
                    c.setFailTimes(c.getFailTimes() + 1);
                    log.error("ファイル取得に失敗しました。" + c.getNicoId() + ", 通算失敗回数: " + c.getFailTimes(), ex);
                }
                transaction.begin();
                manager.persist(c);
                transaction.commit();
                log.info("完了しました");
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            transaction.rollback();
        } finally {
            manager.close();
            factory.close();
        }

    }

    private void save(EntityManager manager, NicoContent c) {
        Query query = manager.createQuery("SELECT cont FROM NicoContent AS cont " + "WHERE ?1 = cont.nicoId").
                setParameter(1, c.getNicoId());
        List<NicoContent> resList = query.getResultList();
        if (resList.isEmpty()) {
            log.info("NEW! " + c.getNicoId() + " : " + c.getFileName());
            manager.persist(c);
        }
    }
}
