/*$Id$*/
package nicobrowser;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import nicobrowser.entity.NicoContent;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import nicobrowser.entity.NicoContent.Status;
import org.apache.http.HttpException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author yuki
 */
public class NicoHttpClientTest {

    static final String OK_MAIL = "niconico.senyou@live.jp";
    static final String OK_PASS = "piyopiyo";
    static final String OK_LIST_NO = "3693055";

    public NicoHttpClientTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of getInstance method, of class NicoHttpClient.
     */
    @Test
    public void getInstance() {
        System.out.println("getInstance");
        NicoHttpClient result = NicoHttpClient.getInstance();
        assertNotNull(result);

        // 2回目でも同じインスタンスが返る.
        NicoHttpClient instance = NicoHttpClient.getInstance();
        assertEquals(result, instance);
    }

    /**
     * Test of login method, of class NicoHttpClient.
     */
    @Test
    public void login() throws HttpException, URISyntaxException, InterruptedException {
        System.out.println("login");
        NicoHttpClient instance = NicoHttpClient.getInstance();

        // ログイン失敗ケース
        instance.logout();
        String mail = "test@example.com";
        String password = "xxxx";
        boolean result = instance.login(mail, password);
        assertEquals(false, result);

        // ログイン成功ケース
        instance.logout();
        mail = OK_MAIL;
        password = OK_PASS;
        result = instance.login(mail, password);
        assertEquals(true, result);
    }

    @Test
    public void logout() throws URISyntaxException, HttpException, InterruptedException {
        System.out.println("logout");

        boolean result;
        result = NicoHttpClient.getInstance().logout();
        assertEquals(true, result);

        result = NicoHttpClient.getInstance().logout();
        assertEquals(true, result);
    }

    @Test
    public void loadMyList() throws URISyntaxException, HttpException, InterruptedException {
        System.out.println("loadMyList");

        NicoHttpClient instance = NicoHttpClient.getInstance();
        List list;

        list = instance.loadMyList(OK_LIST_NO);
        assertNotNull(list);
        assertNotSame(0, list.size());
//        for (Object o : list) {
//            System.out.println(o.toString());
//        }

        list = instance.loadMyList("XXXX");
        assertNotNull(list);
        assertSame(0, list.size());
    }

    @Test
    public void loadMyListDaily() throws URISyntaxException, HttpException, InterruptedException {
        System.out.println("loadMyListDaily");
        NicoHttpClient instance = NicoHttpClient.getInstance();
        List<NicoContent> list = instance.loadMyListDaily();
        assertNotNull(list);
        assertNotSame(0, list.size());
//        System.out.println(list.size());
//        for (Object o : list) {
//            System.out.println(o.toString());
//        }

        EntityManagerFactory factory;
        EntityManager manager;

        factory = Persistence.createEntityManagerFactory("NicoBrowserPU");
        manager = factory.createEntityManager();

        EntityTransaction transaction = manager.getTransaction();

        transaction.begin();
        try {
            for (NicoContent c : list) {
                manager.persist(c);
            }

            transaction.commit();
        } catch (Exception ex) {
            ex.printStackTrace();
            transaction.rollback();
        } finally {
            manager.close();
            factory.close();
        }

    }

    @Test
    public void getFlvUrl() throws URISyntaxException, HttpException, InterruptedException, IOException {
        System.out.println("getFlv");

        NicoHttpClient instance = NicoHttpClient.getInstance();
        instance.login(OK_MAIL, OK_PASS);
        try {
            URL str = instance.getFlvUrl("sm1359820");
            System.out.println(str);
        } catch (IOException ex) {
            fail();
            Logger.getLogger(NicoHttpClientTest.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    @Test
    public void downLoad() throws URISyntaxException, IOException, HttpException, InterruptedException {
        System.out.println("downLoad");

        NicoHttpClient instance = NicoHttpClient.getInstance();
        instance.login(OK_MAIL, OK_PASS);

        try {
            instance.getFlvFile("sm183036", "sm183036", NicoContent.Status.GET_INFO, false);
        } catch (IOException ex) {
            Logger.getLogger(NicoHttpClientTest.class.getName()).log(Level.SEVERE, null, ex);
            fail();
        }
    }

    /**
     * Test of getFlvFile method, of class NicoHttpClient.
     */
    @Test
    public void getFlvFile_String() throws HttpException, InterruptedException, URISyntaxException {
        System.out.println("getFlvFile");
        String videoID = "sm1097445";
        NicoHttpClient instance = NicoHttpClient.getInstance();
        instance.login(OK_MAIL, OK_PASS);
        GetFlvResult result;
        try {
            result = instance.getFlvFile(videoID);
            System.out.println(result);
            assertNotSame(Status.GET_INFO, result);
        } catch (Exception ex) {
            Logger.getLogger(NicoHttpClientTest.class.getName()).log(Level.SEVERE, null, ex);
            fail();
        }

        // 権限が無い動画？の取得
        // http://www.nicovideo.jp/watch/1231042440
        // 【亡き王女の為のセプテット・ツェペシュの幼き末裔】Priere -プリエール-
        try {
            result = instance.getFlvFile("1231042440");
            fail("権限が無い動画を取得しようとした場合は例外が送出される");
        } catch (IOException ex) {
            Logger.getLogger(NicoHttpClientTest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Test
    public void search() throws URISyntaxException, InterruptedException, HttpException, IOException {
        System.out.println("search");
        NicoHttpClient instance = NicoHttpClient.getInstance();
        instance.login(OK_MAIL, OK_PASS);

        List<NicoContent> conts = instance.search("初音ミク");
        System.out.println("検索結果件数： " + conts.size());
        assertTrue(conts.size() > 0);
        assertTrue(conts.size() > 100);

    }

    @Test
    public void loadMyMovie() throws URISyntaxException, InterruptedException, HttpException, IOException {
        System.out.println("search");
        NicoHttpClient instance = NicoHttpClient.getInstance();
        instance.login(OK_MAIL, OK_PASS);

        NicoContent cont;

        // 通常の動画
        cont = instance.loadMyMovie("sm9");
        assertNotNull(cont);
        assertEquals("sm9", cont.getNicoId());

        // チャンネル動画はnull(statusがfailなので)
        cont = instance.loadMyMovie("1228201771");
        assertNull(cont);

        // 削除済み
        cont = instance.loadMyMovie("sm1");
        assertNull(cont);

        // 存在しない
        cont = instance.loadMyMovie("xxx");
        assertNull(cont);


    }
}
