package nicobrowser;

/**
 * 過去ログを取得するための情報.
 * @author yuki
 */
public class WayBackInfo {

    private final String key;
    private final long time;

    public WayBackInfo(String key, long time) {
        if (key == null || time <= 0) {
            throw new IllegalArgumentException(" key: " + key + ", time: " + time);
        }

        this.key = key;
        this.time = time;
    }

    public String getKey() {
        return key;
    }

    public long getTime() {
        return time;
    }
}
