/* $Id$ */
package nicobrowser;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

public class NamePatternTest {

    /**
     * Test of createFileName method, of class NamePattern.
     */
    @Test
    public void testCreateFileName() {
        final String title = "*タ\\イ/ト\"ル";
        System.out.println(title);
        final String id = "sm9999";
        String res;

        System.out.println("createFileName");
        NamePattern np = new NamePattern("{title}{title}", title);
        res = np.createFileName("sm9", true);
        assertEquals("＊タ￥イ／ト”ル＊タ￥イ／ト”ル", res);

        NamePattern np2 = new NamePattern("[{id}]{title}", title);
        res = np2.createFileName(id, false);
        assertEquals("[sm9999]＊タ￥イ／ト”ル", res);

        NamePattern np3 = new NamePattern("{id}{low}_{title}", title);
        res = np3.createFileName(id, false);
        assertEquals("sm9999low_＊タ￥イ／ト”ル", res);

        NamePattern np4 = new NamePattern("{id}{low}_{title}", title);
        res = np4.createFileName(id, true);
        assertEquals("sm9999_＊タ￥イ／ト”ル", res);

    }
}
