package yukihane.inqubus.config;

import yukihane.inqubus.config.Config;
import java.io.File;
import static org.junit.Assert.*;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import org.apache.commons.configuration.ConfigurationException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 *
 * @author yuki
 */
public class ConfigTest {

    private final Config p = Config.INSTANCE;

    @Before
    public void setUp() {
        Config.INSTANCE.clear();
    }

    @After
    public void tearDown() {
        Config.INSTANCE.clear();
    }

    @Test
    public void testLoadFail() {
        FileSystem fs = FileSystems.getDefault();
        System.out.println(fs.getPath(".").toAbsolutePath());
        Config p = Config.INSTANCE;
        try {
            p.load("test/testdata/error.xml");
            fail("ファイルが存在しないので読み込みに失敗するはず");
        } catch (ConfigurationException ex) {
        }
        try {
            p.load("test/testdata/inqubus_test.xml");
            fail("ファイルが空なので読み込みに失敗するはず");
        } catch (ConfigurationException ex) {
        }
    }

//    @Test
//    public void test2() throws ConfigurationException, IllegalArgumentException, IllegalAccessException {
//        Properties p = Properties.INSTANCE;
//        p.load("test/testdata/inqubus_test.ok");
//        p.setDbLocation("d_loc");
//        p.save();
//        Field[] fields = p.getClass().getDeclaredFields();
//        for(Field f: fields){
//            f.setAccessible(true);
//            System.out.println(f.get(p));
//        }
//    }
    @Test
    public void testGetSetNetworkAccount() {
    }

    /**
     * コンフィグ取得・設定テストケース.
     * デフォルト値の取得、設定とその設定値の取得のテストです.
     */
    @Test
    public void testGetSetNetworkProxy() throws ConfigurationException {

        /*
         * ネットワーク - アカウント
         */
        assertEquals("", p.getId());
        p.setId("id");
        assertEquals("id", p.getId());

        assertEquals("", p.getPassword());
        p.setPassword("password");
        assertEquals("password", p.getPassword());


        /*
         * ネットワーク - プロキシ
         */
        assertEquals(false, p.getProxyUse());
        p.setProxyUse(true);
        assertEquals(true, p.getProxyUse());

        assertEquals("localhost", p.getProxyHost());
        p.setProxyHost("proxyhost");
        assertEquals("proxyhost", p.getProxyHost());

        assertEquals("8080", p.getProxyPort());
        p.setProxyPort("80");
        assertEquals("80", p.getProxyPort());


        /*
         * ファイル - 動画
         */
        assertEquals("in/video", p.getVideoDir());
        p.setVideoDir("v");
        assertEquals("v", p.getVideoDir());

        assertEquals("[{id}]{title}", p.getVideoFileNamePattern());
        p.setVideoFileNamePattern("videotitle");
        assertEquals("videotitle", p.getVideoFileNamePattern());

        assertEquals(false, p.getVideoUseLocal());
        p.setVideoUseLocal(true);
        assertEquals(true, p.getVideoUseLocal());

        /*
         * ファイル - コメント
         */
        assertEquals("in/comment", p.getCommentDir());
        p.setCommentDir("c");
        assertEquals("c", p.getCommentDir());

        assertEquals("[{id}]{title}", p.getCommentFileNamePattern());
        p.setVideoFileNamePattern("comtitle");
        assertEquals("comtitle", p.getVideoFileNamePattern());

        assertEquals(false, p.getCommentUseLocal());
        p.setCommentUseLocal(true);
        assertEquals(true, p.getCommentUseLocal());


        /*
         * ファイル - 変換動画
         */
        assertEquals("out", p.getOutputDir());
        p.setOutputDir("_out_");
        assertEquals("_out_", p.getOutputDir());

//        p.save(new File("test/testdata/save.xml"));
    }
}
