package yukihane.inqubus.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import yukihane.inqubus.model.Progress;

/**
 *
 * @author yuki
 */
public class TargetsColumnModel extends DefaultTableColumnModel {

    private static final long serialVersionUID = 1L;
    private final String[] columnNames = new String[]{"ID", "動画", "コメ", "変換", "状態"};

    public TargetsColumnModel() {
        super();
        for (int i = 0; i < columnNames.length; i++) {
            final TableColumn tc = new TableColumn(i);
            tc.setHeaderValue(columnNames[i]);
            addColumn(tc);
        }

        final TableColumn tcId = getColumn(0);
        tcId.setPreferredWidth(85);

        final TableColumn tcVideo = getColumn(1);
        tcVideo.setPreferredWidth(40);

        final TableColumn tcComment = getColumn(2);
        tcComment.setPreferredWidth(40);

        final TableColumn tcConvert = getColumn(3);
        tcConvert.setPreferredWidth(40);

        final TableColumn tcProgress = getColumn(4);
        tcProgress.setCellRenderer(new ProgressRenderer());
        tcProgress.setPreferredWidth(260);
    }
}

class ProgressRenderer extends DefaultTableCellRenderer {

    private static final long serialVersionUID = 1L;
    private final JProgressBar progressBar;

    public ProgressRenderer() {
        progressBar = new JProgressBar(0, 100);
        progressBar.setStringPainted(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus,
            int row, int column) {
        if (value == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        final Progress p = (Progress) value;
        int percent = (int) p.getPercent();
        if (percent < 0 || percent > 100) {
            return super.getTableCellRendererComponent(table, p.getText(), isSelected, hasFocus, row, column);
        }

        progressBar.setValue(percent);
        progressBar.setString(p.getText());
        return progressBar;
    }
}
