package saccubus.worker.impl.convert;

import org.apache.commons.lang.builder.ToStringBuilder;
import saccubus.worker.impl.MessageReportable;
import saccubus.worker.impl.PercentageReportable;

/**
 *
 * @author yuki
 */
public class ConvertProgress implements PercentageReportable, MessageReportable {

    private final ConvertStatus status;
    private final double percentage;
    private final String message;

    ConvertProgress(ConvertStatus status, double percentage, String message) {
        this.status = status;
        this.percentage = percentage;
        this.message = message;
    }

    public ConvertStatus getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public double getPercentage() {
        return percentage;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
