package saccubus.util;

import java.io.IOException;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author yuki
 */
public class WayBackTimeParserTest {

    /** 年月日時分秒指定 */
    @Test
    public void testParseYYYYMMDD_H_M_S() throws IOException {
        final String text = "2011/08/19 00:00:12";
        final long expected = 1313679612L;
        final long actual = WayBackTimeParser.parse(text);
        assertEquals(expected, actual);
    }

    /** 年月日時分指定(秒省略) */
    @Test
    public void testParseYYYYMMDD_H_M() throws IOException {
        final String text = "2011/08/19 00:00";
        final long expected = 1313679600L;
        final long actual = WayBackTimeParser.parse(text);
        assertEquals(expected, actual);
    }

    /** 年月日指定 */
    @Test
    public void testParseYYYYMMDD() throws IOException {
        final String text = "2011/08/19";
        final long expected = 1313679600L;
        final long actual = WayBackTimeParser.parse(text);
        assertEquals(expected, actual);
    }

    /** 1970 年 1 月 1 日 00:00:00 GMT からの秒数指定(一般的なミリ秒指定ではないことに注意 */
    @Test
    public void testParseNumber() throws IOException {
        final String text = "1313679600";
        final long actual = WayBackTimeParser.parse(text);
        assertEquals(Long.parseLong(text), actual);
    }
}
