/**
 *----------------------------------------------------------------------------
 *
 * @file	$Id: PopupDialog.cpp 127 2008-05-12 15:06:14Z Shiono $
 * @brief	popup daialog āA\Ƃ܂łsNX
 *			EBhẼTCYƂʒuƂ͂ň
 *
 * @author  Salt
 *
 *----------------------------------------------------------------------------
 */

#include "StdAfx.h"
#include "PopupDialog.h"

#include <windowsx.h>	// for GET_X_LPARAM, GET_Y_LPARAM


CPopupDialog::CPopupDialog(void)
: m_hWndParent(NULL)
, m_bChild(FALSE)
{
}


CPopupDialog::~CPopupDialog(void)
{
}

/**
 * pŃI[oChAŌŁA__super::NormalizeUserSettings(); ĂԕKvB
 * Ă΂ȂƁAeNX̃p[^KȂB
 */
void CPopupDialog::NormalizeUserSettings(void)
{
	// TCY̐
	int nMaxSize = GetSystemMetrics(SM_CXSCREEN);
	if (nMaxSize > GetSystemMetrics(SM_CYSCREEN))
		nMaxSize = GetSystemMetrics(SM_CYSCREEN);

	// ̃TCY̐`܂łɐ
	m_nWindowWidth  = min(max(1, m_nWindowWidth),  nMaxSize);
	m_nWindowHeight = min(max(1, m_nWindowHeight), nMaxSize);

	// ʓɓ
	if (GetSystemMetrics(SM_CXSCREEN) < GetSystemMetrics(SM_CYSCREEN)) {
		// c
		if (m_nWindowLeft > GetSystemMetrics(SM_CXSCREEN) - m_nWindowWidth)
			m_nWindowLeft = GetSystemMetrics(SM_CXSCREEN) - m_nWindowWidth;

		if (m_nWindowTop > GetSystemMetrics(SM_CYSCREEN) - m_nWindowHeight)
			m_nWindowTop = GetSystemMetrics(SM_CYSCREEN) - m_nWindowHeight;

		if (m_nWindowLeftHorizontal > GetSystemMetrics(SM_CYSCREEN) - m_nWindowWidth)
			m_nWindowLeftHorizontal = GetSystemMetrics(SM_CYSCREEN) - m_nWindowWidth;

		if (m_nWindowTopHorizontal > GetSystemMetrics(SM_CXSCREEN) - m_nWindowHeight)
			m_nWindowTopHorizontal = GetSystemMetrics(SM_CXSCREEN) - m_nWindowHeight;
	}
	else {
		// 
		if (m_nWindowLeft > GetSystemMetrics(SM_CYSCREEN) - m_nWindowWidth)
			m_nWindowLeft = GetSystemMetrics(SM_CYSCREEN) - m_nWindowWidth;

		if (m_nWindowTop > GetSystemMetrics(SM_CXSCREEN) - m_nWindowHeight)
			m_nWindowTop = GetSystemMetrics(SM_CXSCREEN) - m_nWindowHeight;

		if (m_nWindowLeftHorizontal > GetSystemMetrics(SM_CXSCREEN) - m_nWindowWidth)
			m_nWindowLeftHorizontal = GetSystemMetrics(SM_CXSCREEN) - m_nWindowWidth;

		if (m_nWindowTopHorizontal > GetSystemMetrics(SM_CYSCREEN) - m_nWindowHeight)
			m_nWindowTopHorizontal = GetSystemMetrics(SM_CYSCREEN) - m_nWindowHeight;
	}
}


void CPopupDialog::MoveWindowByScreenDirection(HWND hWnd)
{
	BOOL bPortrait = GetSystemMetrics(SM_CXSCREEN) < GetSystemMetrics(SM_CYSCREEN);	// portrait / landscape
	if (m_bChild) {
		RECT rect;
		GetWindowRect(m_hWndParent, &rect);
		if (bPortrait) {
			// c
			MoveWindow(hWnd, m_nWindowLeft - rect.left, m_nWindowTop - rect.top, m_nWindowWidth, m_nWindowHeight, 0);
		}
		else {
			// 
			MoveWindow(hWnd, m_nWindowLeftHorizontal - rect.left, m_nWindowTopHorizontal - rect.top, m_nWindowWidth, m_nWindowHeight, 0);
		}
	}
	else {
		if (bPortrait) {
			// c
			MoveWindow(hWnd, m_nWindowLeft, m_nWindowTop, m_nWindowWidth, m_nWindowHeight, 0);
		}
		else {
			// 
			MoveWindow(hWnd, m_nWindowLeftHorizontal, m_nWindowTopHorizontal, m_nWindowWidth, m_nWindowHeight, 0);
		}
	}


}


//----------------------------------------------------------------------------
/**
 * @retval	TRUE	BI DefWindowProc() Ă΂ȂB
 * @retval	FALSE	ĂȂBI DefWindowProc() ĂԁB
 */
BOOL CPopupDialog::OnInitDialog(HWND hWnd)
{
	MoveWindowByScreenDirection(hWnd);

	return TRUE;
}


INT_PTR CALLBACK CPopupDialog::DialogProc(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uiMsg) {

	case WM_INITDIALOG:
		m_hWnd = hWnd;		// emulator ƁAœĂȂƁAWM_TIMER ɗĂ܂B{́ACreateDialogIndirect() ̕Ԓl m_hWnd ɓ΂͂B
		if (OnInitDialog(hWnd))
			return 0;		// key focus 𓖂Ă 1 Ԃ
		break;


	case WM_DESTROY:
		if (OnDestroy(hWnd))
			return 1;		// A0 ȊOԂ
		break;


	case WM_PAINT:
		if (OnPaint(hWnd))
			return 1;		// A0 ȊOԂ
		break;


	case WM_ERASEBKGND:
		if (OnEraseBkgnd((HDC) wParam))
			return 1;		// A0 ȊOԂB0 Ԃ OS ŔwiAŏȂ 0 ȊOԂB
		break;


	case WM_TIMER:
		if (OnTimer(hWnd, (int) wParam))
			return 1;		// A0 ȊOԂ
		break;


	case WM_SETTINGCHANGE:
		if (wParam == SETTINGCHANGE_RESET) {
			MoveWindowByScreenDirection(hWnd);
		}
		break;


	case WM_LBUTTONDOWN:
		// MAKEPOINTS g POINTS ɂȂBPOINT ł͂Ȃ̂ŎgȂB
		POINT point;
		point.x = GET_X_LPARAM(lParam);
		point.y = GET_Y_LPARAM(lParam);

		if (OnLButtonDown(hWnd, point))
			return 1;		// A0 ȊOԂ
		break;

	//case WM_CTLCOLORDLG:

	}

    return DefWindowProc(hWnd, uiMsg, wParam, lParam) ;
}

// z[~ http://geocities.yahoo.co.jp/gl/hou_ming_2/comment/20060523/1148398202 QlɂĂ
HWND CPopupDialog::Create(HINSTANCE hInstance, HWND hWndParent, const TCHAR *pszCaption, INT_PTR (CALLBACK *pDialogProc)(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam), BOOL bChild)
{
	m_hWndParent = hWndParent;
	m_bChild = bChild;

	typedef struct{
		DLGTEMPLATE dt;
		DLGITEMTEMPLATE di;		//  DWORD EɒuKv
	} DLG_TEMPLATE;

	DLG_TEMPLATE dlg = {
		bChild ? WS_CHILD : WS_POPUP,
		WS_EX_TOPMOST | WS_EX_NOACTIVATE | WS_EX_TOOLWINDOW,
		0,						// number of DLGITEMTEMPLATE
		0, 0, 0, 0,				// x, y, cx, cy

		0,						// style
		0,						// dwExtendedStyle
		0, 0, 0, 0,				// x, y, cx, cy
		0						// id
	};


	m_hWnd = (HWND) HWND_UNIQUE_ID_BEFORE_CREATING;		// DialogProc() ŁÃCX^X悤ɂB CreateDialogIndirect() ̒ŁADialogPoroc() Ă΂̂ŁB
	m_hWnd = CreateDialogIndirect(hInstance,
									(LPCDLGTEMPLATE) &dlg,
									hWndParent,
									pDialogProc);
	SetWindowTextW(m_hWnd, pszCaption);

	return m_hWnd;
}

