﻿using System.Collections.Generic;
using lib2ch.IO;
using lib2ch.Data;

namespace lib2ch.Model
{
    public class BbsMenu
    {
        string _Path = "./Log";
        string _FileName = "/bbsmenu.html";
        string _Host = "http://menu.2ch.net";

        string _Menu00 = "<BR><BR><B>";
        string _Menu01 = "</B>";
        string _Sub00 = "<A HREF=";
        string _UrlEnd01 = "/>";
        string _UrlEnd02 = "/ TARGET=_blank>";
        string _SubEnd = "</A>";
        FileManager _File;
        public BbsMenu()
        {
            _File = new FileManager();
        }
        public List<BbsMenuItem> GetMenuList()
        {
            //ファイルの有無
            FileResult fileResult = _File.StandardCheck(_Path, _Host, _FileName);
            if (fileResult == null) return null;
            //解析処理
            return BbsMenuParsing(fileResult.Line);
        }

        private List<BbsMenuItem> BbsMenuParsing(List<string> data)
        {
            List<BbsMenuItem> list = new List<BbsMenuItem>();
            string Parent = "";
            bool mode = false;
            for (int i = 0; i < data.Count; i++)
            {
                //大見出
                int index1 = data[i].IndexOf(_Menu00);
                if (index1 != -1)
                {
                    int index2 = data[i].IndexOf(_Menu01);
                    if (index2 != -1)
                    {
                        if (mode == false)
                        {
                            mode = true;
                        }
                        Parent = data[i].Substring(index1 + _Menu00.Length, index2 - (index1 + _Menu00.Length));
                        continue;
                    }
                }
                if (mode == true)
                {
                    BbsMenuItem Item = BbsMenuFindLine(data[i], _Sub00, _UrlEnd01, _SubEnd);
                    if (Item.Url.Length == 0)
                        Item = BbsMenuFindLine(data[i], _Sub00, _UrlEnd02, _SubEnd);
                    if (Item.Url.Length != 0)
                    {
                        Item.ParentName = Parent;
                        list.Add(Item);
                    }
                }
            }
            return list;
        }
        private BbsMenuItem BbsMenuFindLine(string Line, string Word1, string Word2, string Word3)
        {
            BbsMenuItem Item = new BbsMenuItem();
            int index1 = Line.IndexOf(Word1);
            if (index1 != -1)
            {
                int index2 = Line.IndexOf(Word2);
                if (index2 != -1)
                {
                    int index3 = Line.IndexOf(Word3);
                    if (index3 != -1)
                    {
                        Item.Url = Line.Substring(index1 + Word1.Length, index2 - (index1 + Word1.Length));
                        Item.Name = Line.Substring(index2 + Word2.Length, index3 - (index2 + Word2.Length));
                    }
                }
            }
            return Item;
        }
    }
}