﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace AquaButton
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.BackColor = Color.Brown;
            GlassDraw();
            AquaDraw();
        }

        private void GlassDraw()
        {
            Bitmap bmp = new Bitmap(200, 50);
            //
            // ボタン土台
            //
            ExtendedDraw(bmp,
                new RectangleF(2, 2, bmp.Width - 2, bmp.Height - 2),
                Color.FromArgb(0x3F, 0xFF, 0xFF, 0xFF),
                Color.FromArgb(0x3F, 0xFF, 0xFF, 0xFF),
                5F,
                true
                );
            //
            // ボタンてかり
            //
            ExtendedDraw(bmp,
                new RectangleF(2, 2, bmp.Width -2, ((bmp.Height) / 2)),
                Color.FromArgb(0xEF, 0xFF, 0xFF, 0xFF),
                Color.FromArgb(0x0F, 0xFF, 0xFF, 0xFF),
                5F,
                true
                );
            //
            // ボタンてかり
            //
            ExtendedDraw(bmp,
                new RectangleF(2, 2 + ((bmp.Height) / 2), bmp.Width - 2, ((bmp.Height) / 2)),
                Color.FromArgb(0x0F, 0xFF, 0xFF, 0xFF),
                Color.FromArgb(0x4F, 0xFF, 0xFF, 0xFF),
                5F,
                true
                );
            pictureBox1.Image = bmp;
        }
        //こっちはうまくいかん・・・
        private void AquaDraw()
        {
            Bitmap bmp = new Bitmap(200, 50);
            //
            // 影
            //
            ExtendedDraw(bmp,
                new RectangleF(5, 5, bmp.Width - 5, bmp.Height - 5),
                Color.FromArgb(0x3F, 0x00, 0x00, 0x1F),
                Color.FromArgb(0x3F, 0x00, 0x00, 0x1F),
                20F,
                true
                );
            //
            // ボタン土台
            //
            ExtendedDraw(bmp,
                new RectangleF(2, 2, bmp.Width - 5, bmp.Height - 5),
                Color.Blue,
                Color.Blue,
                20F,
                true
                );
            //
            // ボタンてかり
            //
            ExtendedDraw(bmp,
                new RectangleF(10, 3, bmp.Width - 20, ((bmp.Height) / 3)),
                Color.FromArgb(0xEF, 0xFF, 0xFF, 0xFF),
                Color.FromArgb(0x3F, 0xFF, 0xFF, 0xFF),
                30F,
                true
                );
            //
            // ボタンてかり
            //
            ExtendedDraw(bmp,
                new RectangleF(5, 10 + ((bmp.Height) / 2.5F), bmp.Width - 15, ((bmp.Height) / 2.5F)),
                Color.FromArgb(0x4F, 0xFF, 0xFF, 0xFF),
                Color.FromArgb(0x0F, 0xFF, 0xFF, 0xFF),
                20F,
                true
                );
            pictureBox2.Image = bmp;
        }
        private void ExtendedDraw(Bitmap bmp, RectangleF rec, Color bColor1, Color bColor2,
            float radius,bool option)
        {
            ExtendedGraphics g = new ExtendedGraphics(Graphics.FromImage(bmp));
            //アンチエイリアス
            g.Graphics.SmoothingMode = SmoothingMode.AntiAlias;
            LinearGradientBrush b = new LinearGradientBrush(
                rec,
                bColor1,
                bColor2,
                //グラデーション方向を指定できます。
                LinearGradientMode.Vertical
                );
            //表現が変わります。
            b.GammaCorrection = option;
            g.FillRoundRectangle(b,
                rec.X,
                rec.Y,
                rec.Width,
                rec.Height,
                //ここを変えると角の丸みが変わります。
                radius
                );
            b.Dispose();
        }
    }
}
