﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Arrow
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        int moveX;
        int moveY;
        int mouse_X;
        int mouse_Y;
        int form_move_start;
        private void Form1_Load(object sender, EventArgs e)
        {
            this.BackColor = Color.White;
            //ちらつき防止のための設定
            this.SetStyle(ControlStyles.DoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
        }

        private void Form1_Paint(object sender,
                    PaintEventArgs e)
        {
            if (form_move_start == 1)
            {
                //アンチエイリアス指定
                e.Graphics.SmoothingMode =
                    SmoothingMode.AntiAlias;
                //グラデーションブラシ作成
                LinearGradientBrush b = 
                    new LinearGradientBrush(
                    new Point(mouse_X, mouse_Y),
                    new Point(moveX, moveY),
                    //始点側の色
                    Color.Gold,
                    //終点側の色
                    Color.Black
                    );
                //矢印型のペンを作成
                Pen p = new Pen(b, 22);
                //始点側のキャップ
                //p.StartCap = LineCap.ArrowAnchor;
                //終点側のキャップ
                p.EndCap = LineCap.ArrowAnchor;
                //矢印を描画
                e.Graphics.DrawLine(p,
                    mouse_X,
                    mouse_Y,
                    moveX,
                    moveY
                    );
                p.Dispose();
            }
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            form_move_start = 0;
            this.Invalidate();
        }

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            if (form_move_start == 0)
            {
                mouse_X = e.X;
                mouse_Y = e.Y;
                form_move_start = 1;
            }
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if (form_move_start == 1)
            {
                moveX = e.X;
                moveY = e.Y;
                this.Invalidate();
            }
        }
    }
}
