﻿using System;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Web;
using System.Text.RegularExpressions;

namespace HtmlEncode
{
    public partial class Form1 : Form
    {
        Encoding _Type;
        TextBox[] textbox;
        string[] FileName;
        const int FileCount = 3;
        public Form1()
        {
            InitializeComponent();
            _Type = Encoding.GetEncoding("Shift_JIS");
            textbox = new TextBox[FileCount] {
                textBox3,
                textBox4,
                textBox5,

            };
            FileName = new string[FileCount] {
                "./Replace01.txt",
                "./Replace02.txt",
                "./Replace03.txt"
            };
        }
        private void button1_Click(object sender, EventArgs e)
        {
            this.Enabled = false;
            textBox6.AppendText("変換処理開始:"
                + DateTime.Now
                + Environment.NewLine
                );
            textBox2.Clear();
            this.Text = textBox1.Lines.Length.ToString();
            string[] html = textBox1.Lines;
            string res = "";
            for (int i = 0; i < html.Length; i++)
            {
                html[i] = HttpUtility.HtmlEncode(html[i]);
                html[i] = html[i].Replace("\t", "&nbsp&nbsp&nbsp&nbsp;");
                html[i] = html[i].Replace("    ", "&nbsp&nbsp&nbsp&nbsp;");
                //html[i] = Replace(html[i], textBox3.Lines);
                //html[i] = Replace(html[i], textBox4.Lines);
                //html[i] = Replace(html[i], textBox5.Lines);
                res += html[i]+Environment.NewLine;
            }
            textBox2.Text = "<pre name=\"code\" class=\"csharp\">" + res + "</pre>";
            textBox6.AppendText("変換処理終了:"
                + DateTime.Now
                + Environment.NewLine
                );
            Clipboard.SetText(textBox2.Text);
            this.Enabled = true;
        }
        private string Replace(string html,string[] Lines)
        {
            for (int i = 0; i < Lines.Length;)
            {
                string Line01 = Lines[i];
                i++;
                if (Line01.Length == 0)
                {
                    ErrMes01(i);
                    i++;
                    continue;
                }
                string Line02 = Lines[i];
                i++;
                if (Line02.Length == 0)
                {
                    ErrMes01(i);
                    continue;
                }
                try
                {
                    html = Regex.Replace(html, Line01, Line02);
                }
                catch
                {
                    ErrMes02(Line01, Line02);
                }
            }
            return html;
        }
        private void ErrMes01(int i)
        {
            textBox6.AppendText("データの長さが0のため"
                + i.ToString("000000")
                + "行目のReplaceをスキップします。:"
                + DateTime.Now
                + Environment.NewLine
            );
        }
        private void ErrMes02(string Line01,string Line02)
        {
            textBox6.AppendText("Replace処理でエラーが発生しました。:"
                + DateTime.Now
                + Environment.NewLine
                );
            textBox6.AppendText("次の構文を見直してください。"
                + Environment.NewLine
                );
            textBox6.AppendText(Line01
                + Environment.NewLine
                );

            textBox6.AppendText(Line02
                + Environment.NewLine
                );
        }
        private void ReplaceLoad()
        {

            StreamReader sr;
            for (int i = 0; i < FileCount; i++)
            {
                try
                {
                    sr = new StreamReader(FileName[i], _Type);
                    textbox[i].Text = sr.ReadToEnd();
                    sr.Close();
                }
                catch
                {
                    textBox6.AppendText(FileName
                        + "がありませんでした。"
                        + DateTime.Now
                        + Environment.NewLine
                    );
                }
            }
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            ReplaceLoad();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            ReplaceLoad();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            textBox1.Clear();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < FileCount; i++)
            {
                try
                {
                    System.Diagnostics.Process.Start(FileName[i]);
                }
                catch
                {
                }
            }
        }
    }
}
