﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Tetris
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            this.SetStyle(ControlStyles.DoubleBuffer, true);
            this.SetStyle(ControlStyles.UserPaint, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
        }
        const int BSize = 24;
        const int XSize = 12;
        const int YSize = 25;
        int keybuf;
        Random rand;
        Bitmap[] bmp;
        int buf = 0;
        Screen Screen;
        Status current;
        Bitmap mino;
        int Mode;
        private void Form1_Load(object sender, EventArgs e)
        {
            //this.FormBorderStyle = FormBorderStyle.None;
            this.KeyPreview = true;
            this.KeyDown += new KeyEventHandler(frm_KeyDown);
            this.MouseClick += new MouseEventHandler(Screen_MouseClick);
            keybuf = 0;
            //this.Size = new Size(BSize * XSize, BSize * YSize);
            //this.Screen.Size = new Size(BSize * XSize, BSize * YSize);
            label.Location = new Point(0, 0);
            label1.Size = new Size(BSize * XSize, BSize * YSize);
            rand = new Random();
            bmp = new Bitmap[2];
            bmp[0] = new Bitmap(BSize * XSize, BSize * YSize);
            bmp[1] = new Bitmap(BSize * XSize, BSize * YSize);
            Screen = new Screen();
            #region
            current = new Status();
            current.x = 5;
            current.y = 21;
            current.type = this.random(7) + 1;
            current.rotate = this.random(4);
            Screen.PutBlock(current, false);
            #endregion

            mino = new Bitmap("./Block.png");

            int Mode = 0;
            label1.AutoSize = true;
        }
        private void frm_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Left)
                keybuf |= 1;
            else
                keybuf &= 0x0E;
            if (e.KeyCode == Keys.Right)
                keybuf |= 2;
            else
                keybuf &= 0x0D;
            if (e.KeyCode == Keys.Up)
                keybuf |= 4;
            else
                keybuf &= 0x0B;
            if (e.KeyCode == Keys.Down)
                keybuf |= 8;
            else
                keybuf &= 0x07;
        }
        public void keychk()
        {
            Status n = new Status();
            n = current;
            if ((keybuf & 1) == 1)
            {
                n.x--;
            }
            else if ((keybuf & 2) == 2)
            {
                n.x++;
            } else if ((keybuf & 4) == 4)
            {
                n.rotate++;
            } else if ((keybuf & 8) == 8)
            {
                n.y--;
            }
            keybuf = 0;
            if (n.x != current.x || n.y != current.y || n.rotate != current.rotate)
            {
                Screen.DelBlock(current);
                if (Screen.PutBlock(n, false))
                {
                    current = n;
                }
                else
                {
                    Screen.PutBlock(current, false);
                }
            }
            return;
        }
        static void Screen_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                Application.Exit();
            }
        }
        public int random(int max)
        {
            return rand.Next(max);
        }
        public void Draw()
        {
            using (Graphics g = Graphics.FromImage(bmp[buf]))
            {
                for (int x = 0; x < XSize; x++)
                {
                    for (int y = 0; y < YSize; y++)
                    {
                        Rectangle rect = new Rectangle(0, BSize * Screen.borad[x, y], BSize, BSize);
                        g.DrawImage(mino, x * BSize, (YSize - y - 1) * BSize, rect,GraphicsUnit.Pixel);
                    }
                }
            }
            this.BackgroundImage = bmp[buf];
            buf ^= 1;
        }
        public void blockDown()
        {
            if (Mode == 0)
            {
                Screen.DelBlock(current);
                current.y--;
                if (!Screen.PutBlock(current, false))
                {
                    current.y++;
                    Screen.PutBlock(current, false);

                    this.delLine();

                    current.x = 5;
                    current.y = 21;
                    current.type = this.random(7) + 1;
                    current.rotate = this.random(4);
                    if (!Screen.PutBlock(current, false))
                    {
                        Mode = 1;
                        GameOver();
                    }
                }
            }
        }
        public void GameOver()
        {
            for (int x = 0; x < 12; x++)
            {
                for (int y = 0; y < 25; y++)
                {
                    if (Screen.borad[x, y] != 0)
                    {
                        Screen.borad[x, y] = 1;
                    }
                }
            }
        }
        public Label label
        {
            get { return label1; }
        }
        public void delLine()
        {
            for (int y = 1; y < 23; y++)
            {
                bool flag = true;
                for (int x = 1; x <= 10; x++)
                {
                    if (Screen.borad[x, y] == 0)
                    {
                        flag = false;
                    }
                }
                if (flag)
                {
                    for (int j = y; j < 23; j++)
                    {
                        for (int i = 1; i <= 10; i++)
                        {
                            Screen.borad[i, j] = Screen.borad[i, j+1];
                        }
                    }
                    y--;
                }
            }
        }
    }
}
