# the name of the target operating system
SET(CMAKE_SYSTEM_NAME Windows)

SET(CSP_CROSS_BUILD 1)

SET(TARGET_ARCH i686-w64-mingw32)
SET(LIBS_PREFIX /usr/local/i586-mingw-msvc)

UNSET(CSP_LLVM_TOOLCHAIN_SUFFIX)
if(DEFINED CMAKE_CSP_LLVM_VERSION)
   SET(CSP_LLVM_TOOLCHAIN_SUFFIX "-${CMAKE_CSP_LLVM_VERSION}")
endif()


SET(CMAKE_C_COMPILER ${TARGET_ARCH}-clang${CSP_LLVM_TOOLCHAIN_SUFFIX})
SET(CMAKE_CXX_COMPILER ${TARGET_ARCH}-clang++${CSP_LLVM_TOOLCHAIN_SUFFIX})
#SET(CMAKE_RC_COMPILER ${TARGET_ARCH}-windres)
SET(CMAKE_AR ${TARGET_ARCH}-ar${CSP_LLVM_TOOLCHAIN_SUFFIX})
SET(CMAKE_C_COMPILER_AR  ${TARGET_ARCH}-ar${CSP_LLVM_TOOLCHAIN_SUFFIX})
SET(CMAKE_CXX_COMPILER_AR  ${TARGET_ARCH}-ar)
SET(CMAKE_LD  ${TARGET_ARCH}-lld${CSP_LLVM_TOOLCHAIN_SUFFIX})
SET(CMAKE_LINKER  ${TARGET_ARCH}-lld${CSP_LLVM_TOOLCHAIN_SUFFIX})
SET(CMAKE_EXE_LINKER ${TARGET_ARCH}-lld${CSP_LLVM_TOOLCHAIN_SUFFIX})
SET(CMAKE_SHARED_LINKER  ${TARGET_ARCH}-lld${CSP_LLVM_TOOLCHAIN_SUFFIX})
SET(CMAKE_NM  nm)
SET(CMAKE_RANLIB  ${TARGET_ARCH}-ranlib${CSP_LLVM_TOOLCHAIN_SUFFIX})
SET(CMAKE_C_COMPILER_RANLIB  ${TARGET_ARCH}-ranlib${CSP_LLVM_TOOLCHAIN_SUFFIX})
SET(CMAKE_CXX_COMPILER_RANLIB  ${TARGET_ARCH}-ranlib${CSP_LLVM_TOOLCHAIN_SUFFIX})

# here is the target environment located
set(USE_SDL2 ON)
if(USE_SDL2)
   SET(CMAKE_FIND_ROOT_PATH  /usr/${TARGET_ARCH} 
                          ${LIBS_PREFIX}
			  ${LIBS_PREFIX}/Qt5.15/mingw_90x
			  )
else()
   SET(CMAKE_FIND_ROOT_PATH  /usr/${TARGET_ARCH} 
                          ${LIBS_PREFIX}
			  ${LIBS_PREFIX}/Qt5.15/mingw_90x
			  )
endif()
SET(CSP_CROSS_BUILD 1)

# adjust the default behaviour of the FIND_XXX() commands:
# search headers and libraries in the target environment, search 
# programs in the host environment
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)

set(SDL2_LIBRARIES
                         ${LIBS_PREFIX}/lib/libSDL2.dll.a 
			 ${LIBS_PREFIX}/lib/libSDL2main.a)
set(SDL2_INCLUDE_DIRS ${LIBS_PREFIX}/include/SDL2)

set(SDL_LIBRARIES
                         ${LIBS_PREFIX}/lib/libSDL.dll.a 
			 ${LIBS_PREFIX}/lib/libSDLmain.a)
set(SDL_INCLUDE_DIRS ${LIBS_PREFIX}/include/SDL)

set(SDLMAIN_LIBRARY "")

set(ADDITIONAL_LIBRARIES -lssp -lc++abi -lunwind libwinmm.a)
set(ADDITIONAL_DLL_LIBRARIES -lssp -lc++abi -lunwind)
