/*
	CANON BX-1 Emulator 'eBX-1'

	Author : Takeda.Toshiya
	Date   : 2020.08.22-

	[ display ]
*/

#include "display.h"
#include "../mc6844.h"

namespace BX1 {
	
static const BYTE font[0x80][7] = {
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x04, 0x0E, 0x0E, 0x04, 0x04, 0x00, 0x04},
	{0x1B, 0x09, 0x12, 0x00, 0x00, 0x00, 0x00}, {0x0A, 0x0A, 0x1F, 0x0A, 0x1F, 0x0A, 0x0A},
	{0x04, 0x0F, 0x14, 0x0E, 0x05, 0x1E, 0x04}, {0x19, 0x1A, 0x02, 0x04, 0x08, 0x0B, 0x13},
	{0x0C, 0x12, 0x14, 0x08, 0x15, 0x12, 0x0D}, {0x0C, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00},
	{0x02, 0x04, 0x08, 0x08, 0x08, 0x04, 0x02}, {0x08, 0x04, 0x02, 0x02, 0x02, 0x04, 0x08},
	{0x04, 0x15, 0x0E, 0x04, 0x0E, 0x15, 0x04}, {0x00, 0x04, 0x04, 0x1F, 0x04, 0x04, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x0C, 0x04, 0x08}, {0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C}, {0x01, 0x02, 0x02, 0x04, 0x08, 0x08, 0x10},

	{0x0E, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0E}, {0x04, 0x0C, 0x04, 0x04, 0x04, 0x04, 0x0E},
	{0x0E, 0x11, 0x01, 0x02, 0x04, 0x08, 0x1F}, {0x0E, 0x11, 0x01, 0x0E, 0x01, 0x11, 0x0E},
	{0x02, 0x06, 0x0A, 0x12, 0x1F, 0x02, 0x02}, {0x1F, 0x10, 0x10, 0x1E, 0x01, 0x11, 0x0E},
	{0x06, 0x08, 0x10, 0x1E, 0x11, 0x11, 0x0E}, {0x1F, 0x11, 0x11, 0x02, 0x02, 0x04, 0x04},
	{0x0E, 0x11, 0x11, 0x0E, 0x11, 0x11, 0x0E}, {0x0E, 0x11, 0x11, 0x0F, 0x01, 0x11, 0x0E},
	{0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x00}, {0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x04, 0x08},
	{0x01, 0x02, 0x04, 0x08, 0x04, 0x02, 0x01}, {0x00, 0x00, 0x1F, 0x00, 0x1F, 0x00, 0x00},
	{0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10}, {0x0E, 0x11, 0x01, 0x02, 0x04, 0x00, 0x04},

	{0x0E, 0x11, 0x17, 0x15, 0x17, 0x10, 0x0E}, {0x04, 0x0A, 0x0A, 0x11, 0x1F, 0x11, 0x11},
	{0x1E, 0x11, 0x11, 0x1E, 0x11, 0x11, 0x1E}, {0x0E, 0x11, 0x10, 0x10, 0x10, 0x11, 0x0E},
	{0x1C, 0x12, 0x11, 0x11, 0x11, 0x12, 0x1C}, {0x1F, 0x10, 0x10, 0x1F, 0x10, 0x10, 0x1F},
	{0x1F, 0x10, 0x10, 0x1F, 0x10, 0x10, 0x10}, {0x0E, 0x11, 0x10, 0x17, 0x11, 0x11, 0x0E},
	{0x11, 0x11, 0x11, 0x1F, 0x11, 0x11, 0x11}, {0x0E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0E},
	{0x07, 0x02, 0x02, 0x02, 0x12, 0x12, 0x0C}, {0x11, 0x12, 0x14, 0x18, 0x14, 0x12, 0x11},
	{0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1F}, {0x11, 0x1B, 0x15, 0x15, 0x11, 0x11, 0x11},
	{0x11, 0x11, 0x19, 0x15, 0x13, 0x11, 0x11}, {0x0D, 0x12, 0x15, 0x11, 0x11, 0x11, 0x0E},

	{0x1E, 0x11, 0x11, 0x1E, 0x10, 0x10, 0x10}, {0x0E, 0x11, 0x11, 0x11, 0x15, 0x12, 0x0D},
	{0x1E, 0x11, 0x11, 0x1E, 0x14, 0x12, 0x11}, {0x0E, 0x11, 0x10, 0x0E, 0x01, 0x11, 0x0E},
	{0x1F, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04}, {0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0E},
	{0x11, 0x11, 0x11, 0x0A, 0x0A, 0x0A, 0x04}, {0x11, 0x11, 0x15, 0x15, 0x15, 0x0A, 0x0A},
	{0x11, 0x11, 0x0A, 0x04, 0x0A, 0x11, 0x11}, {0x11, 0x11, 0x0A, 0x0A, 0x04, 0x04, 0x04},
	{0x1F, 0x01, 0x02, 0x04, 0x08, 0x10, 0x1F}, {0x0E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0E},
	{0x11, 0x0A, 0x1F, 0x04, 0x1F, 0x04, 0x04}, {0x0E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0E},
	{0x04, 0x0A, 0x11, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F},

	{0x08, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x0E, 0x01, 0x0F, 0x11, 0x0F},
	{0x10, 0x10, 0x16, 0x19, 0x11, 0x19, 0x16}, {0x00, 0x00, 0x0E, 0x11, 0x10, 0x11, 0x0E},
	{0x03, 0x01, 0x0D, 0x13, 0x11, 0x13, 0x0D}, {0x00, 0x00, 0x0E, 0x11, 0x1F, 0x10, 0x0E},
	{0x06, 0x09, 0x08, 0x1E, 0x08, 0x08, 0x08}, {0x00, 0x00, 0x0F, 0x11, 0x0F, 0x01, 0x0E},
	{0x10, 0x10, 0x16, 0x19, 0x11, 0x11, 0x11}, {0x04, 0x00, 0x0C, 0x04, 0x04, 0x04, 0x0E},
	{0x02, 0x00, 0x06, 0x02, 0x02, 0x12, 0x0C}, {0x10, 0x10, 0x12, 0x14, 0x18, 0x14, 0x13},
	{0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0E}, {0x00, 0x00, 0x1A, 0x15, 0x15, 0x15, 0x15},
	{0x00, 0x00, 0x16, 0x19, 0x11, 0x11, 0x11}, {0x00, 0x00, 0x0E, 0x11, 0x11, 0x11, 0x0E},

	{0x00, 0x00, 0x1E, 0x11, 0x1E, 0x10, 0x10}, {0x00, 0x00, 0x0F, 0x11, 0x0F, 0x01, 0x01},
	{0x00, 0x00, 0x16, 0x19, 0x10, 0x10, 0x10}, {0x00, 0x00, 0x0E, 0x10, 0x0E, 0x01, 0x1E},
	{0x08, 0x08, 0x1E, 0x08, 0x08, 0x09, 0x06}, {0x00, 0x00, 0x11, 0x11, 0x11, 0x13, 0x0D},
	{0x00, 0x00, 0x11, 0x11, 0x0A, 0x0A, 0x04}, {0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x0A},
	{0x00, 0x00, 0x11, 0x0A, 0x04, 0x0A, 0x11}, {0x00, 0x00, 0x11, 0x11, 0x0F, 0x01, 0x0E},
	{0x00, 0x00, 0x1F, 0x02, 0x04, 0x08, 0x1F}, {0x03, 0x04, 0x04, 0x18, 0x04, 0x04, 0x03},
	{0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04}, {0x18, 0x04, 0x04, 0x03, 0x04, 0x04, 0x18},
	{0x09, 0x15, 0x12, 0x00, 0x00, 0x00, 0x00}, {0x15, 0x0A, 0x15, 0x0A, 0x15, 0x0A, 0x15},

	{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x04, 0x0E, 0x15, 0x04, 0x04, 0x00},
	{0x00, 0x04, 0x04, 0x15, 0x0E, 0x04, 0x00}, {0x00, 0x04, 0x02, 0x1F, 0x02, 0x04, 0x00},
	{0x00, 0x04, 0x08, 0x1F, 0x08, 0x04, 0x00}, {0x00, 0x04, 0x1F, 0x04, 0x1F, 0x04, 0x00},
	{0x01, 0x06, 0x18, 0x06, 0x01, 0x00, 0x1F}, {0x10, 0x0C, 0x03, 0x0C, 0x10, 0x00, 0x1F},
	{0x00, 0x11, 0x0A, 0x04, 0x0A, 0x11, 0x00}, {0x00, 0x04, 0x00, 0x1F, 0x00, 0x04, 0x00},
	{0x07, 0x04, 0x04, 0x04, 0x14, 0x14, 0x0C}, {0x0A, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00},
	{0x00, 0x00, 0x1F, 0x0A, 0x0A, 0x13, 0x00}, {0x1F, 0x11, 0x08, 0x04, 0x08, 0x11, 0x1F},
	{0x04, 0x04, 0x04, 0x07, 0x00, 0x00, 0x00}, {0x15, 0x0A, 0x15, 0x0A, 0x15, 0x0A, 0x15},

	{0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x0E, 0x0A, 0x0E, 0x00, 0x00},
	{0x00, 0x00, 0x0A, 0x04, 0x0A, 0x00, 0x00}, {0x00, 0x00, 0x04, 0x0E, 0x04, 0x00, 0x00},
	{0x00, 0x00, 0x04, 0x0A, 0x04, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00},
	{0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04}, {0x00, 0x00, 0x00, 0x07, 0x04, 0x04, 0x04},
	{0x00, 0x00, 0x00, 0x1C, 0x04, 0x04, 0x04}, {0x04, 0x04, 0x04, 0x1C, 0x00, 0x00, 0x00},
	{0x0A, 0x15, 0x0A, 0x15, 0x0A, 0x15, 0x0A}, {0x00, 0x01, 0x03, 0x05, 0x09, 0x1F, 0x00},
	{0x0E, 0x0A, 0x0E, 0x00, 0x00, 0x00, 0x00}, {0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00},
	{0x05, 0x08, 0x08, 0x1E, 0x08, 0x10, 0x1F}, {0x00, 0x00, 0x15, 0x0A, 0x15, 0x0A, 0x15},
};

void DISPLAY::initialize()
{
#if 0
	// test font pattern
	for(int i = 0; i < 0x80; i++) {
		for(int j = 0; j < 7; j++) {
			this->out_debug_log("%s", create_string(_T("%02X:%d\t%c%c%c%c%c\n"),
				i, j,
				font[i][j] & 0x10 ? _T('#') : _T(' '),
				font[i][j] & 0x08 ? _T('#') : _T(' '),
				font[i][j] & 0x04 ? _T('#') : _T(' '),
				font[i][j] & 0x02 ? _T('#') : _T(' '),
				font[i][j] & 0x01 ? _T('#') : _T(' ')
			));
		}
		this->out_debug_log(_T("\n"));
	}
#endif	
	// register event
	
	register_frame_event(this);
}


void DISPLAY::write_dma_io8(uint32_t addr, uint32_t data)
{
	buffer[buffer_ptr++ & 0x0f] = data;
}

void DISPLAY::event_frame()
{
	memset(buffer, 0, sizeof(buffer));
	buffer_ptr = 0;
	
	for(int i = 0; i < 16; i++) {
		d_dma->write_signal(SIG_MC6844_TX_RQ_1, 1, 1);
	}
}

void DISPLAY::draw_screen()
{
	scrntype_t cyan = RGB_COLOR(0, 255, 255);
	scrntype_t red = RGB_COLOR(255, 0, 0);
	scrntype_t back = RGB_COLOR(13, 13, 13);
	
	for(int c = 0; c < 16; c++) {
		uint8_t d = buffer[c] & 0x7f;
		
		for(int y = 0; y < 47; y++) {
			scrntype_t *dest = emu->get_screen_buffer(vm_ranges[c].y + y) + vm_ranges[c].x;
			
			for(int x = 0; x < 33; x++) {
				dest[x] = back;
			}
		}
		for(int l = 0, ll = vm_ranges[c].y; l < 7; l++, ll += 7) {
			scrntype_t *dest1 = emu->get_screen_buffer(ll + 0) + vm_ranges[c].x;
			scrntype_t *dest2 = emu->get_screen_buffer(ll + 1) + vm_ranges[c].x;
			scrntype_t *dest3 = emu->get_screen_buffer(ll + 2) + vm_ranges[c].x;
			scrntype_t *dest4 = emu->get_screen_buffer(ll + 3) + vm_ranges[c].x;
			scrntype_t *dest5 = emu->get_screen_buffer(ll + 4) + vm_ranges[c].x;
			uint8_t pattern = font[d][l];
			
			for(int dd = 0; dd < 5; dd++) {
				if(pattern & 0x10) {
					           dest1[1] = dest1[2] = dest1[3] = 
					dest2[0] = dest2[1] = dest2[2] = dest2[3] = dest2[4] = 
					dest3[0] = dest3[1] = dest3[2] = dest3[3] = dest3[4] = 
					dest4[0] = dest4[1] = dest4[2] = dest4[3] = dest4[4] = 
					           dest5[1] = dest5[2] = dest5[3] = cyan;
				}
				dest1 += 7;
				dest2 += 7;
				dest3 += 7;
				dest4 += 7;
				dest5 += 7;
				pattern <<= 1;
			}
		}
	}
	for(int c = 0; c < 3; c++) {
		scrntype_t color = (c == 0) || (c == 1 && 0) || (c == 2 && (config.dipswitch & 2)) ? red : back;
		
		for(int y = 0; y < 7; y++) {
			scrntype_t *dest = emu->get_screen_buffer(vm_ranges[c + 16].y + y) + vm_ranges[c + 16].x;
			
			dest[0] = dest[6] = (y == 0 || y == 6) ? back : color;
			dest[1] = dest[2] = dest[3] = dest[4] = dest[5] = color;
		}
	}
}

}
