/*
version 2003.03.04.1
   BMP to TOWNS System Icon Data Converter
   
   by Kasanova
*/

/*
	VXeACR쐬pBMP̃tH[}bg

	EBMP̃TCY512x544(ɑ傫Ԃɂ͖Ȃ)
	E256FBMP̂ݑΉ
	EFԍ01AȊO̐Fԍׂ͂02lϊ
	E32x32hbg̃ACR 8xc16 Ŕzu
	Eԉ̗ɂ32x32hbg̋NpACR8zu
	E[p^[][}XNp^[]2ɕׂĔzu邱
	ENpACRɃ}XNp^[͂Ȃ
	Eĉ̂悤ȍ\ɂȂ
	
	----- 64hbg -----
	[p^[0][}XN0] [p^[1][}XN1] [p^[2][}XN2] [p^[3][}XN3]EEE
	[p^[8][}XN8] [p^[9][}XN9] [p^[a][}XNa] [p^[b][}XNb]EEE
	   E
	   E
	   E
	[p^[0][p^[1][p^[2][p^[3][p^[4][p^[5][p^[6][p^[7]
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BMPHEADERSIZE    14
#define ICONMAX         128
#define ICONBOOTMAX       8
#define ICONPATTERNSIZE 256
#define ICON_W           32
#define ICON_H           32
#define ICONPITCH       (ICON_W/8)

#define ICONMATRIX_W   8
#define ICONMATRIX_H  (16+1)

char srcfile[128];
char dstfile[]  = "fmt_sys2.icn";
char dstfile2[] = "fmt_sys5.ic2";
char buffer[2048];
char iconbuffer [ ICONPATTERNSIZE*ICONMAX ]; /* 32768 */
char icon2buffer[ (ICONPATTERNSIZE/2)*ICONBOOTMAX ];
FILE *fp, *fpw, *fpw2;


void pack8dot( unsigned int bmpptr, unsigned int iconptr )
{
	int i;
	char c;
	
	c = 0;
	for( i=0 ; i<8 ; i++ )
	{
		c <<= 1;
		c |= buffer[bmpptr+i]==0 ? 1 : 0;
	}
	iconbuffer[iconptr] = c;
}


int do_convert()
{
	int readsiz, w,h, x,y,yy, pitch;
	unsigned int ptr;

	if( fread( buffer, 1, BMPHEADERSIZE, fp) != BMPHEADERSIZE )
	{
		puts( "wb_ǂݍݎs(1)\n" );
		return( 1 );
	}

	if( (buffer[0]!='B')||(buffer[1]!='M') )
	{
		puts( "BMPt@Cł͂܂\n" );
		return( 1 );
	}

	/* BMPINFOHEADER */
	readsiz = *(int*)(buffer+10);
	readsiz -= BMPHEADERSIZE;
	if( fread( buffer, 1, readsiz, fp) != readsiz )
	{
		puts( "wb_ǂݍݎs(2)\n" );
		return( 1 );
	}

	if( buffer[14] != 8 )
	{
		puts( "256FBMPȊOɂ͑ΉĂ܂\n" );
		return( 1 );
	}
	
	w = *(int*)(buffer+4);
	h = *(int*)(buffer+8);
	pitch = w;

	if( w < ICON_W*ICONMATRIX_W )
	{
		puts( "BMP̐TCY܂\n" );
		return( 1 );
	}

	if( h < ICON_H*ICONMATRIX_H )
	{
		puts( "BMP̐TCY܂\n" );
		return( 1 );
	}

	if( pitch > sizeof(buffer) )
	{
		puts( "BMP̐TCY傫܂\n" );
		return( 1 );
	}

	/* s܂ */
	/* u[gACR */
	for( yy=ICON_H-1 ; yy>=0 ; yy-- )
	{
		if( fread( buffer, 1, pitch, fp) != pitch )
		{
			puts( "ǂݍݎs\n" );
			return( 1 );
		}

		for( x=0 ; x<ICONBOOTMAX ; x++ )
		{
			ptr = ((ICONPATTERNSIZE/2)*x) + (yy*ICONPITCH);

			pack8dot( x*ICON_W   , ptr );
			pack8dot( x*ICON_W+8 , ptr+1 );
			pack8dot( x*ICON_W+16, ptr+2 );
			pack8dot( x*ICON_W+24, ptr+3 );
		}
	}
	memcpy( icon2buffer, iconbuffer, sizeof(icon2buffer) );

	/* VXeACR */
	for( y=ICONMATRIX_H-2 ; y>=0 ; y-- )
	{
		for( yy=ICON_H-1 ; yy>=0 ; yy-- )
		{
			if( fread( buffer, 1, pitch, fp) != pitch )
			{
				puts( "ǂݍݎs\n" );
				return( 1 );
			}

			for( x=0 ; x<ICONMATRIX_W ; x++ )
			{
				ptr = (ICONPATTERNSIZE*(x+(y*ICONMATRIX_W)))
					 + (yy*ICONPITCH);

				/* ACR */
				pack8dot( x*ICON_W*2   , ptr );
				pack8dot( x*ICON_W*2+8 , ptr+1 );
				pack8dot( x*ICON_W*2+16, ptr+2 );
				pack8dot( x*ICON_W*2+24, ptr+3 );

				/* }XN */
				pack8dot( x*ICON_W*2+32, ptr+128 );
				pack8dot( x*ICON_W*2+40, ptr+129 );
				pack8dot( x*ICON_W*2+48, ptr+130 );
				pack8dot( x*ICON_W*2+56, ptr+131 );
			}
		}
	}

	return( 0 );
}	


int main( int argc, char *argv[] )
{
	if( argc < 2 )
	{
		puts( "BMPt@Cw肵Ă\n" );
		return( 0 );
	}
	
	strcpy( srcfile, argv[1] );

	if( (fp=fopen(srcfile,"rb")) == NULL )
	{
		puts( "ǂݍ݃t@C̃I[vɎs܂\n" );
		return( 0 );
	}

	if( do_convert() ) puts( "ϊł܂ł\n" );
	else
	{
		/* VXeACR */
		if( (fpw=fopen(dstfile,"wb")) != NULL )
		{
			if( fwrite( iconbuffer, 1, sizeof(iconbuffer), fpw) != sizeof(iconbuffer) )
			{
				puts( "݂Ɏs܂(VXeACR)\n" );
			}
			fclose( fpw );
		} else
		{
			puts( "݃t@C̃I[vɎs܂(VXeACR)\n" );
		}

		/* u[gACR */
		if( (fpw2=fopen(dstfile2,"wb")) != NULL )
		{
			if( fwrite( icon2buffer, 1, sizeof(icon2buffer), fpw2) == sizeof(icon2buffer) )
			{
				puts( "I\n" );
			} else
			{
				puts( "݂Ɏs܂(u[gACR)\n" );
			}
			fclose( fpw2 );
		} else
		{
			puts( "݃t@C̃I[vɎs܂(u[gACR)\n" );
		}
	}
	fclose( fp );

	return( 0 );
}

