// license:BSD-3-Clause
// copyright-holders:Ville Linde, Barry Rodewald, Carl, Philip Bennett
struct X86_OPCODE {
	UINT8 opcode;
	UINT32 flags;
	void (__FASTCALL *handler16)(i386_state *cpustate);
	void (__FASTCALL *handler32)(i386_state *cpustate);
	bool lockable;
};

#define OP_I386         0x1
#define OP_FPU          0x2
#define OP_I486         0x4
#define OP_PENTIUM      0x8
#define OP_MMX          0x10
#define OP_PPRO         0x20
#define OP_SSE          0x40
#define OP_SSE2         0x80
#define OP_SSE3         0x100
#define OP_CYRIX        0x8000
#define OP_2BYTE        0x80000000
#define OP_3BYTE66      0x40000000
#define OP_3BYTEF2      0x20000000
#define OP_3BYTEF3      0x10000000
#define OP_3BYTE38      0x08000000
#define OP_3BYTE3A      0x04000000
#define OP_4BYTE3866    0x02000000
#define OP_4BYTE3A66    0x01000000
#define OP_4BYTE38F2    0x00800000
#define OP_4BYTE3AF2    0x00400000
#define OP_4BYTE38F3    0x00200000

static const X86_OPCODE x86_opcode_table[] =
{
//  Opcode      Flags                       16-bit handler                  32-bit handler
	{ 0x00,     OP_I386,                    I386OP_D(add_rm8_r8),             I386OP_D(add_rm8_r8),         true },
	{ 0x01,     OP_I386,                    I386OP_D(add_rm16_r16),           I386OP_D(add_rm32_r32),       true },
	{ 0x02,     OP_I386,                    I386OP_D(add_r8_rm8),             I386OP_D(add_r8_rm8),         false},
	{ 0x03,     OP_I386,                    I386OP_D(add_r16_rm16),           I386OP_D(add_r32_rm32),       false},
	{ 0x04,     OP_I386,                    I386OP_D(add_al_i8),              I386OP_D(add_al_i8),          false},
	{ 0x05,     OP_I386,                    I386OP_D(add_ax_i16),             I386OP_D(add_eax_i32),        false},
	{ 0x06,     OP_I386,                    I386OP_D(push_es16),              I386OP_D(push_es32),          false},
	{ 0x07,     OP_I386,                    I386OP_D(pop_es16),               I386OP_D(pop_es32),           false},
	{ 0x08,     OP_I386,                    I386OP_D(or_rm8_r8),              I386OP_D(or_rm8_r8),          true },
	{ 0x09,     OP_I386,                    I386OP_D(or_rm16_r16),            I386OP_D(or_rm32_r32),        true },
	{ 0x0A,     OP_I386,                    I386OP_D(or_r8_rm8),              I386OP_D(or_r8_rm8),          false},
	{ 0x0B,     OP_I386,                    I386OP_D(or_r16_rm16),            I386OP_D(or_r32_rm32),        false},
	{ 0x0C,     OP_I386,                    I386OP_D(or_al_i8),               I386OP_D(or_al_i8),           false},
	{ 0x0D,     OP_I386,                    I386OP_D(or_ax_i16),              I386OP_D(or_eax_i32),         false},
	{ 0x0E,     OP_I386,                    I386OP_D(push_cs16),              I386OP_D(push_cs32),          false},
	{ 0x0F,     OP_I386,                    I386OP_D(decode_two_byte),        I386OP_D(decode_two_byte),    true },
	{ 0x10,     OP_I386,                    I386OP_D(adc_rm8_r8),             I386OP_D(adc_rm8_r8),         true },
	{ 0x11,     OP_I386,                    I386OP_D(adc_rm16_r16),           I386OP_D(adc_rm32_r32),       true },
	{ 0x12,     OP_I386,                    I386OP_D(adc_r8_rm8),             I386OP_D(adc_r8_rm8),         false},
	{ 0x13,     OP_I386,                    I386OP_D(adc_r16_rm16),           I386OP_D(adc_r32_rm32),       false},
	{ 0x14,     OP_I386,                    I386OP_D(adc_al_i8),              I386OP_D(adc_al_i8),          false},
	{ 0x15,     OP_I386,                    I386OP_D(adc_ax_i16),             I386OP_D(adc_eax_i32),        false},
	{ 0x16,     OP_I386,                    I386OP_D(push_ss16),              I386OP_D(push_ss32),          false},
	{ 0x17,     OP_I386,                    I386OP_D(pop_ss16),               I386OP_D(pop_ss32),           false},
	{ 0x18,     OP_I386,                    I386OP_D(sbb_rm8_r8),             I386OP_D(sbb_rm8_r8),         true },
	{ 0x19,     OP_I386,                    I386OP_D(sbb_rm16_r16),           I386OP_D(sbb_rm32_r32),       true },
	{ 0x1A,     OP_I386,                    I386OP_D(sbb_r8_rm8),             I386OP_D(sbb_r8_rm8),         false},
	{ 0x1B,     OP_I386,                    I386OP_D(sbb_r16_rm16),           I386OP_D(sbb_r32_rm32),       false},
	{ 0x1C,     OP_I386,                    I386OP_D(sbb_al_i8),              I386OP_D(sbb_al_i8),          false},
	{ 0x1D,     OP_I386,                    I386OP_D(sbb_ax_i16),             I386OP_D(sbb_eax_i32),        false},
	{ 0x1E,     OP_I386,                    I386OP_D(push_ds16),              I386OP_D(push_ds32),          false},
	{ 0x1F,     OP_I386,                    I386OP_D(pop_ds16),               I386OP_D(pop_ds32),           false},
	{ 0x20,     OP_I386,                    I386OP_D(and_rm8_r8),             I386OP_D(and_rm8_r8),         true },
	{ 0x21,     OP_I386,                    I386OP_D(and_rm16_r16),           I386OP_D(and_rm32_r32),       true },
	{ 0x22,     OP_I386,                    I386OP_D(and_r8_rm8),             I386OP_D(and_r8_rm8),         false},
	{ 0x23,     OP_I386,                    I386OP_D(and_r16_rm16),           I386OP_D(and_r32_rm32),       false},
	{ 0x24,     OP_I386,                    I386OP_D(and_al_i8),              I386OP_D(and_al_i8),          false},
	{ 0x25,     OP_I386,                    I386OP_D(and_ax_i16),             I386OP_D(and_eax_i32),        false},
	{ 0x26,     OP_I386,                    I386OP_D(segment_ES),             I386OP_D(segment_ES),         true },
	{ 0x27,     OP_I386,                    I386OP_D(daa),                    I386OP_D(daa),                false},
	{ 0x28,     OP_I386,                    I386OP_D(sub_rm8_r8),             I386OP_D(sub_rm8_r8),         true },
	{ 0x29,     OP_I386,                    I386OP_D(sub_rm16_r16),           I386OP_D(sub_rm32_r32),       true },
	{ 0x2A,     OP_I386,                    I386OP_D(sub_r8_rm8),             I386OP_D(sub_r8_rm8),         false},
	{ 0x2B,     OP_I386,                    I386OP_D(sub_r16_rm16),           I386OP_D(sub_r32_rm32),       false},
	{ 0x2C,     OP_I386,                    I386OP_D(sub_al_i8),              I386OP_D(sub_al_i8),          false},
	{ 0x2D,     OP_I386,                    I386OP_D(sub_ax_i16),             I386OP_D(sub_eax_i32),        false},
	{ 0x2E,     OP_I386,                    I386OP_D(segment_CS),             I386OP_D(segment_CS),         true },
	{ 0x2F,     OP_I386,                    I386OP_D(das),                    I386OP_D(das),                false},
	{ 0x30,     OP_I386,                    I386OP_D(xor_rm8_r8),             I386OP_D(xor_rm8_r8),         true },
	{ 0x31,     OP_I386,                    I386OP_D(xor_rm16_r16),           I386OP_D(xor_rm32_r32),       true },
	{ 0x32,     OP_I386,                    I386OP_D(xor_r8_rm8),             I386OP_D(xor_r8_rm8),         false},
	{ 0x33,     OP_I386,                    I386OP_D(xor_r16_rm16),           I386OP_D(xor_r32_rm32),       false},
	{ 0x34,     OP_I386,                    I386OP_D(xor_al_i8),              I386OP_D(xor_al_i8),          false},
	{ 0x35,     OP_I386,                    I386OP_D(xor_ax_i16),             I386OP_D(xor_eax_i32),        false},
	{ 0x36,     OP_I386,                    I386OP_D(segment_SS),             I386OP_D(segment_SS),         true },
	{ 0x37,     OP_I386,                    I386OP_D(aaa),                    I386OP_D(aaa),                false},
	{ 0x38,     OP_I386,                    I386OP_D(cmp_rm8_r8),             I386OP_D(cmp_rm8_r8),         false},
	{ 0x39,     OP_I386,                    I386OP_D(cmp_rm16_r16),           I386OP_D(cmp_rm32_r32),       false},
	{ 0x3A,     OP_I386,                    I386OP_D(cmp_r8_rm8),             I386OP_D(cmp_r8_rm8),         false},
	{ 0x3B,     OP_I386,                    I386OP_D(cmp_r16_rm16),           I386OP_D(cmp_r32_rm32),       false},
	{ 0x3C,     OP_I386,                    I386OP_D(cmp_al_i8),              I386OP_D(cmp_al_i8),          false},
	{ 0x3D,     OP_I386,                    I386OP_D(cmp_ax_i16),             I386OP_D(cmp_eax_i32),        false},
	{ 0x3E,     OP_I386,                    I386OP_D(segment_DS),             I386OP_D(segment_DS),         true },
	{ 0x3F,     OP_I386,                    I386OP_D(aas),                    I386OP_D(aas),                false},
	{ 0x40,     OP_I386,                    I386OP_D(inc_ax),                 I386OP_D(inc_eax),            false},
	{ 0x41,     OP_I386,                    I386OP_D(inc_cx),                 I386OP_D(inc_ecx),            false},
	{ 0x42,     OP_I386,                    I386OP_D(inc_dx),                 I386OP_D(inc_edx),            false},
	{ 0x43,     OP_I386,                    I386OP_D(inc_bx),                 I386OP_D(inc_ebx),            false},
	{ 0x44,     OP_I386,                    I386OP_D(inc_sp),                 I386OP_D(inc_esp),            false},
	{ 0x45,     OP_I386,                    I386OP_D(inc_bp),                 I386OP_D(inc_ebp),            false},
	{ 0x46,     OP_I386,                    I386OP_D(inc_si),                 I386OP_D(inc_esi),            false},
	{ 0x47,     OP_I386,                    I386OP_D(inc_di),                 I386OP_D(inc_edi),            false},
	{ 0x48,     OP_I386,                    I386OP_D(dec_ax),                 I386OP_D(dec_eax),            false},
	{ 0x49,     OP_I386,                    I386OP_D(dec_cx),                 I386OP_D(dec_ecx),            false},
	{ 0x4A,     OP_I386,                    I386OP_D(dec_dx),                 I386OP_D(dec_edx),            false},
	{ 0x4B,     OP_I386,                    I386OP_D(dec_bx),                 I386OP_D(dec_ebx),            false},
	{ 0x4C,     OP_I386,                    I386OP_D(dec_sp),                 I386OP_D(dec_esp),            false},
	{ 0x4D,     OP_I386,                    I386OP_D(dec_bp),                 I386OP_D(dec_ebp),            false},
	{ 0x4E,     OP_I386,                    I386OP_D(dec_si),                 I386OP_D(dec_esi),            false},
	{ 0x4F,     OP_I386,                    I386OP_D(dec_di),                 I386OP_D(dec_edi),            false},
	{ 0x50,     OP_I386,                    I386OP_D(push_ax),                I386OP_D(push_eax),           false},
	{ 0x51,     OP_I386,                    I386OP_D(push_cx),                I386OP_D(push_ecx),           false},
	{ 0x52,     OP_I386,                    I386OP_D(push_dx),                I386OP_D(push_edx),           false},
	{ 0x53,     OP_I386,                    I386OP_D(push_bx),                I386OP_D(push_ebx),           false},
	{ 0x54,     OP_I386,                    I386OP_D(push_sp),                I386OP_D(push_esp),           false},
	{ 0x55,     OP_I386,                    I386OP_D(push_bp),                I386OP_D(push_ebp),           false},
	{ 0x56,     OP_I386,                    I386OP_D(push_si),                I386OP_D(push_esi),           false},
	{ 0x57,     OP_I386,                    I386OP_D(push_di),                I386OP_D(push_edi),           false},
	{ 0x58,     OP_I386,                    I386OP_D(pop_ax),                 I386OP_D(pop_eax),            false},
	{ 0x59,     OP_I386,                    I386OP_D(pop_cx),                 I386OP_D(pop_ecx),            false},
	{ 0x5A,     OP_I386,                    I386OP_D(pop_dx),                 I386OP_D(pop_edx),            false},
	{ 0x5B,     OP_I386,                    I386OP_D(pop_bx),                 I386OP_D(pop_ebx),            false},
	{ 0x5C,     OP_I386,                    I386OP_D(pop_sp),                 I386OP_D(pop_esp),            false},
	{ 0x5D,     OP_I386,                    I386OP_D(pop_bp),                 I386OP_D(pop_ebp),            false},
	{ 0x5E,     OP_I386,                    I386OP_D(pop_si),                 I386OP_D(pop_esi),            false},
	{ 0x5F,     OP_I386,                    I386OP_D(pop_di),                 I386OP_D(pop_edi),            false},
	{ 0x60,     OP_I386,                    I386OP_D(pusha),                  I386OP_D(pushad),             false},
	{ 0x61,     OP_I386,                    I386OP_D(popa),                   I386OP_D(popad),              false},
	{ 0x62,     OP_I386,                    I386OP_D(bound_r16_m16_m16),      I386OP_D(bound_r32_m32_m32),  false},
	{ 0x63,     OP_I386,                    I386OP_D(arpl),                   I386OP_D(arpl),               false},
	{ 0x64,     OP_I386,                    I386OP_D(segment_FS),             I386OP_D(segment_FS),         true },
	{ 0x65,     OP_I386,                    I386OP_D(segment_GS),             I386OP_D(segment_GS),         true },
	{ 0x66,     OP_I386,                    I386OP_D(operand_size),           I386OP_D(operand_size),       true },
	{ 0x67,     OP_I386,                    I386OP_D(address_size),           I386OP_D(address_size),       true },
	{ 0x68,     OP_I386,                    I386OP_D(push_i16),               I386OP_D(push_i32),           false},
	{ 0x69,     OP_I386,                    I386OP_D(imul_r16_rm16_i16),      I386OP_D(imul_r32_rm32_i32),  false},
	{ 0x6A,     OP_I386,                    I386OP_D(push_i8),                I386OP_D(push_i8),            false},
	{ 0x6B,     OP_I386,                    I386OP_D(imul_r16_rm16_i8),       I386OP_D(imul_r32_rm32_i8),   false},
	{ 0x6C,     OP_I386,                    I386OP_D(insb),                   I386OP_D(insb),               false},
	{ 0x6D,     OP_I386,                    I386OP_D(insw),                   I386OP_D(insd),               false},
	{ 0x6E,     OP_I386,                    I386OP_D(outsb),                  I386OP_D(outsb),              false},
	{ 0x6F,     OP_I386,                    I386OP_D(outsw),                  I386OP_D(outsd),              false},
	{ 0x70,     OP_I386,                    I386OP_D(jo_rel8),                I386OP_D(jo_rel8),            false},
	{ 0x71,     OP_I386,                    I386OP_D(jno_rel8),               I386OP_D(jno_rel8),           false},
	{ 0x72,     OP_I386,                    I386OP_D(jc_rel8),                I386OP_D(jc_rel8),            false},
	{ 0x73,     OP_I386,                    I386OP_D(jnc_rel8),               I386OP_D(jnc_rel8),           false},
	{ 0x74,     OP_I386,                    I386OP_D(jz_rel8),                I386OP_D(jz_rel8),            false},
	{ 0x75,     OP_I386,                    I386OP_D(jnz_rel8),               I386OP_D(jnz_rel8),           false},
	{ 0x76,     OP_I386,                    I386OP_D(jbe_rel8),               I386OP_D(jbe_rel8),           false},
	{ 0x77,     OP_I386,                    I386OP_D(ja_rel8),                I386OP_D(ja_rel8),            false},
	{ 0x78,     OP_I386,                    I386OP_D(js_rel8),                I386OP_D(js_rel8),            false},
	{ 0x79,     OP_I386,                    I386OP_D(jns_rel8),               I386OP_D(jns_rel8),           false},
	{ 0x7A,     OP_I386,                    I386OP_D(jp_rel8),                I386OP_D(jp_rel8),            false},
	{ 0x7B,     OP_I386,                    I386OP_D(jnp_rel8),               I386OP_D(jnp_rel8),           false},
	{ 0x7C,     OP_I386,                    I386OP_D(jl_rel8),                I386OP_D(jl_rel8),            false},
	{ 0x7D,     OP_I386,                    I386OP_D(jge_rel8),               I386OP_D(jge_rel8),           false},
	{ 0x7E,     OP_I386,                    I386OP_D(jle_rel8),               I386OP_D(jle_rel8),           false},
	{ 0x7F,     OP_I386,                    I386OP_D(jg_rel8),                I386OP_D(jg_rel8),            false},
	{ 0x80,     OP_I386,                    I386OP_D(group80_8),              I386OP_D(group80_8),          true },
	{ 0x81,     OP_I386,                    I386OP_D(group81_16),             I386OP_D(group81_32),         true },
	{ 0x82,     OP_I386,                    I386OP_D(group80_8),              I386OP_D(group80_8),          true },
	{ 0x83,     OP_I386,                    I386OP_D(group83_16),             I386OP_D(group83_32),         true },
	{ 0x84,     OP_I386,                    I386OP_D(test_rm8_r8),            I386OP_D(test_rm8_r8),        false},
	{ 0x85,     OP_I386,                    I386OP_D(test_rm16_r16),          I386OP_D(test_rm32_r32),      false},
	{ 0x86,     OP_I386,                    I386OP_D(xchg_r8_rm8),            I386OP_D(xchg_r8_rm8),        true },
	{ 0x87,     OP_I386,                    I386OP_D(xchg_r16_rm16),          I386OP_D(xchg_r32_rm32),      true },
	{ 0x88,     OP_I386,                    I386OP_D(mov_rm8_r8),             I386OP_D(mov_rm8_r8),         false},
	{ 0x89,     OP_I386,                    I386OP_D(mov_rm16_r16),           I386OP_D(mov_rm32_r32),       false},
	{ 0x8A,     OP_I386,                    I386OP_D(mov_r8_rm8),             I386OP_D(mov_r8_rm8),         false},
	{ 0x8B,     OP_I386,                    I386OP_D(mov_r16_rm16),           I386OP_D(mov_r32_rm32),       false},
	{ 0x8C,     OP_I386,                    I386OP_D(mov_rm16_sreg),          I386OP_D(mov_rm16_sreg),      false},
	{ 0x8D,     OP_I386,                    I386OP_D(lea16),                  I386OP_D(lea32),              false},
	{ 0x8E,     OP_I386,                    I386OP_D(mov_sreg_rm16),          I386OP_D(mov_sreg_rm16),      false},
	{ 0x8F,     OP_I386,                    I386OP_D(pop_rm16),               I386OP_D(pop_rm32),           false},
	{ 0x90,     OP_I386,                    I386OP_D(nop),                    I386OP_D(nop),                false},
	{ 0x91,     OP_I386,                    I386OP_D(xchg_ax_cx),             I386OP_D(xchg_eax_ecx),       false},
	{ 0x92,     OP_I386,                    I386OP_D(xchg_ax_dx),             I386OP_D(xchg_eax_edx),       false},
	{ 0x93,     OP_I386,                    I386OP_D(xchg_ax_bx),             I386OP_D(xchg_eax_ebx),       false},
	{ 0x94,     OP_I386,                    I386OP_D(xchg_ax_sp),             I386OP_D(xchg_eax_esp),       false},
	{ 0x95,     OP_I386,                    I386OP_D(xchg_ax_bp),             I386OP_D(xchg_eax_ebp),       false},
	{ 0x96,     OP_I386,                    I386OP_D(xchg_ax_si),             I386OP_D(xchg_eax_esi),       false},
	{ 0x97,     OP_I386,                    I386OP_D(xchg_ax_di),             I386OP_D(xchg_eax_edi),       false},
	{ 0x98,     OP_I386,                    I386OP_D(cbw),                    I386OP_D(cwde),               false},
	{ 0x99,     OP_I386,                    I386OP_D(cwd),                    I386OP_D(cdq),                false},
	{ 0x9A,     OP_I386,                    I386OP_D(call_abs16),             I386OP_D(call_abs32),         false},
	{ 0x9B,     OP_I386,                    I386OP_D(wait),                   I386OP_D(wait),               false},
	{ 0x9C,     OP_I386,                    I386OP_D(pushf),                  I386OP_D(pushfd),             false},
	{ 0x9D,     OP_I386,                    I386OP_D(popf),                   I386OP_D(popfd),              false},
	{ 0x9E,     OP_I386,                    I386OP_D(sahf),                   I386OP_D(sahf),               false},
	{ 0x9F,     OP_I386,                    I386OP_D(lahf),                   I386OP_D(lahf),               false},
	{ 0xA0,     OP_I386,                    I386OP_D(mov_al_m8),              I386OP_D(mov_al_m8),          false},
	{ 0xA1,     OP_I386,                    I386OP_D(mov_ax_m16),             I386OP_D(mov_eax_m32),        false},
	{ 0xA2,     OP_I386,                    I386OP_D(mov_m8_al),              I386OP_D(mov_m8_al),          false},
	{ 0xA3,     OP_I386,                    I386OP_D(mov_m16_ax),             I386OP_D(mov_m32_eax),        false},
	{ 0xA4,     OP_I386,                    I386OP_D(movsb),                  I386OP_D(movsb),              false},
	{ 0xA5,     OP_I386,                    I386OP_D(movsw),                  I386OP_D(movsd),              false},
	{ 0xA6,     OP_I386,                    I386OP_D(cmpsb),                  I386OP_D(cmpsb),              false},
	{ 0xA7,     OP_I386,                    I386OP_D(cmpsw),                  I386OP_D(cmpsd),              false},
	{ 0xA8,     OP_I386,                    I386OP_D(test_al_i8),             I386OP_D(test_al_i8),         false},
	{ 0xA9,     OP_I386,                    I386OP_D(test_ax_i16),            I386OP_D(test_eax_i32),       false},
	{ 0xAA,     OP_I386,                    I386OP_D(stosb),                  I386OP_D(stosb),              false},
	{ 0xAB,     OP_I386,                    I386OP_D(stosw),                  I386OP_D(stosd),              false},
	{ 0xAC,     OP_I386,                    I386OP_D(lodsb),                  I386OP_D(lodsb),              false},
	{ 0xAD,     OP_I386,                    I386OP_D(lodsw),                  I386OP_D(lodsd),              false},
	{ 0xAE,     OP_I386,                    I386OP_D(scasb),                  I386OP_D(scasb),              false},
	{ 0xAF,     OP_I386,                    I386OP_D(scasw),                  I386OP_D(scasd),              false},
	{ 0xB0,     OP_I386,                    I386OP_D(mov_al_i8),              I386OP_D(mov_al_i8),          false},
	{ 0xB1,     OP_I386,                    I386OP_D(mov_cl_i8),              I386OP_D(mov_cl_i8),          false},
	{ 0xB2,     OP_I386,                    I386OP_D(mov_dl_i8),              I386OP_D(mov_dl_i8),          false},
	{ 0xB3,     OP_I386,                    I386OP_D(mov_bl_i8),              I386OP_D(mov_bl_i8),          false},
	{ 0xB4,     OP_I386,                    I386OP_D(mov_ah_i8),              I386OP_D(mov_ah_i8),          false},
	{ 0xB5,     OP_I386,                    I386OP_D(mov_ch_i8),              I386OP_D(mov_ch_i8),          false},
	{ 0xB6,     OP_I386,                    I386OP_D(mov_dh_i8),              I386OP_D(mov_dh_i8),          false},
	{ 0xB7,     OP_I386,                    I386OP_D(mov_bh_i8),              I386OP_D(mov_bh_i8),          false},
	{ 0xB8,     OP_I386,                    I386OP_D(mov_ax_i16),             I386OP_D(mov_eax_i32),        false},
	{ 0xB9,     OP_I386,                    I386OP_D(mov_cx_i16),             I386OP_D(mov_ecx_i32),        false},
	{ 0xBA,     OP_I386,                    I386OP_D(mov_dx_i16),             I386OP_D(mov_edx_i32),        false},
	{ 0xBB,     OP_I386,                    I386OP_D(mov_bx_i16),             I386OP_D(mov_ebx_i32),        false},
	{ 0xBC,     OP_I386,                    I386OP_D(mov_sp_i16),             I386OP_D(mov_esp_i32),        false},
	{ 0xBD,     OP_I386,                    I386OP_D(mov_bp_i16),             I386OP_D(mov_ebp_i32),        false},
	{ 0xBE,     OP_I386,                    I386OP_D(mov_si_i16),             I386OP_D(mov_esi_i32),        false},
	{ 0xBF,     OP_I386,                    I386OP_D(mov_di_i16),             I386OP_D(mov_edi_i32),        false},
	{ 0xC0,     OP_I386,                    I386OP_D(groupC0_8),              I386OP_D(groupC0_8),          false},
	{ 0xC1,     OP_I386,                    I386OP_D(groupC1_16),             I386OP_D(groupC1_32),         false},
	{ 0xC2,     OP_I386,                    I386OP_D(ret_near16_i16),         I386OP_D(ret_near32_i16),     false},
	{ 0xC3,     OP_I386,                    I386OP_D(ret_near16),             I386OP_D(ret_near32),         false},
	{ 0xC4,     OP_I386,                    I386OP_D(les16),                  I386OP_D(les32),              false},
	{ 0xC5,     OP_I386,                    I386OP_D(lds16),                  I386OP_D(lds32),              false},
	{ 0xC6,     OP_I386,                    I386OP_D(mov_rm8_i8),             I386OP_D(mov_rm8_i8),         false},
	{ 0xC7,     OP_I386,                    I386OP_D(mov_rm16_i16),           I386OP_D(mov_rm32_i32),       false},
	{ 0xC8,     OP_I386,                    I386OP_D(enter16),                I386OP_D(enter32),            false},
	{ 0xC9,     OP_I386,                    I386OP_D(leave16),                I386OP_D(leave32),            false},
	{ 0xCA,     OP_I386,                    I386OP_D(retf_i16),               I386OP_D(retf_i32),           false},
	{ 0xCB,     OP_I386,                    I386OP_D(retf16),                 I386OP_D(retf32),             false},
	{ 0xCC,     OP_I386,                    I386OP_D(int3),                   I386OP_D(int3),               false},
	{ 0xCD,     OP_I386,                    I386OP_D(int_16),                 I386OP_D(int_32),             false},
	{ 0xCE,     OP_I386,                    I386OP_D(into),                   I386OP_D(into),               false},
	{ 0xCF,     OP_I386,                    I386OP_D(iret16),                 I386OP_D(iret32),             false},
	{ 0xD0,     OP_I386,                    I386OP_D(groupD0_8),              I386OP_D(groupD0_8),          false},
	{ 0xD1,     OP_I386,                    I386OP_D(groupD1_16),             I386OP_D(groupD1_32),         false},
	{ 0xD2,     OP_I386,                    I386OP_D(groupD2_8),              I386OP_D(groupD2_8),          false},
	{ 0xD3,     OP_I386,                    I386OP_D(groupD3_16),             I386OP_D(groupD3_32),         false},
	{ 0xD4,     OP_I386,                    I386OP_D(aam),                    I386OP_D(aam),                false},
	{ 0xD5,     OP_I386,                    I386OP_D(aad),                    I386OP_D(aad),                false},
	{ 0xD6,     OP_I386,                    I386OP_D(setalc),                 I386OP_D(setalc),             false},
	{ 0xD7,     OP_I386,                    I386OP_D(xlat),                   I386OP_D(xlat),               false},
	{ 0xD8,     OP_I386,                    I386OP_D(escape),                 I386OP_D(escape),             false},
	{ 0xD9,     OP_I386,                    I386OP_D(escape),                 I386OP_D(escape),             false},
	{ 0xDA,     OP_I386,                    I386OP_D(escape),                 I386OP_D(escape),             false},
	{ 0xDB,     OP_I386,                    I386OP_D(escape),                 I386OP_D(escape),             false},
	{ 0xDC,     OP_I386,                    I386OP_D(escape),                 I386OP_D(escape),             false},
	{ 0xDD,     OP_I386,                    I386OP_D(escape),                 I386OP_D(escape),             false},
	{ 0xDE,     OP_I386,                    I386OP_D(escape),                 I386OP_D(escape),             false},
	{ 0xDF,     OP_I386,                    I386OP_D(escape),                 I386OP_D(escape),             false},
	{ 0xD8,     OP_FPU,                     I386OP_D(x87_group_d8),           I386OP_D(x87_group_d8),       false},
	{ 0xD9,     OP_FPU,                     I386OP_D(x87_group_d9),           I386OP_D(x87_group_d9),       false},
	{ 0xDA,     OP_FPU,                     I386OP_D(x87_group_da),           I386OP_D(x87_group_da),       false},
	{ 0xDB,     OP_FPU,                     I386OP_D(x87_group_db),           I386OP_D(x87_group_db),       false},
	{ 0xDC,     OP_FPU,                     I386OP_D(x87_group_dc),           I386OP_D(x87_group_dc),       false},
	{ 0xDD,     OP_FPU,                     I386OP_D(x87_group_dd),           I386OP_D(x87_group_dd),       false},
	{ 0xDE,     OP_FPU,                     I386OP_D(x87_group_de),           I386OP_D(x87_group_de),       false},
	{ 0xDF,     OP_FPU,                     I386OP_D(x87_group_df),           I386OP_D(x87_group_df),       false},
	{ 0xE0,     OP_I386,                    I386OP_D(loopne16),               I386OP_D(loopne32),           false},
	{ 0xE1,     OP_I386,                    I386OP_D(loopz16),                I386OP_D(loopz32),            false},
	{ 0xE2,     OP_I386,                    I386OP_D(loop16),                 I386OP_D(loop32),             false},
	{ 0xE3,     OP_I386,                    I386OP_D(jcxz16),                 I386OP_D(jcxz32),             false},
	{ 0xE4,     OP_I386,                    I386OP_D(in_al_i8),               I386OP_D(in_al_i8),           false},
	{ 0xE5,     OP_I386,                    I386OP_D(in_ax_i8),               I386OP_D(in_eax_i8),          false},
	{ 0xE6,     OP_I386,                    I386OP_D(out_al_i8),              I386OP_D(out_al_i8),          false},
	{ 0xE7,     OP_I386,                    I386OP_D(out_ax_i8),              I386OP_D(out_eax_i8),         false},
	{ 0xE8,     OP_I386,                    I386OP_D(call_rel16),             I386OP_D(call_rel32),         false},
	{ 0xE9,     OP_I386,                    I386OP_D(jmp_rel16),              I386OP_D(jmp_rel32),          false},
	{ 0xEA,     OP_I386,                    I386OP_D(jmp_abs16),              I386OP_D(jmp_abs32),          false},
	{ 0xEB,     OP_I386,                    I386OP_D(jmp_rel8),               I386OP_D(jmp_rel8),           false},
	{ 0xEC,     OP_I386,                    I386OP_D(in_al_dx),               I386OP_D(in_al_dx),           false},
	{ 0xED,     OP_I386,                    I386OP_D(in_ax_dx),               I386OP_D(in_eax_dx),          false},
	{ 0xEE,     OP_I386,                    I386OP_D(out_al_dx),              I386OP_D(out_al_dx),          false},
	{ 0xEF,     OP_I386,                    I386OP_D(out_ax_dx),              I386OP_D(out_eax_dx),         false},
	{ 0xF0,     OP_I386,                    I386OP_D(lock),                   I386OP_D(lock),               false},
	{ 0xF1,     OP_I386,                    I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF2,     OP_I386,                    I386OP_D(repne),                  I386OP_D(repne),              false},
	{ 0xF3,     OP_I386,                    I386OP_D(rep),                    I386OP_D(rep),                false},
	{ 0xF4,     OP_I386,                    I386OP_D(hlt),                    I386OP_D(hlt),                false},
	{ 0xF5,     OP_I386,                    I386OP_D(cmc),                    I386OP_D(cmc),                false},
	{ 0xF6,     OP_I386,                    I386OP_D(groupF6_8),              I386OP_D(groupF6_8),          true },
	{ 0xF7,     OP_I386,                    I386OP_D(groupF7_16),             I386OP_D(groupF7_32),         true },
	{ 0xF8,     OP_I386,                    I386OP_D(clc),                    I386OP_D(clc),                false},
	{ 0xF9,     OP_I386,                    I386OP_D(stc),                    I386OP_D(stc),                false},
	{ 0xFA,     OP_I386,                    I386OP_D(cli),                    I386OP_D(cli),                false},
	{ 0xFB,     OP_I386,                    I386OP_D(sti),                    I386OP_D(sti),                false},
	{ 0xFC,     OP_I386,                    I386OP_D(cld),                    I386OP_D(cld),                false},
	{ 0xFD,     OP_I386,                    I386OP_D(std),                    I386OP_D(std),                false},
	{ 0xFE,     OP_I386,                    I386OP_D(groupFE_8),              I386OP_D(groupFE_8),          true },
	{ 0xFF,     OP_I386,                    I386OP_D(groupFF_16),             I386OP_D(groupFF_32),         true },
	/* 0F ?? */
	{ 0x00,     OP_2BYTE|OP_I386,           I386OP_D(group0F00_16),           I386OP_D(group0F00_32),       false},
	{ 0x01,     OP_2BYTE|OP_I386,           I386OP_D(group0F01_16),           I386OP_D(group0F01_32),       false},
	{ 0x01,     OP_2BYTE|OP_I486,           I486OP_D(group0F01_16),           I486OP_D(group0F01_32),       false},
	{ 0x02,     OP_2BYTE|OP_I386,           I386OP_D(lar_r16_rm16),           I386OP_D(lar_r32_rm32),       false},
	{ 0x03,     OP_2BYTE|OP_I386,           I386OP_D(lsl_r16_rm16),           I386OP_D(lsl_r32_rm32),       false},
	{ 0x06,     OP_2BYTE|OP_I386,           I386OP_D(clts),                   I386OP_D(clts),               false},
	{ 0x07,     OP_2BYTE|OP_I386,           I386OP_D(loadall),                I386OP_D(loadall),            false},
	{ 0x07,     OP_2BYTE|OP_I486,           I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x08,     OP_2BYTE|OP_I486,           I486OP_D(invd),                   I486OP_D(invd),               false},
	{ 0x09,     OP_2BYTE|OP_I486,           I486OP_D(wbinvd),                 I486OP_D(wbinvd),             false},
	{ 0x0B,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(ud2),                 PENTIUMOP_D(ud2),             false},
	{ 0x10,     OP_2BYTE|OP_SSE,            SSEOP_D(movups_r128_rm128),       SSEOP_D(movups_r128_rm128),   false},
	{ 0x11,     OP_2BYTE|OP_SSE,            SSEOP_D(movups_rm128_r128),       SSEOP_D(movups_rm128_r128),   false},
	{ 0x12,     OP_2BYTE|OP_SSE,            SSEOP_D(movlps_r128_m64),         SSEOP_D(movlps_r128_m64),     false},
	{ 0x13,     OP_2BYTE|OP_SSE,            SSEOP_D(movlps_m64_r128),         SSEOP_D(movlps_m64_r128),     false},
	{ 0x14,     OP_2BYTE|OP_SSE,            SSEOP_D(unpcklps_r128_rm128),     SSEOP_D(unpcklps_r128_rm128), false},
	{ 0x15,     OP_2BYTE|OP_SSE,            SSEOP_D(unpckhps_r128_rm128),     SSEOP_D(unpckhps_r128_rm128), false},
	{ 0x16,     OP_2BYTE|OP_SSE,            SSEOP_D(movhps_r128_m64),         SSEOP_D(movhps_r128_m64),     false},
	{ 0x17,     OP_2BYTE|OP_SSE,            SSEOP_D(movhps_m64_r128),         SSEOP_D(movhps_m64_r128),     false},
	{ 0x18,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(prefetch_m8),         PENTIUMOP_D(prefetch_m8),     false},
	{ 0x20,     OP_2BYTE|OP_I386,           I386OP_D(mov_r32_cr),             I386OP_D(mov_r32_cr),         false},
	{ 0x21,     OP_2BYTE|OP_I386,           I386OP_D(mov_r32_dr),             I386OP_D(mov_r32_dr),         false},
	{ 0x22,     OP_2BYTE|OP_I386,           I386OP_D(mov_cr_r32),             I386OP_D(mov_cr_r32),         false},
	{ 0x22,     OP_2BYTE|OP_I486,           I486OP_D(mov_cr_r32),             I486OP_D(mov_cr_r32),         false},
	{ 0x23,     OP_2BYTE|OP_I386,           I386OP_D(mov_dr_r32),             I386OP_D(mov_dr_r32),         false},
	{ 0x24,     OP_2BYTE|OP_I386,           I386OP_D(mov_r32_tr),             I386OP_D(mov_r32_tr),         false},
	{ 0x26,     OP_2BYTE|OP_I386,           I386OP_D(mov_tr_r32),             I386OP_D(mov_tr_r32),         false},
	{ 0x28,     OP_2BYTE|OP_SSE,            SSEOP_D(movaps_r128_rm128),       SSEOP_D(movaps_r128_rm128),   false},
	{ 0x29,     OP_2BYTE|OP_SSE,            SSEOP_D(movaps_rm128_r128),       SSEOP_D(movaps_rm128_r128),   false},
	{ 0x2a,     OP_2BYTE|OP_SSE,            SSEOP_D(cvtpi2ps_r128_rm64),      SSEOP_D(cvtpi2ps_r128_rm64),  false},
	{ 0x2b,     OP_2BYTE|OP_SSE,            SSEOP_D(movntps_m128_r128),       SSEOP_D(movntps_m128_r128),   false},
	{ 0x2c,     OP_2BYTE|OP_SSE,            SSEOP_D(cvttps2pi_r64_r128m64),   SSEOP_D(cvttps2pi_r64_r128m64),false},
	{ 0x2d,     OP_2BYTE|OP_SSE,            SSEOP_D(cvtps2pi_r64_r128m64),    SSEOP_D(cvtps2pi_r64_r128m64),false},
	{ 0x2e,     OP_2BYTE|OP_SSE,            SSEOP_D(ucomiss_r128_r128m32),    SSEOP_D(ucomiss_r128_r128m32),false},
	{ 0x2f,     OP_2BYTE|OP_SSE,            SSEOP_D(comiss_r128_r128m32),     SSEOP_D(comiss_r128_r128m32), false},
	{ 0x30,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(wrmsr),               PENTIUMOP_D(wrmsr),           false},
	{ 0x31,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(rdtsc),               PENTIUMOP_D(rdtsc),           false},
	{ 0x32,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(rdmsr),               PENTIUMOP_D(rdmsr),           false},
	{ 0x38,     OP_2BYTE|OP_PENTIUM,        I386OP_D(decode_three_byte38),    I386OP_D(decode_three_byte38),false},
	{ 0x3A,     OP_2BYTE|OP_PENTIUM,        I386OP_D(decode_three_byte3a),    I386OP_D(decode_three_byte3a),false},
	{ 0x3A,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_special),          I386OP_D(cyrix_special),      false},
	{ 0x3B,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_special),          I386OP_D(cyrix_special),      false},
	{ 0x3C,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_special),          I386OP_D(cyrix_special),      false},
	{ 0x3D,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_special),          I386OP_D(cyrix_special),      false},
	{ 0x40,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovo_r16_rm16),      PENTIUMOP_D(cmovo_r32_rm32),  false},
	{ 0x41,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovno_r16_rm16),     PENTIUMOP_D(cmovno_r32_rm32), false},
	{ 0x42,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovb_r16_rm16),      PENTIUMOP_D(cmovb_r32_rm32),  false},
	{ 0x43,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovae_r16_rm16),     PENTIUMOP_D(cmovae_r32_rm32), false},
	{ 0x44,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmove_r16_rm16),      PENTIUMOP_D(cmove_r32_rm32),  false},
	{ 0x45,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovne_r16_rm16),     PENTIUMOP_D(cmovne_r32_rm32), false},
	{ 0x46,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovbe_r16_rm16),     PENTIUMOP_D(cmovbe_r32_rm32), false},
	{ 0x47,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmova_r16_rm16),      PENTIUMOP_D(cmova_r32_rm32),  false},
	{ 0x48,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovs_r16_rm16),      PENTIUMOP_D(cmovs_r32_rm32),  false},
	{ 0x49,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovns_r16_rm16),     PENTIUMOP_D(cmovns_r32_rm32), false},
	{ 0x4a,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovp_r16_rm16),      PENTIUMOP_D(cmovp_r32_rm32),  false},
	{ 0x4b,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovnp_r16_rm16),     PENTIUMOP_D(cmovnp_r32_rm32), false},
	{ 0x4c,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovl_r16_rm16),      PENTIUMOP_D(cmovl_r32_rm32),  false},
	{ 0x4d,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovge_r16_rm16),     PENTIUMOP_D(cmovge_r32_rm32), false},
	{ 0x4e,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovle_r16_rm16),     PENTIUMOP_D(cmovle_r32_rm32), false},
	{ 0x4f,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmovg_r16_rm16),      PENTIUMOP_D(cmovg_r32_rm32),  false},
	{ 0x50,     OP_2BYTE|OP_SSE,            SSEOP_D(movmskps_r16_r128),       SSEOP_D(movmskps_r32_r128),   false},
	{ 0x51,     OP_2BYTE|OP_SSE,            SSEOP_D(sqrtps_r128_rm128),       SSEOP_D(sqrtps_r128_rm128),   false},
	{ 0x52,     OP_2BYTE|OP_SSE,            SSEOP_D(rsqrtps_r128_rm128),      SSEOP_D(rsqrtps_r128_rm128),  false},
	{ 0x53,     OP_2BYTE|OP_SSE,            SSEOP_D(rcpps_r128_rm128),        SSEOP_D(rcpps_r128_rm128),    false},
	{ 0x54,     OP_2BYTE|OP_SSE,            SSEOP_D(andps_r128_rm128),        SSEOP_D(andps_r128_rm128),    false},
	{ 0x55,     OP_2BYTE|OP_SSE,            SSEOP_D(andnps_r128_rm128),       SSEOP_D(andnps_r128_rm128),   false},
	{ 0x56,     OP_2BYTE|OP_SSE,            SSEOP_D(orps_r128_rm128),         SSEOP_D(orps_r128_rm128),     false},
	{ 0x57,     OP_2BYTE|OP_SSE,            SSEOP_D(xorps),                   SSEOP_D(xorps),               false},
	{ 0x58,     OP_2BYTE|OP_SSE,            SSEOP_D(addps),                   SSEOP_D(addps),               false},
	{ 0x59,     OP_2BYTE|OP_SSE,            SSEOP_D(mulps),                   SSEOP_D(mulps),               false},
	{ 0x5a,     OP_2BYTE|OP_SSE,            SSEOP_D(cvtps2pd_r128_r128m64),   SSEOP_D(cvtps2pd_r128_r128m64),false},
	{ 0x5b,     OP_2BYTE|OP_SSE,            SSEOP_D(cvtdq2ps_r128_rm128),     SSEOP_D(cvtdq2ps_r128_rm128), false},
	{ 0x5c,     OP_2BYTE|OP_SSE,            SSEOP_D(subps),                   SSEOP_D(subps),               false},
	{ 0x5d,     OP_2BYTE|OP_SSE,            SSEOP_D(minps),                   SSEOP_D(minps),               false},
	{ 0x5e,     OP_2BYTE|OP_SSE,            SSEOP_D(divps),                   SSEOP_D(divps),               false},
	{ 0x5f,     OP_2BYTE|OP_SSE,            SSEOP_D(maxps),                   SSEOP_D(maxps),               false},
	{ 0x60,     OP_2BYTE|OP_MMX,            MMXOP_D(punpcklbw_r64_r64m32),    MMXOP_D(punpcklbw_r64_r64m32),false},
	{ 0x61,     OP_2BYTE|OP_MMX,            MMXOP_D(punpcklwd_r64_r64m32),    MMXOP_D(punpcklwd_r64_r64m32),false},
	{ 0x62,     OP_2BYTE|OP_MMX,            MMXOP_D(punpckldq_r64_r64m32),    MMXOP_D(punpckldq_r64_r64m32),false},
	{ 0x63,     OP_2BYTE|OP_MMX,            MMXOP_D(packsswb_r64_rm64),       MMXOP_D(packsswb_r64_rm64),   false},
	{ 0x64,     OP_2BYTE|OP_MMX,            MMXOP_D(pcmpgtb_r64_rm64),        MMXOP_D(pcmpgtb_r64_rm64),    false},
	{ 0x65,     OP_2BYTE|OP_MMX,            MMXOP_D(pcmpgtw_r64_rm64),        MMXOP_D(pcmpgtw_r64_rm64),    false},
	{ 0x66,     OP_2BYTE|OP_MMX,            MMXOP_D(pcmpgtd_r64_rm64),        MMXOP_D(pcmpgtd_r64_rm64),    false},
	{ 0x67,     OP_2BYTE|OP_MMX,            MMXOP_D(packuswb_r64_rm64),       MMXOP_D(packuswb_r64_rm64),   false},
	{ 0x68,     OP_2BYTE|OP_MMX,            MMXOP_D(punpckhbw_r64_rm64),      MMXOP_D(punpckhbw_r64_rm64),  false},
	{ 0x69,     OP_2BYTE|OP_MMX,            MMXOP_D(punpckhwd_r64_rm64),      MMXOP_D(punpckhwd_r64_rm64),  false},
	{ 0x6a,     OP_2BYTE|OP_MMX,            MMXOP_D(punpckhdq_r64_rm64),      MMXOP_D(punpckhdq_r64_rm64),  false},
	{ 0x6b,     OP_2BYTE|OP_MMX,            MMXOP_D(packssdw_r64_rm64),       MMXOP_D(packssdw_r64_rm64),   false},
	{ 0x6e,     OP_2BYTE|OP_MMX,            MMXOP_D(movd_r64_rm32),           MMXOP_D(movd_r64_rm32),       false},
	{ 0x6f,     OP_2BYTE|OP_MMX,            MMXOP_D(movq_r64_rm64),           MMXOP_D(movq_r64_rm64),       false},
	{ 0x70,     OP_2BYTE|OP_MMX,            MMXOP_D(pshufw_r64_rm64_i8),      MMXOP_D(pshufw_r64_rm64_i8),  false},
	{ 0x71,     OP_2BYTE|OP_MMX,            MMXOP_D(group_0f71),              MMXOP_D(group_0f71),          false},
	{ 0x72,     OP_2BYTE|OP_MMX,            MMXOP_D(group_0f72),              MMXOP_D(group_0f72),          false},
	{ 0x73,     OP_2BYTE|OP_MMX,            MMXOP_D(group_0f73),              MMXOP_D(group_0f73),          false},
	{ 0x74,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_unknown),          I386OP_D(cyrix_unknown),      false},
	{ 0x74,     OP_2BYTE|OP_MMX,            MMXOP_D(pcmpeqb_r64_rm64),        MMXOP_D(pcmpeqb_r64_rm64),    false},
	{ 0x75,     OP_2BYTE|OP_MMX,            MMXOP_D(pcmpeqw_r64_rm64),        MMXOP_D(pcmpeqw_r64_rm64),    false},
	{ 0x76,     OP_2BYTE|OP_MMX,            MMXOP_D(pcmpeqd_r64_rm64),        MMXOP_D(pcmpeqd_r64_rm64),    false},
	{ 0x77,     OP_2BYTE|OP_MMX,            MMXOP_D(emms),                    MMXOP_D(emms),                false},
	{ 0x78,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_svdc),             I386OP_D(cyrix_svdc),         false},
	{ 0x79,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_rsdc),             I386OP_D(cyrix_rsdc),         false},
	{ 0x7a,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_svldt),            I386OP_D(cyrix_svldt),        false},
	{ 0x7b,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_rsldt),            I386OP_D(cyrix_rsldt),        false},
	{ 0x7c,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_svts),             I386OP_D(cyrix_svts),         false},
	{ 0x7d,     OP_2BYTE|OP_CYRIX,          I386OP_D(cyrix_rsts),             I386OP_D(cyrix_rsts),         false},
	{ 0x7e,     OP_2BYTE|OP_MMX,            MMXOP_D(movd_rm32_r64),           MMXOP_D(movd_rm32_r64),       false},
	{ 0x7f,     OP_2BYTE|OP_MMX,            MMXOP_D(movq_rm64_r64),           MMXOP_D(movq_rm64_r64),       false},
	{ 0x80,     OP_2BYTE|OP_I386,           I386OP_D(jo_rel16),               I386OP_D(jo_rel32),           false},
	{ 0x81,     OP_2BYTE|OP_I386,           I386OP_D(jno_rel16),              I386OP_D(jno_rel32),          false},
	{ 0x82,     OP_2BYTE|OP_I386,           I386OP_D(jc_rel16),               I386OP_D(jc_rel32),           false},
	{ 0x83,     OP_2BYTE|OP_I386,           I386OP_D(jnc_rel16),              I386OP_D(jnc_rel32),          false},
	{ 0x84,     OP_2BYTE|OP_I386,           I386OP_D(jz_rel16),               I386OP_D(jz_rel32),           false},
	{ 0x85,     OP_2BYTE|OP_I386,           I386OP_D(jnz_rel16),              I386OP_D(jnz_rel32),          false},
	{ 0x86,     OP_2BYTE|OP_I386,           I386OP_D(jbe_rel16),              I386OP_D(jbe_rel32),          false},
	{ 0x87,     OP_2BYTE|OP_I386,           I386OP_D(ja_rel16),               I386OP_D(ja_rel32),           false},
	{ 0x88,     OP_2BYTE|OP_I386,           I386OP_D(js_rel16),               I386OP_D(js_rel32),           false},
	{ 0x89,     OP_2BYTE|OP_I386,           I386OP_D(jns_rel16),              I386OP_D(jns_rel32),          false},
	{ 0x8A,     OP_2BYTE|OP_I386,           I386OP_D(jp_rel16),               I386OP_D(jp_rel32),           false},
	{ 0x8B,     OP_2BYTE|OP_I386,           I386OP_D(jnp_rel16),              I386OP_D(jnp_rel32),          false},
	{ 0x8C,     OP_2BYTE|OP_I386,           I386OP_D(jl_rel16),               I386OP_D(jl_rel32),           false},
	{ 0x8D,     OP_2BYTE|OP_I386,           I386OP_D(jge_rel16),              I386OP_D(jge_rel32),          false},
	{ 0x8E,     OP_2BYTE|OP_I386,           I386OP_D(jle_rel16),              I386OP_D(jle_rel32),          false},
	{ 0x8F,     OP_2BYTE|OP_I386,           I386OP_D(jg_rel16),               I386OP_D(jg_rel32),           false},
	{ 0x90,     OP_2BYTE|OP_I386,           I386OP_D(seto_rm8),               I386OP_D(seto_rm8),           false},
	{ 0x91,     OP_2BYTE|OP_I386,           I386OP_D(setno_rm8),              I386OP_D(setno_rm8),          false},
	{ 0x92,     OP_2BYTE|OP_I386,           I386OP_D(setc_rm8),               I386OP_D(setc_rm8),           false},
	{ 0x93,     OP_2BYTE|OP_I386,           I386OP_D(setnc_rm8),              I386OP_D(setnc_rm8),          false},
	{ 0x94,     OP_2BYTE|OP_I386,           I386OP_D(setz_rm8),               I386OP_D(setz_rm8),           false},
	{ 0x95,     OP_2BYTE|OP_I386,           I386OP_D(setnz_rm8),              I386OP_D(setnz_rm8),          false},
	{ 0x96,     OP_2BYTE|OP_I386,           I386OP_D(setbe_rm8),              I386OP_D(setbe_rm8),          false},
	{ 0x97,     OP_2BYTE|OP_I386,           I386OP_D(seta_rm8),               I386OP_D(seta_rm8),           false},
	{ 0x98,     OP_2BYTE|OP_I386,           I386OP_D(sets_rm8),               I386OP_D(sets_rm8),           false},
	{ 0x99,     OP_2BYTE|OP_I386,           I386OP_D(setns_rm8),              I386OP_D(setns_rm8),          false},
	{ 0x9A,     OP_2BYTE|OP_I386,           I386OP_D(setp_rm8),               I386OP_D(setp_rm8),           false},
	{ 0x9B,     OP_2BYTE|OP_I386,           I386OP_D(setnp_rm8),              I386OP_D(setnp_rm8),          false},
	{ 0x9C,     OP_2BYTE|OP_I386,           I386OP_D(setl_rm8),               I386OP_D(setl_rm8),           false},
	{ 0x9D,     OP_2BYTE|OP_I386,           I386OP_D(setge_rm8),              I386OP_D(setge_rm8),          false},
	{ 0x9E,     OP_2BYTE|OP_I386,           I386OP_D(setle_rm8),              I386OP_D(setle_rm8),          false},
	{ 0x9F,     OP_2BYTE|OP_I386,           I386OP_D(setg_rm8),               I386OP_D(setg_rm8),           false},
	{ 0xA0,     OP_2BYTE|OP_I386,           I386OP_D(push_fs16),              I386OP_D(push_fs32),          false},
	{ 0xA1,     OP_2BYTE|OP_I386,           I386OP_D(pop_fs16),               I386OP_D(pop_fs32),           false},
	{ 0xA2,     OP_2BYTE|OP_I486,           I486OP_D(cpuid),                  I486OP_D(cpuid),              false},
	{ 0xA3,     OP_2BYTE|OP_I386,           I386OP_D(bt_rm16_r16),            I386OP_D(bt_rm32_r32),        false},
	{ 0xA4,     OP_2BYTE|OP_I386,           I386OP_D(shld16_i8),              I386OP_D(shld32_i8),          false},
	{ 0xA5,     OP_2BYTE|OP_I386,           I386OP_D(shld16_cl),              I386OP_D(shld32_cl),          false},
	{ 0xA8,     OP_2BYTE|OP_I386,           I386OP_D(push_gs16),              I386OP_D(push_gs32),          false},
	{ 0xA9,     OP_2BYTE|OP_I386,           I386OP_D(pop_gs16),               I386OP_D(pop_gs32),           false},
	{ 0xAA,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(rsm),                 PENTIUMOP_D(rsm),             false},
	{ 0xAB,     OP_2BYTE|OP_I386,           I386OP_D(bts_rm16_r16),           I386OP_D(bts_rm32_r32),       true },
	{ 0xAC,     OP_2BYTE|OP_I386,           I386OP_D(shrd16_i8),              I386OP_D(shrd32_i8),          false},
	{ 0xAD,     OP_2BYTE|OP_I386,           I386OP_D(shrd16_cl),              I386OP_D(shrd32_cl),          false},
	{ 0xAE,     OP_2BYTE|OP_SSE,            SSEOP_D(group_0fae),              SSEOP_D(group_0fae),          false},
	{ 0xAF,     OP_2BYTE|OP_I386,           I386OP_D(imul_r16_rm16),          I386OP_D(imul_r32_rm32),      false},
	{ 0xB0,     OP_2BYTE|OP_I486,           I486OP_D(cmpxchg_rm8_r8),         I486OP_D(cmpxchg_rm8_r8),     true },
	{ 0xB1,     OP_2BYTE|OP_I486,           I486OP_D(cmpxchg_rm16_r16),       I486OP_D(cmpxchg_rm32_r32),   true },
	{ 0xB2,     OP_2BYTE|OP_I386,           I386OP_D(lss16),                  I386OP_D(lss32),              false},
	{ 0xB3,     OP_2BYTE|OP_I386,           I386OP_D(btr_rm16_r16),           I386OP_D(btr_rm32_r32),       true },
	{ 0xB4,     OP_2BYTE|OP_I386,           I386OP_D(lfs16),                  I386OP_D(lfs32),              false},
	{ 0xB5,     OP_2BYTE|OP_I386,           I386OP_D(lgs16),                  I386OP_D(lgs32),              false},
	{ 0xB6,     OP_2BYTE|OP_I386,           I386OP_D(movzx_r16_rm8),          I386OP_D(movzx_r32_rm8),      false},
	{ 0xB7,     OP_2BYTE|OP_I386,           I386OP_D(invalid),                I386OP_D(movzx_r32_rm16),     false},
	{ 0xBA,     OP_2BYTE|OP_I386,           I386OP_D(group0FBA_16),           I386OP_D(group0FBA_32),       true },
	{ 0xBB,     OP_2BYTE|OP_I386,           I386OP_D(btc_rm16_r16),           I386OP_D(btc_rm32_r32),       true },
	{ 0xBC,     OP_2BYTE|OP_I386,           I386OP_D(bsf_r16_rm16),           I386OP_D(bsf_r32_rm32),       false},
	{ 0xBD,     OP_2BYTE|OP_I386,           I386OP_D(bsr_r16_rm16),           I386OP_D(bsr_r32_rm32),       false},
	{ 0xBE,     OP_2BYTE|OP_I386,           I386OP_D(movsx_r16_rm8),          I386OP_D(movsx_r32_rm8),      false},
	{ 0xBF,     OP_2BYTE|OP_I386,           I386OP_D(invalid),                I386OP_D(movsx_r32_rm16),     false},
	{ 0xC0,     OP_2BYTE|OP_I486,           I486OP_D(xadd_rm8_r8),            I486OP_D(xadd_rm8_r8),        true },
	{ 0xC1,     OP_2BYTE|OP_I486,           I486OP_D(xadd_rm16_r16),          I486OP_D(xadd_rm32_r32),      true },
	{ 0xC2,     OP_2BYTE|OP_SSE,            SSEOP_D(cmpps_r128_rm128_i8),     SSEOP_D(cmpps_r128_rm128_i8), false},
	{ 0xC3,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(movnti_m16_r16),      PENTIUMOP_D(movnti_m32_r32),  false},
	{ 0xC4,     OP_2BYTE|OP_SSE,            SSEOP_D(pinsrw_r64_r16m16_i8),    SSEOP_D(pinsrw_r64_r32m16_i8),false},
	{ 0xC5,     OP_2BYTE|OP_SSE,            SSEOP_D(pextrw_r16_r64_i8),       SSEOP_D(pextrw_r32_r64_i8),   false},
	{ 0xC6,     OP_2BYTE|OP_SSE,            SSEOP_D(shufps),                  SSEOP_D(shufps),              false},
	{ 0xC7,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(cmpxchg8b_m64),       PENTIUMOP_D(cmpxchg8b_m64),   true },
	{ 0xC8,     OP_2BYTE|OP_I486,           I486OP_D(bswap_eax),              I486OP_D(bswap_eax),          false},
	{ 0xC9,     OP_2BYTE|OP_I486,           I486OP_D(bswap_ecx),              I486OP_D(bswap_ecx),          false},
	{ 0xCA,     OP_2BYTE|OP_I486,           I486OP_D(bswap_edx),              I486OP_D(bswap_edx),          false},
	{ 0xCB,     OP_2BYTE|OP_I486,           I486OP_D(bswap_ebx),              I486OP_D(bswap_ebx),          false},
	{ 0xCC,     OP_2BYTE|OP_I486,           I486OP_D(bswap_esp),              I486OP_D(bswap_esp),          false},
	{ 0xCD,     OP_2BYTE|OP_I486,           I486OP_D(bswap_ebp),              I486OP_D(bswap_ebp),          false},
	{ 0xCE,     OP_2BYTE|OP_I486,           I486OP_D(bswap_esi),              I486OP_D(bswap_esi),          false},
	{ 0xCF,     OP_2BYTE|OP_I486,           I486OP_D(bswap_edi),              I486OP_D(bswap_edi),          false},
	{ 0xD1,     OP_2BYTE|OP_MMX,            MMXOP_D(psrlw_r64_rm64),          MMXOP_D(psrlw_r64_rm64),      false},
	{ 0xD2,     OP_2BYTE|OP_MMX,            MMXOP_D(psrld_r64_rm64),          MMXOP_D(psrld_r64_rm64),      false},
	{ 0xD3,     OP_2BYTE|OP_MMX,            MMXOP_D(psrlq_r64_rm64),          MMXOP_D(psrlq_r64_rm64),      false},
	{ 0xD4,     OP_2BYTE|OP_MMX,            MMXOP_D(paddq_r64_rm64),          MMXOP_D(paddq_r64_rm64),      false},
	{ 0xD5,     OP_2BYTE|OP_MMX,            MMXOP_D(pmullw_r64_rm64),         MMXOP_D(pmullw_r64_rm64),     false},
	{ 0xD7,     OP_2BYTE|OP_SSE,            SSEOP_D(pmovmskb_r16_r64),        SSEOP_D(pmovmskb_r32_r64),    false},
	{ 0xD8,     OP_2BYTE|OP_MMX,            MMXOP_D(psubusb_r64_rm64),        MMXOP_D(psubusb_r64_rm64),    false},
	{ 0xD9,     OP_2BYTE|OP_MMX,            MMXOP_D(psubusw_r64_rm64),        MMXOP_D(psubusw_r64_rm64),    false},
	{ 0xDA,     OP_2BYTE|OP_SSE,            SSEOP_D(pminub_r64_rm64),         SSEOP_D(pminub_r64_rm64),     false},
	{ 0xDB,     OP_2BYTE|OP_MMX,            MMXOP_D(pand_r64_rm64),           MMXOP_D(pand_r64_rm64),       false},
	{ 0xDC,     OP_2BYTE|OP_MMX,            MMXOP_D(paddusb_r64_rm64),        MMXOP_D(paddusb_r64_rm64),    false},
	{ 0xDD,     OP_2BYTE|OP_MMX,            MMXOP_D(paddusw_r64_rm64),        MMXOP_D(paddusw_r64_rm64),    false},
	{ 0xDE,     OP_2BYTE|OP_SSE,            SSEOP_D(pmaxub_r64_rm64),         SSEOP_D(pmaxub_r64_rm64),     false},
	{ 0xDF,     OP_2BYTE|OP_MMX,            MMXOP_D(pandn_r64_rm64),          MMXOP_D(pandn_r64_rm64),      false},
	{ 0xE0,     OP_2BYTE|OP_SSE,            SSEOP_D(pavgb_r64_rm64),          SSEOP_D(pavgb_r64_rm64),      false},
	{ 0xE1,     OP_2BYTE|OP_MMX,            MMXOP_D(psraw_r64_rm64),          MMXOP_D(psraw_r64_rm64),      false},
	{ 0xE2,     OP_2BYTE|OP_MMX,            MMXOP_D(psrad_r64_rm64),          MMXOP_D(psrad_r64_rm64),      false},
	{ 0xE3,     OP_2BYTE|OP_SSE,            SSEOP_D(pavgw_r64_rm64),          SSEOP_D(pavgw_r64_rm64),      false},
	{ 0xE4,     OP_2BYTE|OP_SSE,            SSEOP_D(pmulhuw_r64_rm64),        SSEOP_D(pmulhuw_r64_rm64),    false},
	{ 0xE5,     OP_2BYTE|OP_MMX,            MMXOP_D(pmulhw_r64_rm64),         MMXOP_D(pmulhw_r64_rm64),     false},
	{ 0xE7,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(movntq_m64_r64),      PENTIUMOP_D(movntq_m64_r64),  false},
	{ 0xE8,     OP_2BYTE|OP_MMX,            MMXOP_D(psubsb_r64_rm64),         MMXOP_D(psubsb_r64_rm64),     false},
	{ 0xE9,     OP_2BYTE|OP_MMX,            MMXOP_D(psubsw_r64_rm64),         MMXOP_D(psubsw_r64_rm64),     false},
	{ 0xEA,     OP_2BYTE|OP_SSE,            SSEOP_D(pminsw_r64_rm64),         SSEOP_D(pminsw_r64_rm64),     false},
	{ 0xEB,     OP_2BYTE|OP_MMX,            MMXOP_D(por_r64_rm64),            MMXOP_D(por_r64_rm64),        false},
	{ 0xEC,     OP_2BYTE|OP_MMX,            MMXOP_D(paddsb_r64_rm64),         MMXOP_D(paddsb_r64_rm64),     false},
	{ 0xED,     OP_2BYTE|OP_MMX,            MMXOP_D(paddsw_r64_rm64),         MMXOP_D(paddsw_r64_rm64),     false},
	{ 0xEE,     OP_2BYTE|OP_SSE,            SSEOP_D(pmaxsw_r64_rm64),         SSEOP_D(pmaxsw_r64_rm64),     false},
	{ 0xEF,     OP_2BYTE|OP_MMX,            MMXOP_D(pxor_r64_rm64),           MMXOP_D(pxor_r64_rm64),       false},
	{ 0xF1,     OP_2BYTE|OP_MMX,            MMXOP_D(psllw_r64_rm64),          MMXOP_D(psllw_r64_rm64),      false},
	{ 0xF2,     OP_2BYTE|OP_MMX,            MMXOP_D(pslld_r64_rm64),          MMXOP_D(pslld_r64_rm64),      false},
	{ 0xF3,     OP_2BYTE|OP_MMX,            MMXOP_D(psllq_r64_rm64),          MMXOP_D(psllq_r64_rm64),      false},
	{ 0xF4,     OP_2BYTE|OP_SSE,            SSEOP_D(pmuludq_r64_rm64),        SSEOP_D(pmuludq_r64_rm64),    false},
	{ 0xF5,     OP_2BYTE|OP_MMX,            MMXOP_D(pmaddwd_r64_rm64),        MMXOP_D(pmaddwd_r64_rm64),    false},
	{ 0xF6,     OP_2BYTE|OP_SSE,            SSEOP_D(psadbw_r64_rm64),         SSEOP_D(psadbw_r64_rm64),     false},
	{ 0xf7,     OP_2BYTE|OP_PENTIUM,        PENTIUMOP_D(maskmovq_r64_r64),    PENTIUMOP_D(maskmovq_r64_r64),false},
	{ 0xF8,     OP_2BYTE|OP_MMX,            MMXOP_D(psubb_r64_rm64),          MMXOP_D(psubb_r64_rm64),      false},
	{ 0xF9,     OP_2BYTE|OP_MMX,            MMXOP_D(psubw_r64_rm64),          MMXOP_D(psubw_r64_rm64),      false},
	{ 0xFA,     OP_2BYTE|OP_MMX,            MMXOP_D(psubd_r64_rm64),          MMXOP_D(psubd_r64_rm64),      false},
	{ 0xFB,     OP_2BYTE|OP_SSE,            SSEOP_D(psubq_r64_rm64),          SSEOP_D(psubq_r64_rm64),      false},
	{ 0xFC,     OP_2BYTE|OP_MMX,            MMXOP_D(paddb_r64_rm64),          MMXOP_D(paddb_r64_rm64),      false},
	{ 0xFD,     OP_2BYTE|OP_MMX,            MMXOP_D(paddw_r64_rm64),          MMXOP_D(paddw_r64_rm64),      false},
	{ 0xFE,     OP_2BYTE|OP_MMX,            MMXOP_D(paddd_r64_rm64),          MMXOP_D(paddd_r64_rm64),      false},
	/* F3 0F ?? */
	{ 0x10,     OP_3BYTEF3|OP_SSE,          SSEOP_D(movss_r128_rm128),        SSEOP_D(movss_r128_rm128),    false},
	{ 0x11,     OP_3BYTEF3|OP_SSE,          SSEOP_D(movss_rm128_r128),        SSEOP_D(movss_rm128_r128),    false},
	{ 0x12,     OP_3BYTEF3|OP_SSE,          SSEOP_D(movsldup_r128_rm128),     SSEOP_D(movsldup_r128_rm128), false},
	{ 0x16,     OP_3BYTEF3|OP_SSE,          SSEOP_D(movshdup_r128_rm128),     SSEOP_D(movshdup_r128_rm128), false},
	{ 0x2A,     OP_3BYTEF3|OP_SSE,          SSEOP_D(cvtsi2ss_r128_rm32),      SSEOP_D(cvtsi2ss_r128_rm32),  false},
	{ 0x2C,     OP_3BYTEF3|OP_SSE,          SSEOP_D(cvttss2si_r32_r128m32),   SSEOP_D(cvttss2si_r32_r128m32),false},
	{ 0x2D,     OP_3BYTEF3|OP_SSE,          SSEOP_D(cvtss2si_r32_r128m32),    SSEOP_D(cvtss2si_r32_r128m32),false},
	{ 0x51,     OP_3BYTEF3|OP_SSE,          SSEOP_D(sqrtss_r128_r128m32),     SSEOP_D(sqrtss_r128_r128m32), false},
	{ 0x52,     OP_3BYTEF3|OP_SSE,          SSEOP_D(rsqrtss_r128_r128m32),    SSEOP_D(rsqrtss_r128_r128m32),false},
	{ 0x53,     OP_3BYTEF3|OP_SSE,          SSEOP_D(rcpss_r128_r128m32),      SSEOP_D(rcpss_r128_r128m32),  false},
	{ 0x58,     OP_3BYTEF3|OP_SSE,          SSEOP_D(addss),                   SSEOP_D(addss),               false},
	{ 0x59,     OP_3BYTEF3|OP_SSE,          SSEOP_D(mulss),                   SSEOP_D(mulss),               false},
	{ 0x5A,     OP_3BYTEF3|OP_SSE,          SSEOP_D(cvtss2sd_r128_r128m32),   SSEOP_D(cvtss2sd_r128_r128m32),false},
	{ 0x5B,     OP_3BYTEF3|OP_SSE,          SSEOP_D(cvttps2dq_r128_rm128),    SSEOP_D(cvttps2dq_r128_rm128),false},
	{ 0x5C,     OP_3BYTEF3|OP_SSE,          SSEOP_D(subss),                   SSEOP_D(subss),               false},
	{ 0x5D,     OP_3BYTEF3|OP_SSE,          SSEOP_D(minss_r128_r128m32),      SSEOP_D(minss_r128_r128m32),  false},
	{ 0x5E,     OP_3BYTEF3|OP_SSE,          SSEOP_D(divss),                   SSEOP_D(divss),               false},
	{ 0x5F,     OP_3BYTEF3|OP_SSE,          SSEOP_D(maxss_r128_r128m32),      SSEOP_D(maxss_r128_r128m32),  false},
	{ 0x6F,     OP_3BYTEF3|OP_SSE,          SSEOP_D(movdqu_r128_rm128),       SSEOP_D(movdqu_r128_rm128),   false},
	{ 0x70,     OP_3BYTEF3|OP_SSE,          SSEOP_D(pshufhw_r128_rm128_i8),   SSEOP_D(pshufhw_r128_rm128_i8),false},
	{ 0x7E,     OP_3BYTEF3|OP_SSE,          SSEOP_D(movq_r128_r128m64),       SSEOP_D(movq_r128_r128m64),   false},
	{ 0x7F,     OP_3BYTEF3|OP_SSE,          SSEOP_D(movdqu_rm128_r128),       SSEOP_D(movdqu_rm128_r128),   false},
	{ 0xAE,     OP_3BYTE66|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xB8,     OP_3BYTEF3|OP_PENTIUM,      PENTIUMOP_D(popcnt_r16_rm16),     PENTIUMOP_D(popcnt_r32_rm32), false},
	{ 0xBC,     OP_3BYTEF3|OP_PENTIUM,      PENTIUMOP_D(tzcnt_r16_rm16),      PENTIUMOP_D(tzcnt_r32_rm32),  false},
	{ 0xC2,     OP_3BYTEF3|OP_SSE,          SSEOP_D(cmpss_r128_r128m32_i8),   SSEOP_D(cmpss_r128_r128m32_i8),false},
	{ 0xC7,     OP_3BYTEF2|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xD6,     OP_3BYTEF3|OP_SSE,          SSEOP_D(movq2dq_r128_r64),        SSEOP_D(movq2dq_r128_r64),    false},
	{ 0xE6,     OP_3BYTEF3|OP_SSE,          SSEOP_D(cvtdq2pd_r128_r128m64),   SSEOP_D(cvtdq2pd_r128_r128m64),false},
	/* F2 0F ?? */
	{ 0x10,     OP_3BYTEF2|OP_SSE,          SSEOP_D(movsd_r128_r128m64),      SSEOP_D(movsd_r128_r128m64),  false},
	{ 0x11,     OP_3BYTEF2|OP_SSE,          SSEOP_D(movsd_r128m64_r128),      SSEOP_D(movsd_r128m64_r128),  false},
	{ 0x12,     OP_3BYTEF2|OP_SSE,          SSEOP_D(movddup_r128_r128m64),    SSEOP_D(movddup_r128_r128m64),false},
	{ 0x2A,     OP_3BYTEF2|OP_SSE,          SSEOP_D(cvtsi2sd_r128_rm32),      SSEOP_D(cvtsi2sd_r128_rm32),  false},
	{ 0x2C,     OP_3BYTEF2|OP_SSE,          SSEOP_D(cvttsd2si_r32_r128m64),   SSEOP_D(cvttsd2si_r32_r128m64),false},
	{ 0x2D,     OP_3BYTEF2|OP_SSE,          SSEOP_D(cvtsd2si_r32_r128m64),    SSEOP_D(cvtsd2si_r32_r128m64),false},
	{ 0x51,     OP_3BYTEF2|OP_SSE,          SSEOP_D(sqrtsd_r128_r128m64),     SSEOP_D(sqrtsd_r128_r128m64), false},
	{ 0x58,     OP_3BYTEF2|OP_SSE,          SSEOP_D(addsd_r128_r128m64),      SSEOP_D(addsd_r128_r128m64),  false},
	{ 0x59,     OP_3BYTEF2|OP_SSE,          SSEOP_D(mulsd_r128_r128m64),      SSEOP_D(mulsd_r128_r128m64),  false},
	{ 0x5A,     OP_3BYTEF2|OP_SSE,          SSEOP_D(cvtsd2ss_r128_r128m64),   SSEOP_D(cvtsd2ss_r128_r128m64),false},
	{ 0x5C,     OP_3BYTEF2|OP_SSE,          SSEOP_D(subsd_r128_r128m64),      SSEOP_D(subsd_r128_r128m64),  false},
	{ 0x5D,     OP_3BYTEF2|OP_SSE,          SSEOP_D(minsd_r128_r128m64),      SSEOP_D(minsd_r128_r128m64),  false},
	{ 0x5E,     OP_3BYTEF2|OP_SSE,          SSEOP_D(divsd_r128_r128m64),      SSEOP_D(divsd_r128_r128m64),  false},
	{ 0x5F,     OP_3BYTEF2|OP_SSE,          SSEOP_D(maxsd_r128_r128m64),      SSEOP_D(maxsd_r128_r128m64),  false},
	{ 0x70,     OP_3BYTEF2|OP_SSE,          SSEOP_D(pshuflw_r128_rm128_i8),   SSEOP_D(pshuflw_r128_rm128_i8),false},
	{ 0x7C,     OP_3BYTEF2|OP_SSE,          SSEOP_D(haddps_r128_rm128),       SSEOP_D(haddps_r128_rm128),   false},
	{ 0x7D,     OP_3BYTEF2|OP_SSE,          SSEOP_D(hsubps_r128_rm128),       SSEOP_D(hsubps_r128_rm128),   false},
	{ 0xC2,     OP_3BYTEF2|OP_SSE,          SSEOP_D(cmpsd_r128_r128m64_i8),   SSEOP_D(cmpsd_r128_r128m64_i8),false},
	{ 0xD0,     OP_3BYTEF2|OP_SSE,          SSEOP_D(addsubps_r128_rm128),     SSEOP_D(addsubps_r128_rm128), false},
	{ 0xD6,     OP_3BYTEF2|OP_SSE,          SSEOP_D(movdq2q_r64_r128),        SSEOP_D(movdq2q_r64_r128),    false},
	{ 0xE6,     OP_3BYTEF2|OP_SSE,          SSEOP_D(cvtpd2dq_r128_rm128),     SSEOP_D(cvtpd2dq_r128_rm128), false},
	{ 0xF0,     OP_3BYTEF2|OP_SSE,          SSEOP_D(lddqu_r128_m128),         SSEOP_D(lddqu_r128_m128),     false},
	/* 66 0F ?? */
	{ 0x10,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movupd_r128_rm128),       SSEOP_D(movupd_r128_rm128),   false},
	{ 0x11,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movupd_rm128_r128),       SSEOP_D(movupd_rm128_r128),   false},
	{ 0x12,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movlpd_r128_m64),         SSEOP_D(movlpd_r128_m64),     false},
	{ 0x13,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movlpd_m64_r128),         SSEOP_D(movlpd_m64_r128),     false},
	{ 0x14,     OP_3BYTE66|OP_SSE2,         SSEOP_D(unpcklpd_r128_rm128),     SSEOP_D(unpcklpd_r128_rm128), false},
	{ 0x15,     OP_3BYTE66|OP_SSE2,         SSEOP_D(unpckhpd_r128_rm128),     SSEOP_D(unpckhpd_r128_rm128), false},
	{ 0x16,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movhpd_r128_m64),         SSEOP_D(movhpd_r128_m64),     false},
	{ 0x17,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movhpd_m64_r128),         SSEOP_D(movhpd_m64_r128),     false},
	{ 0x28,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movapd_r128_rm128),       SSEOP_D(movapd_r128_rm128),   false},
	{ 0x29,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movapd_rm128_r128),       SSEOP_D(movapd_rm128_r128),   false},
	{ 0x2A,     OP_3BYTE66|OP_SSE2,         SSEOP_D(cvtpi2pd_r128_rm64),      SSEOP_D(cvtpi2pd_r128_rm64),  false},
	{ 0x2B,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movntpd_m128_r128),       SSEOP_D(movntpd_m128_r128),   false},
	{ 0x2C,     OP_3BYTE66|OP_SSE2,         SSEOP_D(cvttpd2pi_r64_rm128),     SSEOP_D(cvttpd2pi_r64_rm128), false},
	{ 0x2D,     OP_3BYTE66|OP_SSE2,         SSEOP_D(cvtpd2pi_r64_rm128),      SSEOP_D(cvtpd2pi_r64_rm128),  false},
	{ 0x2E,     OP_3BYTE66|OP_SSE2,         SSEOP_D(ucomisd_r128_r128m64),    SSEOP_D(ucomisd_r128_r128m64),false},
	{ 0x2F,     OP_3BYTE66|OP_SSE2,         SSEOP_D(comisd_r128_r128m64),     SSEOP_D(comisd_r128_r128m64), false},
	{ 0x50,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movmskpd_r32_r128),       SSEOP_D(movmskpd_r32_r128),   false},
	{ 0x51,     OP_3BYTE66|OP_SSE2,         SSEOP_D(sqrtpd_r128_rm128),       SSEOP_D(sqrtpd_r128_rm128),   false},
	{ 0x54,     OP_3BYTE66|OP_SSE2,         SSEOP_D(andpd_r128_rm128),        SSEOP_D(andpd_r128_rm128),    false},
	{ 0x55,     OP_3BYTE66|OP_SSE2,         SSEOP_D(andnpd_r128_rm128),       SSEOP_D(andnpd_r128_rm128),   false},
	{ 0x56,     OP_3BYTE66|OP_SSE2,         SSEOP_D(orpd_r128_rm128),         SSEOP_D(orpd_r128_rm128),     false},
	{ 0x57,     OP_3BYTE66|OP_SSE2,         SSEOP_D(xorpd_r128_rm128),        SSEOP_D(xorpd_r128_rm128),    false},
	{ 0x58,     OP_3BYTE66|OP_SSE2,         SSEOP_D(addpd_r128_rm128),        SSEOP_D(addpd_r128_rm128),    false},
	{ 0x59,     OP_3BYTE66|OP_SSE2,         SSEOP_D(mulpd_r128_rm128),        SSEOP_D(mulpd_r128_rm128),    false},
	{ 0x5A,     OP_3BYTE66|OP_SSE2,         SSEOP_D(cvtpd2ps_r128_rm128),     SSEOP_D(cvtpd2ps_r128_rm128), false},
	{ 0x5B,     OP_3BYTE66|OP_SSE2,         SSEOP_D(cvtps2dq_r128_rm128),     SSEOP_D(cvtps2dq_r128_rm128), false},
	{ 0x5C,     OP_3BYTE66|OP_SSE2,         SSEOP_D(subpd_r128_rm128),        SSEOP_D(subpd_r128_rm128),    false},
	{ 0x5D,     OP_3BYTE66|OP_SSE2,         SSEOP_D(minpd_r128_rm128),        SSEOP_D(minpd_r128_rm128),    false},
	{ 0x5E,     OP_3BYTE66|OP_SSE2,         SSEOP_D(divpd_r128_rm128),        SSEOP_D(divpd_r128_rm128),    false},
	{ 0x5F,     OP_3BYTE66|OP_SSE2,         SSEOP_D(maxpd_r128_rm128),        SSEOP_D(maxpd_r128_rm128),    false},
	{ 0x60,     OP_3BYTE66|OP_SSE2,         SSEOP_D(punpcklbw_r128_rm128),    SSEOP_D(punpcklbw_r128_rm128),false},
	{ 0x61,     OP_3BYTE66|OP_SSE2,         SSEOP_D(punpcklwd_r128_rm128),    SSEOP_D(punpcklwd_r128_rm128),false},
	{ 0x62,     OP_3BYTE66|OP_SSE2,         SSEOP_D(punpckldq_r128_rm128),    SSEOP_D(punpckldq_r128_rm128),false},
	{ 0x63,     OP_3BYTE66|OP_SSE2,         SSEOP_D(packsswb_r128_rm128),     SSEOP_D(packsswb_r128_rm128), false},
	{ 0x64,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pcmpgtb_r128_rm128),      SSEOP_D(pcmpgtb_r128_rm128),  false},
	{ 0x65,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pcmpgtw_r128_rm128),      SSEOP_D(pcmpgtw_r128_rm128),  false},
	{ 0x66,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pcmpgtd_r128_rm128),      SSEOP_D(pcmpgtd_r128_rm128),  false},
	{ 0x67,     OP_3BYTE66|OP_SSE2,         SSEOP_D(packuswb_r128_rm128),     SSEOP_D(packuswb_r128_rm128), false},
	{ 0x68,     OP_3BYTE66|OP_SSE2,         SSEOP_D(punpckhbw_r128_rm128),    SSEOP_D(punpckhbw_r128_rm128),false},
	{ 0x69,     OP_3BYTE66|OP_SSE2,         SSEOP_D(punpckhwd_r128_rm128),    SSEOP_D(punpckhwd_r128_rm128),false},
	{ 0x6A,     OP_3BYTE66|OP_SSE2,         SSEOP_D(unpckhdq_r128_rm128),     SSEOP_D(unpckhdq_r128_rm128), false},
	{ 0x6B,     OP_3BYTE66|OP_SSE2,         SSEOP_D(packssdw_r128_rm128),     SSEOP_D(packssdw_r128_rm128), false},
	{ 0x6C,     OP_3BYTE66|OP_SSE2,         SSEOP_D(punpcklqdq_r128_rm128),   SSEOP_D(punpcklqdq_r128_rm128),false},
	{ 0x6D,     OP_3BYTE66|OP_SSE2,         SSEOP_D(punpckhqdq_r128_rm128),   SSEOP_D(punpckhqdq_r128_rm128),false},
	{ 0x6E,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movd_m128_rm32),          SSEOP_D(movd_m128_rm32),      false},
	{ 0x6F,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movdqa_m128_rm128),       SSEOP_D(movdqa_m128_rm128),   false},
	{ 0x70,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pshufd_r128_rm128_i8),    SSEOP_D(pshufd_r128_rm128_i8),false},
	{ 0x71,     OP_3BYTE66|OP_SSE2,         SSEOP_D(group_660f71),            SSEOP_D(group_660f71),        false},
	{ 0x72,     OP_3BYTE66|OP_SSE2,         SSEOP_D(group_660f72),            SSEOP_D(group_660f72),        false},
	{ 0x73,     OP_3BYTE66|OP_SSE2,         SSEOP_D(group_660f73),            SSEOP_D(group_660f73),        false},
	{ 0x74,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pcmpeqb_r128_rm128),      SSEOP_D(pcmpeqb_r128_rm128),  false},
	{ 0x75,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pcmpeqw_r128_rm128),      SSEOP_D(pcmpeqw_r128_rm128),  false},
	{ 0x76,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pcmpeqd_r128_rm128),      SSEOP_D(pcmpeqd_r128_rm128),  false},
	{ 0x7C,     OP_3BYTE66|OP_SSE2,         SSEOP_D(haddpd_r128_rm128),       SSEOP_D(haddpd_r128_rm128),   false},
	{ 0x7D,     OP_3BYTE66|OP_SSE2,         SSEOP_D(hsubpd_r128_rm128),       SSEOP_D(hsubpd_r128_rm128),   false},
	{ 0x7E,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movd_rm32_r128),          SSEOP_D(movd_rm32_r128),      false},
	{ 0x7F,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movdqa_rm128_r128),       SSEOP_D(movdqa_rm128_r128),   false},
	{ 0xC2,     OP_3BYTE66|OP_SSE2,         SSEOP_D(cmppd_r128_rm128_i8),     SSEOP_D(cmppd_r128_rm128_i8), false},
	{ 0xC4,     OP_3BYTE66|OP_SSE,          SSEOP_D(pinsrw_r128_r32m16_i8),   SSEOP_D(pinsrw_r128_r32m16_i8),false},
	{ 0xC5,     OP_3BYTE66|OP_SSE,          SSEOP_D(pextrw_reg_r128_i8),      SSEOP_D(pextrw_reg_r128_i8),  false},
	{ 0xC6,     OP_3BYTE66|OP_SSE2,         SSEOP_D(shufpd_r128_rm128_i8),    SSEOP_D(shufpd_r128_rm128_i8),false},
	{ 0xC7,     OP_3BYTE66|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xD0,     OP_3BYTE66|OP_SSE2,         SSEOP_D(addsubpd_r128_rm128),     SSEOP_D(addsubpd_r128_rm128), false},
	{ 0xD1,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psrlw_r128_rm128),        SSEOP_D(psrlw_r128_rm128),    false},
	{ 0xD2,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psrld_r128_rm128),        SSEOP_D(psrld_r128_rm128),    false},
	{ 0xD3,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psrlq_r128_rm128),        SSEOP_D(psrlq_r128_rm128),    false},
	{ 0xD4,     OP_3BYTE66|OP_SSE2,         SSEOP_D(paddq_r128_rm128),        SSEOP_D(paddq_r128_rm128),    false},
	{ 0xD5,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pmullw_r128_rm128),       SSEOP_D(pmullw_r128_rm128),   false},
	{ 0xD6,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movq_r128m64_r128),       SSEOP_D(movq_r128m64_r128),   false},
	{ 0xD7,     OP_3BYTE66|OP_SSE,          SSEOP_D(pmovmskb_r32_r128),       SSEOP_D(pmovmskb_r32_r128),   false},
	{ 0xD8,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psubusb_r128_rm128),      SSEOP_D(psubusb_r128_rm128),  false},
	{ 0xD9,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psubusw_r128_rm128),      SSEOP_D(psubusw_r128_rm128),  false},
	{ 0xDA,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pminub_r128_rm128),       SSEOP_D(pminub_r128_rm128),   false},
	{ 0xDB,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pand_r128_rm128),         SSEOP_D(pand_r128_rm128),     false},
	{ 0xDC,     OP_3BYTE66|OP_SSE2,         SSEOP_D(paddusb_r128_rm128),      SSEOP_D(paddusb_r128_rm128),  false},
	{ 0xDD,     OP_3BYTE66|OP_SSE2,         SSEOP_D(paddusw_r128_rm128),      SSEOP_D(paddusw_r128_rm128),  false},
	{ 0xDE,     OP_3BYTE66|OP_SSE,          SSEOP_D(pmaxub_r128_rm128),       SSEOP_D(pmaxub_r128_rm128),   false},
	{ 0xDF,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pandn_r128_rm128),        SSEOP_D(pandn_r128_rm128),    false},
	{ 0xE0,     OP_3BYTE66|OP_SSE,          SSEOP_D(pavgb_r128_rm128),        SSEOP_D(pavgb_r128_rm128),    false},
	{ 0xE1,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psraw_r128_rm128),        SSEOP_D(psraw_r128_rm128),    false},
	{ 0xE2,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psrad_r128_rm128),        SSEOP_D(psrad_r128_rm128),    false},
	{ 0xE3,     OP_3BYTE66|OP_SSE,          SSEOP_D(pavgw_r128_rm128),        SSEOP_D(pavgw_r128_rm128),    false},
	{ 0xE4,     OP_3BYTE66|OP_SSE,          SSEOP_D(pmulhuw_r128_rm128),      SSEOP_D(pmulhuw_r128_rm128),  false},
	{ 0xE5,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pmulhw_r128_rm128),       SSEOP_D(pmulhw_r128_rm128),   false},
	{ 0xE6,     OP_3BYTE66|OP_SSE2,         SSEOP_D(cvttpd2dq_r128_rm128),    SSEOP_D(cvttpd2dq_r128_rm128),false},
	{ 0xE7,     OP_3BYTE66|OP_SSE2,         SSEOP_D(movntdq_m128_r128),       SSEOP_D(movntdq_m128_r128),   false},
	{ 0xE8,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psubsb_r128_rm128),       SSEOP_D(psubsb_r128_rm128),   false},
	{ 0xE9,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psubsw_r128_rm128),       SSEOP_D(psubsw_r128_rm128),   false},
	{ 0xEA,     OP_3BYTE66|OP_SSE,          SSEOP_D(pminsw_r128_rm128),       SSEOP_D(pminsw_r128_rm128),   false},
	{ 0xEB,     OP_3BYTE66|OP_SSE2,         SSEOP_D(por_r128_rm128),          SSEOP_D(por_r128_rm128),      false},
	{ 0xEC,     OP_3BYTE66|OP_SSE2,         SSEOP_D(paddsb_r128_rm128),       SSEOP_D(paddsb_r128_rm128),   false},
	{ 0xED,     OP_3BYTE66|OP_SSE2,         SSEOP_D(paddsw_r128_rm128),       SSEOP_D(paddsw_r128_rm128),   false},
	{ 0xEE,     OP_3BYTE66|OP_SSE,          SSEOP_D(pmaxsw_r128_rm128),       SSEOP_D(pmaxsw_r128_rm128),   false},
	{ 0xEF,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pxor_r128_rm128),         SSEOP_D(pxor_r128_rm128),     false},
	{ 0xF1,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psllw_r128_rm128),        SSEOP_D(psllw_r128_rm128),    false},
	{ 0xF2,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pslld_r128_rm128),        SSEOP_D(pslld_r128_rm128),    false},
	{ 0xF3,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psllq_r128_rm128),        SSEOP_D(psllq_r128_rm128),    false},
	{ 0xF4,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pmuludq_r128_rm128),      SSEOP_D(pmuludq_r128_rm128),  false},
	{ 0xF5,     OP_3BYTE66|OP_SSE2,         SSEOP_D(pmaddwd_r128_rm128),      SSEOP_D(pmaddwd_r128_rm128),  false},
	{ 0xF6,     OP_3BYTE66|OP_SSE,          SSEOP_D(psadbw_r128_rm128),       SSEOP_D(psadbw_r128_rm128),   false},
	{ 0xF7,     OP_3BYTE66|OP_SSE2,         SSEOP_D(maskmovdqu_r128_r128),    SSEOP_D(maskmovdqu_r128_r128),false},
	{ 0xF8,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psubb_r128_rm128),        SSEOP_D(psubb_r128_rm128),    false},
	{ 0xF9,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psubw_r128_rm128),        SSEOP_D(psubw_r128_rm128),    false},
	{ 0xFA,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psubd_r128_rm128),        SSEOP_D(psubd_r128_rm128),    false},
	{ 0xFB,     OP_3BYTE66|OP_SSE2,         SSEOP_D(psubq_r128_rm128),        SSEOP_D(psubq_r128_rm128),    false},
	{ 0xFC,     OP_3BYTE66|OP_SSE2,         SSEOP_D(paddb_r128_rm128),        SSEOP_D(paddb_r128_rm128),    false},
	{ 0xFD,     OP_3BYTE66|OP_SSE2,         SSEOP_D(paddw_r128_rm128),        SSEOP_D(paddw_r128_rm128),    false},
	{ 0xFE,     OP_3BYTE66|OP_SSE2,         SSEOP_D(paddd_r128_rm128),        SSEOP_D(paddd_r128_rm128),    false},
	/* 0F 38 ?? */
	{ 0x00,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x01,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x02,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x03,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x04,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x05,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x06,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x07,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x08,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x09,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0A,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0B,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x1C,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x1D,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x1E,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF0,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF1,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF2,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF3,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF5,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF7,     OP_3BYTE38|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	/* 0F 3A ?? */
	{ 0x0F,     OP_3BYTE3A|OP_SSE,          I386OP_D(invalid),                I386OP_D(invalid),            false},
	/* 66 0F 38 ?? */
	{ 0x00,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x01,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x02,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x03,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x04,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x05,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x06,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x07,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x08,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x09,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0A,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0B,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0C,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0D,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0E,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0F,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x10,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x13,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x14,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x15,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x16,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x17,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x18,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x19,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x1A,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x1C,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x1D,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x1E,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x20,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x21,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x22,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x23,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x24,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x25,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x28,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x29,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x2A,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x2B,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x2C,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x2D,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x2E,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x2F,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x30,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x31,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x32,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x33,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x34,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x35,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x36,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x37,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x38,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x39,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x3A,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x3B,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x3C,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x3D,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x3E,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x3F,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x40,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x41,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x45,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x46,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x47,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x58,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x59,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x5A,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x78,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x79,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x80,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x81,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x82,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x8C,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x8E,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x90,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x91,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x92,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x93,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x96,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x97,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x98,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x99,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x9A,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x9B,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x9C,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x9D,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x9E,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x9F,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xA6,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xA7,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xA8,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xA9,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xAA,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xAB,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xAC,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xAD,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xAE,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xAF,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xB6,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xB7,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xB8,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xB9,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xBA,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xBB,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xBC,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xBD,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xBE,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xBF,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xDB,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xDC,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xDD,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xDE,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xDF,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF0,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF1,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF3,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF6,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF7,     OP_4BYTE3866|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	/* F2 0F 38 ?? */
	{ 0xF0,     OP_4BYTE38F2|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF1,     OP_4BYTE38F2|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF3,     OP_4BYTE38F2|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF5,     OP_4BYTE38F2|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF6,     OP_4BYTE38F2|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF7,     OP_4BYTE38F2|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	/* F3 0F 38 ?? */
	{ 0xF3,     OP_4BYTE38F3|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF5,     OP_4BYTE38F3|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF6,     OP_4BYTE38F3|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xF7,     OP_4BYTE38F3|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	/* 66 0F 3A ?? */
	{ 0x00,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x01,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x02,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x04,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x05,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x06,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x08,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x09,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0A,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0B,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0C,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0D,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0E,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x0F,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x14,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x15,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x16,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x17,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x18,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x19,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x1D,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x20,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x21,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x22,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x38,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x39,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x40,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x41,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x42,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x44,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x46,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x4A,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x4B,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x4C,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x60,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x61,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x62,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0x63,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	{ 0xDF,     OP_4BYTE3A66|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false},
	/* F2 0F 3A ?? */
	{ 0xF0,     OP_4BYTE3AF2|OP_SSE,        I386OP_D(invalid),                I386OP_D(invalid),            false}
};
