﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Input;

namespace CTester.Command
{
    public abstract class CommandBase : ICommand
    {
        // ----------------------------------------
        // メンバー列挙型
        // ----------------------------------------
        #region Enum Members
        #endregion

        // ----------------------------------------
        // メンバー定数
        // ----------------------------------------
        #region Const Members
        #endregion

        // ----------------------------------------
        // フィールド
        // ----------------------------------------
        #region Fields
        #endregion

        // ----------------------------------------
        // プロパティ
        // ----------------------------------------
        #region Properties

        /// <summary>
        /// キーバインド
        /// </summary>
        public KeyBinding KeyBind{ get; set; }

        public string Name { get; set; }

        #endregion

        // ----------------------------------------
        // コンストラクタ
        // ----------------------------------------
        #region Constructor

        public CommandBase()
        {
            KeyBind = null;
            Name = string.Empty;
        }

        #endregion

        // ----------------------------------------
        // ICommandインターフェース
        // ----------------------------------------
        #region ICommand Interface
		public event EventHandler CanExecuteChanged
		{
			add { CommandManager.RequerySuggested += value; }
            remove { CommandManager.RequerySuggested -= value; }
		}
		
        public abstract bool CanExecute(object parameter);
        
        public abstract void Execute(object parameter);
        
        #endregion
    }
}
