﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Threading.Tasks;
using System.Runtime.InteropServices;
using System.Windows.Interop;

namespace CTester.Common
{
    /// <summary>
    /// DialogProgress.xaml の相互作用ロジック
    /// </summary>
    public partial class DialogProgress : Window
    {
        private Action _action;
        private bool _isCancelRequire = false;
        private DateTime _startTime = default(DateTime);

        private int _finishedCount = 0;
        private int _totalCount = 0;

        public int FinishedCount
        {
            get
            {
                return _finishedCount;
            }
            set
            {
                if (value > _totalCount)
                {
                    return;
                }

                _finishedCount = value;
                if (_finishedCount > 0)
                {
                    long ticks = DateTime.Now.Ticks - _startTime.Ticks;
                    ticks = ticks * _totalCount / _finishedCount;
                    DateTime finishTime = new DateTime(_startTime.Ticks + ticks);
                    int proggress = _finishedCount * 100 / _totalCount;

                    this.Dispatcher.BeginInvoke(new Action(() =>
                        {
                            labelFinishTime.Content = "予想終了時刻 " + finishTime.ToString("HH時mm分");
                            progressBar.Value = proggress;
                        }));
                }
            }
        }

        public int TotalCount
        {
            get
            {
                return _totalCount;
            }
            set
            {
                _totalCount = value;
            }
        }

        //public DateTime FinishTime
        //{
        //    set
        //    {
        //        this.Dispatcher.BeginInvoke(new Action(() =>
        //            labelFinishTime.Content = "予想終了時刻 " + value.ToString("HH時mm分")),
        //            null);
        //    }
        //}



        //public int ProgressValue
        //{
        //    set
        //    {
        //        this.Dispatcher.BeginInvoke(new Action(() => progressBar.Value = value));
        //    }
        //}

        //public string Message
        //{
        //    set
        //    {
        //        if (!_isCancelRequire)
        //        {
        //            this.Dispatcher.BeginInvoke(new Action(() =>
        //            {
        //                labelMessage.Content = value;
        //            }), null);
        //        }
        //    }
        //}

        public bool IsCancelRequire
        {
            get
            {
                return _isCancelRequire;
            }
        }

        public DialogProgress(string title)
        {
            InitializeComponent();

            Title = title;
        }


        public bool? ShowDialog(Action action)
        {
            _action = action;
            return base.ShowDialog();
        }

        private void buttonCancel_Click(object sender, RoutedEventArgs e)
        {
            _isCancelRequire = true;
            labelMessage.Content = "キャンセル処理中です。";
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            //DialogResult = true;
            _startTime = DateTime.Now;
            var task = Task.Factory.StartNew(() =>
            {
                _action();
                this.Dispatcher.BeginInvoke(new Action(() =>
                {
                    _allowClosing = true;
                    DialogResult = !_isCancelRequire;
                }));
            });
        }

        protected override void OnSourceInitialized(EventArgs e)
        {
            base.OnSourceInitialized(e);
            HwndSource hwndSource = PresentationSource.FromVisual(this) as HwndSource;
            if (hwndSource != null)
            {
                hwndSource.AddHook(HwndSourceHook);
            }
        }

        private bool _allowClosing = false;

        [DllImport("user32.dll")]
        private static extern IntPtr GetSystemMenu(IntPtr hWnd, bool bRevert);
        [DllImport("user32.dll")]
        private static extern bool EnableMenuItem(IntPtr hMenu, uint uIDEnableItem, uint uEnable);
        private const uint MF_BYCOMMAND = 0x00000000;
        private const uint MF_GRAYED = 0x00000001;
        private const uint SC_CLOSE = 0xF060;
        private const int WM_SHOWWINDOW = 0x00000018;
        private const int WM_CLOSE = 0x10;
        private IntPtr HwndSourceHook(IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam, ref bool handled)
        {
            switch (msg)
            {
                case WM_SHOWWINDOW:
                    {
                        IntPtr hMenu = GetSystemMenu(hwnd, false);
                        if (hMenu != IntPtr.Zero)
                        {
                            EnableMenuItem(hMenu, SC_CLOSE, MF_BYCOMMAND | MF_GRAYED);
                        }
                    }
                    break;
                case WM_CLOSE:
                    if (!_allowClosing)
                    {
                        handled = true;
                    }
                    break;
            }
            return IntPtr.Zero;
        }
    }

    public class CancelRequest
    {
        private bool _isCancel = false;
        public bool IsCancel
        {
            get
            {
                return _isCancel;
            }
            set
            {
                _isCancel = value;
            }
        }

        private string _message = string.Empty;
        public string Message
        {
            get
            {
                return _message;
            }
            set
            {
                _message = value;
            }
        }

        public CancelRequest()
        {
        }
    }
}
