﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Xml.Serialization;
using CTester.Setting;
using Utility;

namespace CTester
{
    public class DocumentManager
    {
        // ----------------------------------------
        // メンバークラス
        // ----------------------------------------
        #region Class Members

        /// <summary>
        /// シリアライズデータ
        /// </summary>
        [Serializable, XmlType("DocumentManager")]
        public class SerializeData
        {
            public WindowLayout.SerializeData WindowLayoutSerialize { get; set; }

            public SerializeData()
            {
            }
        }

        #endregion

        // ----------------------------------------
        // スタティックフィールド
        // ----------------------------------------
        #region Static Fields

        public static DocumentManager Instance = new DocumentManager();

        #endregion

        // ----------------------------------------
        // フィールド
        // ----------------------------------------
        #region Fields

        private WindowLayout _windowLayout = new WindowLayout();

        #endregion

        // ----------------------------------------
        // プロパティ
        // ----------------------------------------
        #region Properties

        public DynamicViewModel WindowsLayoutVM
        {
            get;
            set;
        }

        #endregion

        // ----------------------------------------
        // コンストラクタ
        // ----------------------------------------
        #region Constructor

        private DocumentManager()
        {
            WindowsLayoutVM = new DynamicViewModel(_windowLayout);
        }

        #endregion

        #region -----シリアライズ関係

        public SerializeData GetSerializeData()
        {
            var data = new SerializeData();
            data.WindowLayoutSerialize = _windowLayout.GetSerializeData();

            return data;
        }

        public void LoadSerializeData(SerializeData data)
        {
            if (data == null)
            {
                return;
            }
            _windowLayout.LoadSerializeData(data.WindowLayoutSerialize);
        }

        #endregion

    }
}
